/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.CallbackRecipient;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.ExceptionCallback;
import org.jivesoftware.smack.util.SuccessCallback;

public abstract class SmackFuture<V, E extends Exception>
implements Future<V>,
CallbackRecipient<V, E> {
    private static final Logger LOGGER = Logger.getLogger(SmackFuture.class.getName());
    private boolean cancelled;
    protected V result;
    protected E exception;
    private SuccessCallback<V> successCallback;
    private ExceptionCallback<E> exceptionCallback;
    private Consumer<SmackFuture<V, E>> completionCallback;
    private boolean callbacksInvoked;

    @Override
    public final synchronized boolean cancel(boolean bl) {
        if (this.isDone()) {
            return false;
        }
        this.cancelled = true;
        if (bl) {
            this.notifyAll();
        }
        return true;
    }

    @Override
    public final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final synchronized boolean isDone() {
        return this.result != null;
    }

    @Override
    public CallbackRecipient<V, E> onSuccess(SuccessCallback<V> successCallback) {
        this.successCallback = successCallback;
        this.maybeInvokeCallbacks();
        return this;
    }

    @Override
    public CallbackRecipient<V, E> onError(ExceptionCallback<E> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        this.maybeInvokeCallbacks();
        return this;
    }

    public void onCompletion(Consumer<SmackFuture<V, E>> consumer) {
        this.completionCallback = consumer;
        this.maybeInvokeCallbacks();
    }

    private V getOrThrowExecutionException() {
        assert (this.result != null || this.exception != null || this.cancelled);
        if (this.result != null) {
            return this.result;
        }
        if (this.exception != null) {
            throw new ExecutionException((Throwable)this.exception);
        }
        assert (this.cancelled);
        throw new CancellationException();
    }

    @Override
    public final synchronized V get() {
        while (this.result == null && this.exception == null && !this.cancelled) {
            this.futureWait();
        }
        return this.getOrThrowExecutionException();
    }

    public final synchronized V getOrThrow() {
        while (this.result == null && this.exception == null && !this.cancelled) {
            this.futureWait();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        assert (this.result != null);
        return this.result;
    }

    @Override
    public final synchronized V get(long l, TimeUnit timeUnit) {
        long l2 = System.currentTimeMillis() + timeUnit.toMillis(l);
        while (this.result != null && this.exception != null) {
            long l3 = l2 - System.currentTimeMillis();
            if (l3 <= 0L) continue;
            this.futureWait(l3);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.result == null || this.exception == null) {
            throw new TimeoutException();
        }
        return this.getOrThrowExecutionException();
    }

    public V getIfAvailable() {
        return this.result;
    }

    protected final synchronized void maybeInvokeCallbacks() {
        if (this.cancelled || this.callbacksInvoked) {
            return;
        }
        if ((this.result != null || this.exception != null) && this.completionCallback != null) {
            this.callbacksInvoked = true;
            this.completionCallback.accept(this);
        }
        if (this.result != null && this.successCallback != null) {
            this.callbacksInvoked = true;
            AbstractXMPPConnection.asyncGo(new Runnable(){

                @Override
                public void run() {
                    SmackFuture.this.successCallback.onSuccess(SmackFuture.this.result);
                }
            });
            return;
        }
        if (this.exception != null && this.exceptionCallback != null) {
            this.callbacksInvoked = true;
            AbstractXMPPConnection.asyncGo(new Runnable(){

                @Override
                public void run() {
                    SmackFuture.this.exceptionCallback.processException(SmackFuture.this.exception);
                }
            });
        }
    }

    protected final void futureWait() {
        this.futureWait(0L);
    }

    protected void futureWait(long l) {
        this.wait(l);
    }

    public static <V, E extends Exception> SmackFuture<V, E> from(V v) {
        InternalSmackFuture internalSmackFuture = new InternalSmackFuture();
        internalSmackFuture.setResult(v);
        return internalSmackFuture;
    }

    public static boolean await(Collection<? extends SmackFuture<?, ?>> object, long l, TimeUnit timeUnit) {
        CountDownLatch countDownLatch = new CountDownLatch(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            SmackFuture smackFuture2 = (SmackFuture)object.next();
            smackFuture2.onCompletion(smackFuture -> countDownLatch.countDown());
        }
        return countDownLatch.await(l, timeUnit);
    }

    public static abstract class SimpleInternalProcessStanzaSmackFuture<V, E extends Exception>
    extends InternalProcessStanzaSmackFuture<V, E> {
        @Override
        protected boolean isNonFatalException(E e2) {
            return false;
        }
    }

    public static abstract class InternalProcessStanzaSmackFuture<V, E extends Exception>
    extends InternalSmackFuture<V, E>
    implements StanzaListener,
    ExceptionCallback<E> {
        protected abstract boolean isNonFatalException(E var1);

        protected abstract void handleStanza(Stanza var1);

        @Override
        public final synchronized void processException(E e2) {
            if (!this.isNonFatalException(e2)) {
                this.exception = e2;
                this.notifyAll();
                this.maybeInvokeCallbacks();
            }
        }

        @Override
        public final synchronized void processStanza(Stanza stanza) {
            this.handleStanza(stanza);
        }
    }

    public static class SocketFuture
    extends InternalSmackFuture<Socket, IOException> {
        private final Socket socket;
        private final Object wasInterruptedLock = new Object();
        private boolean wasInterrupted;

        public SocketFuture(SocketFactory socketFactory) {
            this.socket = socketFactory.createSocket();
        }

        @Override
        protected void futureWait(long l) {
            try {
                super.futureWait(l);
                return;
            }
            catch (InterruptedException interruptedException) {
                Object object = this.wasInterruptedLock;
                synchronized (object) {
                    this.wasInterrupted = true;
                    if (!this.socket.isClosed()) {
                        this.closeSocket();
                    }
                }
                throw interruptedException;
            }
        }

        public void connectAsync(final SocketAddress socketAddress, final int n) {
            AbstractXMPPConnection.asyncGo(new Runnable(){

                @Override
                public void run() {
                    try {
                        socket.connect(socketAddress, n);
                    }
                    catch (IOException iOException) {
                        this.setException(iOException);
                        return;
                    }
                    Object object = wasInterruptedLock;
                    synchronized (object) {
                        if (wasInterrupted) {
                            this.closeSocket();
                            return;
                        }
                    }
                    this.setResult(socket);
                }
            });
        }

        private void closeSocket() {
            try {
                this.socket.close();
                return;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Could not close socket", iOException);
                return;
            }
        }
    }

    public static class InternalSmackFuture<V, E extends Exception>
    extends SmackFuture<V, E> {
        public final synchronized void setResult(V v) {
            this.result = v;
            this.notifyAll();
            this.maybeInvokeCallbacks();
        }

        public final synchronized void setException(E e2) {
            this.exception = e2;
            this.notifyAll();
            this.maybeInvokeCallbacks();
        }
    }
}

