/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compression;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModule;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.c2s.internal.WalkStateGraphContext;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.compress.packet.Compressed;
import org.jivesoftware.smack.compress.packet.Failure;
import org.jivesoftware.smack.compression.CompressionModuleDescriptor;
import org.jivesoftware.smack.compression.XmppCompressionFactory;
import org.jivesoftware.smack.compression.XmppCompressionManager;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateTransitionResult;

public class CompressionModule
extends ModularXmppClientToServerConnectionModule<CompressionModuleDescriptor> {
    protected CompressionModule(CompressionModuleDescriptor compressionModuleDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        super(compressionModuleDescriptor, modularXmppClientToServerConnectionInternal);
    }

    public CompressionState constructCompressionState(CompressionStateDescriptor compressionStateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        return new CompressionState(compressionStateDescriptor, modularXmppClientToServerConnectionInternal);
    }

    public static final class CompressionTransitionSuccessResult
    extends StateTransitionResult.Success {
        private final String compressionMethod;

        private CompressionTransitionSuccessResult(String string) {
            super(string + " compression enabled");
            this.compressionMethod = string;
        }

        public final String getCompressionMethod() {
            return this.compressionMethod;
        }
    }

    private static final class CompressionState
    extends State {
        private XmppCompressionFactory selectedCompressionFactory;
        private XmppInputOutputFilter usedXmppInputOutputCompressionFitler;

        private CompressionState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            super(stateDescriptor, modularXmppClientToServerConnectionInternal);
        }

        @Override
        public final StateTransitionResult.TransitionImpossible isTransitionToPossible(WalkStateGraphContext object) {
            object = this.connectionInternal.connection.getConfiguration();
            if (!((ConnectionConfiguration)object).isCompressionEnabled()) {
                return new StateTransitionResult.TransitionImpossibleReason("Stream compression disabled by connection configuration");
            }
            Compress.Feature feature = this.connectionInternal.connection.getFeature(Compress.Feature.class);
            if (feature == null) {
                return new StateTransitionResult.TransitionImpossibleReason("Stream compression not supported or enabled by service");
            }
            this.selectedCompressionFactory = XmppCompressionManager.getBestFactory(feature);
            if (this.selectedCompressionFactory == null) {
                return new StateTransitionResult.TransitionImpossibleReason("No matching compression factory for " + feature.getMethods());
            }
            this.usedXmppInputOutputCompressionFitler = this.selectedCompressionFactory.fabricate((ConnectionConfiguration)object);
            return null;
        }

        @Override
        public final StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext object) {
            object = this.selectedCompressionFactory.getCompressionMethod();
            this.connectionInternal.sendAndWaitForResponse(new Compress((String)object), Compressed.class, Failure.class);
            this.connectionInternal.addXmppInputOutputFilter(this.usedXmppInputOutputCompressionFitler);
            this.connectionInternal.newStreamOpenWaitForFeaturesSequence("server stream features after compression enabled");
            this.connectionInternal.setCompressionEnabled(true);
            return new CompressionTransitionSuccessResult((String)object);
        }

        @Override
        public final void resetState() {
            this.selectedCompressionFactory = null;
            this.usedXmppInputOutputCompressionFitler = null;
            this.connectionInternal.setCompressionEnabled(false);
        }
    }

    public static final class CompressionStateDescriptor
    extends StateDescriptor {
        private CompressionStateDescriptor() {
            super(CompressionState.class, 138);
            this.addPredeccessor(ModularXmppClientToServerConnection.AuthenticatedButUnboundStateDescriptor.class);
            this.addSuccessor(ModularXmppClientToServerConnection.AuthenticatedButUnboundStateDescriptor.class);
            this.declarePrecedenceOver(ModularXmppClientToServerConnection.ResourceBindingStateDescriptor.class);
        }

        @Override
        protected final CompressionState constructState(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            CompressionModule compressionModule = (CompressionModule)modularXmppClientToServerConnectionInternal.connection.getConnectionModuleFor(CompressionModuleDescriptor.class);
            return compressionModule.constructCompressionState(this, modularXmppClientToServerConnectionInternal);
        }
    }
}

