/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.datatypes;

import org.jivesoftware.smack.datatypes.Scalar;
import org.jivesoftware.smack.util.NumberUtil;

public final class UInt32
extends Scalar {
    private static final long serialVersionUID = 1L;
    private final long number;
    public static final long MIN_VALUE_LONG = 0L;
    public static final long MAX_VALUE_LONG = 0xFFFFFFFFL;
    public static final UInt32 MIN_VALUE = UInt32.from(0xFFFFFFFFL);
    public static final UInt32 MAX_VALUE = UInt32.from(0xFFFFFFFFL);

    private UInt32(long l) {
        super(NumberUtil.requireUInt32(l));
        this.number = l;
    }

    public final long nativeRepresentation() {
        return this.number;
    }

    public static UInt32 from(long l) {
        return new UInt32(l);
    }

    @Override
    public final int hashCode() {
        return (int)(this.number ^ this.number >>> 32);
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof UInt32) {
            object = (UInt32)object;
            return this.number == ((UInt32)object).number;
        }
        return super.equals(object);
    }

    @Override
    public final UInt32 getMinValue() {
        return MIN_VALUE;
    }

    @Override
    public final UInt32 getMaxValue() {
        return MAX_VALUE;
    }

    @Override
    public final UInt32 incrementedByOne() {
        long l = this.number < 0xFFFFFFFFL ? this.number + 1L : 0L;
        return UInt32.from(l);
    }
}

