/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    public static <T> Collection<T> requireNotEmpty(Collection<T> collection, String string) {
        if (collection == null) {
            throw new NullPointerException(string + " must not be null.");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(string + " must not be empty.");
        }
        return collection;
    }

    public static <T, C extends Collection<T>> List<T> removeUntil(C object, Predicate<T> predicate) {
        Object e2;
        ArrayList arrayList = new ArrayList(object.size());
        object = object.iterator();
        while (object.hasNext() && !predicate.test(e2 = object.next())) {
            arrayList.add(e2);
            object.remove();
        }
        return arrayList;
    }

    public static <T> ArrayList<T> newListWith(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> cloneAndSeal(Collection<? extends T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        collection = CollectionUtil.newListWith(collection);
        return Collections.unmodifiableList(collection);
    }

    public static <K, V> Map<K, V> cloneAndSeal(Map<K, V> map) {
        map = new HashMap<K, V>(map);
        return Collections.unmodifiableMap(map);
    }

    public static <T> Set<T> newSetWith(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        return new HashSet<T>(collection);
    }

    public static <T> List<T> emptyOrSingletonListFrom(T t) {
        if (t == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(t);
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

