/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlUtil {
    private static final Logger LOGGER = Logger.getLogger(XmlUtil.class.getName());
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public static String prettyFormatXml(CharSequence charSequence) {
        charSequence = charSequence.toString();
        StreamSource streamSource = new StreamSource(new StringReader((String)charSequence));
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(streamSource, streamResult);
        }
        catch (IllegalArgumentException | TransformerException exception) {
            LOGGER.log(Level.SEVERE, "Transformer error", exception);
            return charSequence;
        }
        return stringWriter.toString();
    }

    public static boolean isClarkNotation(String string) {
        if (string.isEmpty()) {
            return false;
        }
        return string.charAt(0) == '{';
    }

    static {
        try {
            transformerFactory.setAttribute("indent-number", 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.log(Level.INFO, "XML TransformerFactory does not support indent-number attribute", illegalArgumentException);
        }
    }
}

