/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SocketNode;
import ch.qos.logback.core.Context;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.net.ServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSocketServer
extends Thread {
    Logger logger = LoggerFactory.getLogger(SimpleSocketServer.class);
    private final int port;
    private final LoggerContext lc;
    private boolean closed = false;
    private ServerSocket serverSocket;
    private List<SocketNode> socketNodeList = new ArrayList<SocketNode>();
    private CountDownLatch latch;

    public static void main(String[] stringArray) {
        SimpleSocketServer.doMain(SimpleSocketServer.class, stringArray);
    }

    protected static void doMain(Class<? extends SimpleSocketServer> clazz, String[] object) {
        int n = -1;
        if (((String[])object).length == 2) {
            n = SimpleSocketServer.parsePortNumber(object[0]);
        } else {
            SimpleSocketServer.usage("Wrong number of arguments.");
        }
        object = object[1];
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        SimpleSocketServer.configureLC(loggerContext, (String)object);
        SimpleSocketServer simpleSocketServer = new SimpleSocketServer(loggerContext, n);
        simpleSocketServer.start();
    }

    public SimpleSocketServer(LoggerContext loggerContext, int n) {
        this.lc = loggerContext;
        this.port = n;
    }

    @Override
    public void run() {
        String string = Thread.currentThread().getName();
        try {
            Object object = this.getServerThreadName();
            Thread.currentThread().setName((String)object);
            this.logger.info("Listening on port " + this.port);
            this.serverSocket = this.getServerSocketFactory().createServerSocket(this.port);
            while (!this.closed) {
                this.logger.info("Waiting to accept a new client.");
                this.signalAlmostReadiness();
                object = this.serverSocket.accept();
                this.logger.info("Connected to client at " + String.valueOf(((Socket)object).getInetAddress()));
                this.logger.info("Starting new socket node.");
                SocketNode socketNode = new SocketNode(this, (Socket)object, this.lc);
                Object object2 = this.socketNodeList;
                synchronized (object2) {
                    this.socketNodeList.add(socketNode);
                }
                object2 = this.getClientThreadName((Socket)object);
                new Thread((Runnable)socketNode, (String)object2).start();
            }
            return;
        }
        catch (Exception exception) {
            if (this.closed) {
                this.logger.info("Exception in run method for a closed server. This is normal.");
            } else {
                this.logger.error("Unexpected failure in run method", (Throwable)exception);
            }
            return;
        }
        finally {
            Thread.currentThread().setName(string);
        }
    }

    protected String getServerThreadName() {
        return String.format("Logback %s (port %d)", this.getClass().getSimpleName(), this.port);
    }

    protected String getClientThreadName(Socket socket) {
        return String.format("Logback SocketNode (client: %s)", socket.getRemoteSocketAddress());
    }

    protected ServerSocketFactory getServerSocketFactory() {
        return ServerSocketFactory.getDefault();
    }

    void signalAlmostReadiness() {
        if (this.latch != null && this.latch.getCount() != 0L) {
            this.latch.countDown();
        }
    }

    void setLatch(CountDownLatch countDownLatch) {
        this.latch = countDownLatch;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                this.logger.error("Failed to close serverSocket", (Throwable)iOException);
            }
            finally {
                this.serverSocket = null;
            }
        }
        this.logger.info("closing this server");
        List<SocketNode> list = this.socketNodeList;
        synchronized (list) {
            for (SocketNode socketNode : this.socketNodeList) {
                socketNode.close();
            }
        }
        if (this.socketNodeList.size() != 0) {
            this.logger.warn("Was expecting a 0-sized socketNodeList after server shutdown");
        }
    }

    public void socketNodeClosing(SocketNode socketNode) {
        this.logger.debug("Removing {}", (Object)socketNode);
        List<SocketNode> list = this.socketNodeList;
        synchronized (list) {
            this.socketNodeList.remove(socketNode);
            return;
        }
    }

    static void usage(String string) {
        System.err.println(string);
        System.err.println("Usage: java " + SimpleSocketServer.class.getName() + " port configFile");
        System.exit(1);
    }

    static int parsePortNumber(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            NumberFormatException numberFormatException2 = numberFormatException;
            numberFormatException.printStackTrace();
            SimpleSocketServer.usage("Could not interpret port number [" + string + "].");
            return -1;
        }
    }

    public static void configureLC(LoggerContext loggerContext, String string) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        loggerContext.reset();
        joranConfigurator.setContext((Context)loggerContext);
        joranConfigurator.doConfigure(string);
    }
}

