/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ChunkedNioStream
implements ChunkedInput<ByteBuf> {
    private final ReadableByteChannel in;
    private final int chunkSize;
    private long offset;
    private final ByteBuffer byteBuffer;

    public ChunkedNioStream(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, 8192);
    }

    public ChunkedNioStream(ReadableByteChannel readableByteChannel, int n) {
        this.in = (ReadableByteChannel)ObjectUtil.checkNotNull((Object)readableByteChannel, (String)"in");
        this.chunkSize = ObjectUtil.checkPositive((int)n, (String)"chunkSize");
        this.byteBuffer = ByteBuffer.allocate(n);
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        if (this.byteBuffer.position() > 0) {
            return false;
        }
        if (this.in.isOpen()) {
            int n = this.in.read(this.byteBuffer);
            if (n < 0) {
                return true;
            }
            this.offset += (long)n;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) {
        int n;
        if (this.isEndOfInput()) {
            return null;
        }
        int n2 = this.byteBuffer.position();
        while ((n = this.in.read(this.byteBuffer)) >= 0) {
            this.offset += (long)n;
            if ((n2 += n) != this.chunkSize) continue;
        }
        this.byteBuffer.flip();
        n = 1;
        byteBufAllocator = byteBufAllocator.buffer(this.byteBuffer.remaining());
        try {
            byteBufAllocator.writeBytes(this.byteBuffer);
            this.byteBuffer.clear();
            n = 0;
            ByteBufAllocator byteBufAllocator2 = byteBufAllocator;
            return byteBufAllocator2;
        }
        catch (Throwable throwable) {
            if (n != 0) {
                byteBufAllocator.release();
            }
            throw throwable;
        }
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

