/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.exit;

import dorkbox.exit.ExitBase;
import dorkbox.exit.ExitError;
import dorkbox.exit.ExitRestart;
import dorkbox.os.OS;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class Exit {
    private static int UNDEFINED = -1;
    private static int NORMAL = 0;
    private static int FAILED_CONFIG = 1;
    private static int FAILED_INIT = 2;
    private static int FAILED_SECURITY = 3;
    private static int RESERVED = 100;
    private static List<Integer> RESERVED_LIST = new ArrayList<Integer>(2);
    private static int SAVED_IN_LOG_FILE = 101;
    private static int RESTART = 102;
    private static int UPGRADE_EXECUTABLE = 103;
    private static AtomicInteger exitValue;
    private static ExitBase exitError;

    private static native void setExitError(String var0);

    private static native boolean isNative0();

    public static final boolean isNative() {
        try {
            return Exit.isNative0();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private Exit() {
    }

    public static int getExitValue() {
        Exit._setExitData(exitError);
        int n = exitValue.get();
        if (n > RESERVED) {
            if (RESERVED_LIST.contains(exitError)) {
                return n;
            }
            Exit.setExitError("You cannot use any number greater than 99");
            return RESERVED;
        }
        return n;
    }

    public static int getExitDuringException(ExitBase exitBase) {
        if (exitError != null) {
            Exit._setExitData(exitError);
        } else {
            Exit._setExitData(exitBase);
        }
        int n = exitValue.get();
        if (n > RESERVED) {
            if (RESERVED_LIST.contains(exitBase)) {
                return n;
            }
            Exit.setExitError("You cannot use any number greater than 99");
            return RESERVED;
        }
        return n;
    }

    public static void writeToLogFile(String string, String string2) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("error.log", true));){
            if (string2 != null) {
                if (string != null) {
                    bufferedWriter.write(string);
                    bufferedWriter.write(OS.INSTANCE.getLINE_SEPARATOR() + "   ");
                }
                bufferedWriter.write(new Date() + OS.INSTANCE.getLINE_SEPARATOR() + "     ");
                bufferedWriter.write(string2);
                bufferedWriter.write(OS.INSTANCE.getLINE_SEPARATOR());
            } else {
                bufferedWriter.write("Execption thrown! Unknown error.");
            }
            bufferedWriter.write(OS.INSTANCE.getLINE_SEPARATOR());
        }
        catch (IOException iOException) {}
    }

    public static void handleUncaughtException(Throwable throwable) {
        if (!(throwable instanceof ExitBase)) {
            String string = throwable.getMessage();
            if (string == null) {
                string = Exit.getStackStrace(throwable);
            }
            Exit.writeToLogFile("Uncaught Exception: " + throwable.getClass(), string);
            Exit._throwIfLaunching(new ExitError(UNDEFINED, "Abnormal termination from an uncaught exception! See log file.)"));
        }
    }

    public static int Undefined(Throwable throwable) {
        Object object = throwable.getMessage();
        if (object == null) {
            object = new ByteArrayOutputStream(8196);
            PrintStream printStream = new PrintStream((OutputStream)object);
            throwable.printStackTrace(printStream);
            object = ((ByteArrayOutputStream)object).toString();
            printStream.close();
        }
        object = throwable.getClass().toString() + " : " + (String)object;
        Exit.writeToLogFile("Error", (String)object);
        return Exit.Generic(UNDEFINED, "Undefined exception! Saved in log file.", (String)object);
    }

    public static int Normal() {
        return Exit.Generic(NORMAL, "Normal exit called.");
    }

    public static int FailedConfiguration(String string, Throwable throwable) {
        return Exit.Generic(FAILED_CONFIG, "FailedConfiguration called: " + string, throwable);
    }

    public static int FailedInitialization(Throwable throwable) {
        return Exit.Generic(FAILED_INIT, "FailedInitialization called: " + throwable.getMessage(), throwable);
    }

    public static int FailedConfiguration(String string) {
        return Exit.Generic(FAILED_CONFIG, "FailedConfiguration called: " + string);
    }

    public static int FailedInitialization(String string, Throwable throwable) {
        return Exit.Generic(FAILED_INIT, "FailedInitialization called: " + string, throwable);
    }

    public static int FailedInitialization(String string) {
        return Exit.Generic(FAILED_INIT, "FailedInitialization called: " + string);
    }

    public static int FailedSecurity(Throwable throwable) {
        return Exit.Generic(FAILED_SECURITY, "FailedSecurity called: " + throwable.getMessage(), throwable);
    }

    public static int FailedSecurity(String string, Throwable throwable) {
        return Exit.Generic(FAILED_SECURITY, "FailedSecurity called: " + string, throwable);
    }

    public static int FailedSecurity(String string) {
        return Exit.Generic(FAILED_SECURITY, "FailedSecurity called: " + string);
    }

    public static int Generic(int n, String string, Throwable throwable) {
        return Exit.Generic(n, string + OS.INSTANCE.getLINE_SEPARATOR() + throwable.getClass() + OS.INSTANCE.getLINE_SEPARATOR() + throwable.getMessage());
    }

    public static int Generic(int n, String string) {
        Exit._throwIfLaunching(new ExitError(n, string));
        return n;
    }

    public static int Generic(int n, String string, String string2) {
        Exit._throwIfLaunching(new ExitError(n, string, string2));
        return n;
    }

    public static void Restart() {
        Exit._throwIfLaunching(new ExitRestart(RESTART));
    }

    public static void UpgradeExectuable() {
        Exit._throwIfLaunching(new ExitRestart(UPGRADE_EXECUTABLE));
    }

    static void _setExitData(ExitBase exitBase) {
        if (exitBase == null) {
            return;
        }
        exitValue.set(exitBase.getExitCode());
        if (exitBase.getMessage() != null) {
            String string = exitBase.getMessage();
            if (Exit.isNative()) {
                if (exitBase.getTitle() != null) {
                    Exit.setExitError("<title>" + exitBase.getTitle() + "</title>" + OS.INSTANCE.getLINE_SEPARATOR() + string);
                    return;
                }
                Exit.setExitError(string);
            }
        }
    }

    static void _setExitCode(int n) {
        exitValue.set(n);
    }

    static void _throwIfLaunching(ExitBase exitBase) {
        if (exitBase != null && exitError == null) {
            exitError = exitBase;
        }
        if (exitBase != null) {
            throw exitBase;
        }
        throw new ExitError(FAILED_INIT, "Unable to have a null errorMessage!");
    }

    public static String getStackStrace(Throwable object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        ((Throwable)object).printStackTrace(printStream);
        object = byteArrayOutputStream.toString();
        printStream.flush();
        printStream.close();
        return object;
    }

    public final Object clone() {
        throw new CloneNotSupportedException();
    }

    public final void writeObject(ObjectOutputStream objectOutputStream) {
        throw new NotSerializableException();
    }

    public final void readObject(ObjectInputStream objectInputStream) {
        throw new NotSerializableException();
    }

    static {
        RESERVED_LIST.add(SAVED_IN_LOG_FILE);
        RESERVED_LIST.add(RESTART);
        RESERVED_LIST.add(UPGRADE_EXECUTABLE);
        exitValue = new AtomicInteger(NORMAL);
        exitError = null;
    }
}

