/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.properties;

import dorkbox.util.properties.SortedProperties;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J0\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u0011H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003J\u001a\u0010\u0014\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldorkbox/util/properties/PropertiesProvider;", "", "propertiesFile", "", "(Ljava/lang/String;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "comments", "properties", "Ljava/util/Properties;", "_load", "", "_save", "get", "T", "key", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "remove", "save", "value", "setComments", "toString", "Utilities"})
public final class PropertiesProvider {
    private final Properties properties;
    private final File propertiesFile;
    private String comments;

    public PropertiesProvider(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        this.properties = new SortedProperties();
        this.comments = "Settings and configuration file. Strings must be escape formatted!";
        file = FilesKt.normalize((File)file);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            throw new RuntimeException("Unable to create directories for: " + file);
        }
        this.propertiesFile = file;
        this._load();
    }

    public PropertiesProvider(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this(new File(string));
    }

    public final void setComments(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.comments = string;
    }

    private final void _load() {
        if (!this.propertiesFile.canRead() || !this.propertiesFile.exists()) {
            this._save();
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.propertiesFile);
            this.properties.load(fileInputStream);
            fileInputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            System.err.println("Properties cannot load!");
            iOException.printStackTrace();
            return;
        }
    }

    private final void _save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.propertiesFile);
            this.properties.store(fileOutputStream, this.comments);
            fileOutputStream.flush();
            fileOutputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            System.err.println("Properties cannot save!");
            return;
        }
        catch (IOException iOException) {
            System.err.println("Properties cannot save!");
            iOException.printStackTrace();
            return;
        }
    }

    public final synchronized void remove(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.properties.remove(string);
        this._save();
    }

    public final synchronized void save(String string, Object object) {
        if (string == null || object == null) {
            return;
        }
        if (object instanceof Color) {
            object = ((Color)object).getRGB();
        }
        this.properties.setProperty(string, object.toString());
        this._save();
    }

    public final synchronized <T> T get(String string, Class<T> object) {
        if (string == null || object == null) {
            return null;
        }
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            return null;
        }
        String string3 = string2;
        try {
            if (Intrinsics.areEqual(object, Integer.TYPE)) {
                return (T)((Object)Integer.parseInt(string3));
            }
            if (Intrinsics.areEqual(object, Long.TYPE)) {
                return (T)((Object)Long.parseLong(string3));
            }
            object = Intrinsics.areEqual(object, Color.class) ? (Object)new Color(Integer.parseInt(string3), true) : (Object)string3;
        }
        catch (Exception exception) {
            throw new RuntimeException("Properties Loader for property: " + string + System.getProperty("line.separator") + exception.getMessage());
        }
        return (T)object;
    }

    public final String toString() {
        return "PropertiesProvider [" + this.propertiesFile + ']';
    }
}

