/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.ReadOnlyHttp2Headers;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Http2ConnectionHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler,
Http2LifecycleManager {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ConnectionHandler.class);
    private static final Http2Headers HEADERS_TOO_LARGE_HEADERS = ReadOnlyHttp2Headers.serverHeaders(false, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.codeAsText(), new AsciiString[0]);
    private static final ByteBuf HTTP_1_X_BUF = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{72, 84, 84, 80, 47, 49, 46})).asReadOnly();
    private final Http2ConnectionDecoder decoder;
    private final Http2ConnectionEncoder encoder;
    private final Http2Settings initialSettings;
    private final boolean decoupleCloseAndGoAway;
    private final boolean flushPreface;
    private ChannelFutureListener closeListener;
    private BaseDecoder byteDecoder;
    private long gracefulShutdownTimeoutMillis;

    protected Http2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings) {
        this(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, false);
    }

    protected Http2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl) {
        this(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl, true);
    }

    protected Http2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl, boolean bl2) {
        this.initialSettings = (Http2Settings)((Object)ObjectUtil.checkNotNull((Object)((Object)http2Settings), (String)"initialSettings"));
        this.decoder = (Http2ConnectionDecoder)ObjectUtil.checkNotNull((Object)http2ConnectionDecoder, (String)"decoder");
        this.encoder = (Http2ConnectionEncoder)ObjectUtil.checkNotNull((Object)http2ConnectionEncoder, (String)"encoder");
        this.decoupleCloseAndGoAway = bl;
        this.flushPreface = bl2;
        if (http2ConnectionEncoder.connection() != http2ConnectionDecoder.connection()) {
            throw new IllegalArgumentException("Encoder and Decoder do not share the same connection object");
        }
    }

    public long gracefulShutdownTimeoutMillis() {
        return this.gracefulShutdownTimeoutMillis;
    }

    public void gracefulShutdownTimeoutMillis(long l) {
        if (l < -1L) {
            throw new IllegalArgumentException("gracefulShutdownTimeoutMillis: " + l + " (expected: -1 for indefinite or >= 0)");
        }
        this.gracefulShutdownTimeoutMillis = l;
    }

    public Http2Connection connection() {
        return this.encoder.connection();
    }

    public Http2ConnectionDecoder decoder() {
        return this.decoder;
    }

    public Http2ConnectionEncoder encoder() {
        return this.encoder;
    }

    private boolean prefaceSent() {
        return this.byteDecoder != null && this.byteDecoder.prefaceSent();
    }

    public void onHttpClientUpgrade() {
        if (this.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client-side HTTP upgrade requested for a server", new Object[0]);
        }
        if (!this.prefaceSent()) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "HTTP upgrade must occur after preface was sent", new Object[0]);
        }
        if (this.decoder.prefaceReceived()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP upgrade must occur before HTTP/2 preface is received", new Object[0]);
        }
        this.connection().local().createStream(1, true);
    }

    public void onHttpServerUpgrade(Http2Settings http2Settings) {
        if (!this.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server-side HTTP upgrade requested for a client", new Object[0]);
        }
        if (!this.prefaceSent()) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "HTTP upgrade must occur after preface was sent", new Object[0]);
        }
        if (this.decoder.prefaceReceived()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP upgrade must occur before HTTP/2 preface is received", new Object[0]);
        }
        this.encoder.remoteSettings(http2Settings);
        this.connection().remote().createStream(1, true);
    }

    public void flush(ChannelHandlerContext channelHandlerContext) {
        try {
            this.encoder.flowController().writePendingBytes();
            channelHandlerContext.flush();
            return;
        }
        catch (Http2Exception http2Exception) {
            this.onError(channelHandlerContext, true, http2Exception);
            return;
        }
        catch (Throwable throwable) {
            this.onError(channelHandlerContext, true, Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Error flushing", new Object[0]));
            return;
        }
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.encoder.lifecycleManager(this);
        this.decoder.lifecycleManager(this);
        this.encoder.flowController().channelHandlerContext(channelHandlerContext);
        this.decoder.flowController().channelHandlerContext(channelHandlerContext);
        this.byteDecoder = new PrefaceDecoder(channelHandlerContext);
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        if (this.byteDecoder != null) {
            this.byteDecoder.handlerRemoved(channelHandlerContext);
            this.byteDecoder = null;
        }
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        if (this.byteDecoder == null) {
            this.byteDecoder = new PrefaceDecoder(channelHandlerContext);
        }
        this.byteDecoder.channelActive(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        super.channelInactive(channelHandlerContext);
        if (this.byteDecoder != null) {
            this.byteDecoder.channelInactive(channelHandlerContext);
            this.byteDecoder = null;
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        try {
            if (channelHandlerContext.channel().isWritable()) {
                this.flush(channelHandlerContext);
            }
            this.encoder.flowController().channelWritabilityChanged();
            return;
        }
        finally {
            super.channelWritabilityChanged(channelHandlerContext);
        }
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.byteDecoder.decode(channelHandlerContext, byteBuf, list);
    }

    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.decoupleCloseAndGoAway) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        channelPromise = channelPromise.unvoid();
        if (!channelHandlerContext.channel().isActive() || !this.prefaceSent()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ChannelFuture channelFuture = this.connection().goAwaySent() ? channelHandlerContext.write((Object)Unpooled.EMPTY_BUFFER) : this.goAway(channelHandlerContext, null, channelHandlerContext.newPromise());
        channelHandlerContext.flush();
        this.doGracefulShutdown(channelHandlerContext, channelFuture, channelPromise);
    }

    private ChannelFutureListener newClosingChannelFutureListener(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        long l = this.gracefulShutdownTimeoutMillis;
        if (l < 0L) {
            return new ClosingChannelFutureListener(channelHandlerContext, channelPromise);
        }
        return new ClosingChannelFutureListener(channelHandlerContext, channelPromise, l, TimeUnit.MILLISECONDS);
    }

    private void doGracefulShutdown(ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        channelHandlerContext = this.newClosingChannelFutureListener(channelHandlerContext, channelPromise);
        if (this.isGracefulShutdownComplete()) {
            channelFuture.addListener((GenericFutureListener)channelHandlerContext);
            return;
        }
        if (this.closeListener == null) {
            this.closeListener = channelHandlerContext;
            return;
        }
        if (channelPromise != null) {
            channelFuture = this.closeListener;
            this.closeListener = new ChannelFutureListener((ChannelFutureListener)channelFuture, (ChannelFutureListener)channelHandlerContext){
                final /* synthetic */ ChannelFutureListener val$oldCloseListener;
                final /* synthetic */ ChannelFutureListener val$listener;
                {
                    this.val$oldCloseListener = channelFutureListener;
                    this.val$listener = channelFutureListener2;
                }

                public void operationComplete(ChannelFuture channelFuture) {
                    try {
                        this.val$oldCloseListener.operationComplete((Future)channelFuture);
                        return;
                    }
                    finally {
                        this.val$listener.operationComplete((Future)channelFuture);
                    }
                }
            };
        }
    }

    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    public void read(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.read();
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        channelHandlerContext.write(object, channelPromise);
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        try {
            this.channelReadComplete0(channelHandlerContext);
            return;
        }
        finally {
            this.flush(channelHandlerContext);
        }
    }

    final void channelReadComplete0(ChannelHandlerContext channelHandlerContext) {
        this.discardSomeReadBytes();
        if (!channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (Http2CodecUtil.getEmbeddedHttp2Exception(throwable) != null) {
            this.onError(channelHandlerContext, false, throwable);
            return;
        }
        super.exceptionCaught(channelHandlerContext, throwable);
    }

    @Override
    public void closeStreamLocal(Http2Stream http2Stream, ChannelFuture channelFuture) {
        switch (http2Stream.state()) {
            case HALF_CLOSED_LOCAL: 
            case OPEN: {
                http2Stream.closeLocalSide();
                return;
            }
        }
        this.closeStream(http2Stream, channelFuture);
    }

    @Override
    public void closeStreamRemote(Http2Stream http2Stream, ChannelFuture channelFuture) {
        switch (http2Stream.state()) {
            case OPEN: 
            case HALF_CLOSED_REMOTE: {
                http2Stream.closeRemoteSide();
                return;
            }
        }
        this.closeStream(http2Stream, channelFuture);
    }

    @Override
    public void closeStream(final Http2Stream http2Stream, ChannelFuture channelFuture) {
        if (channelFuture.isDone()) {
            this.doCloseStream(http2Stream, channelFuture);
            return;
        }
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                Http2ConnectionHandler.this.doCloseStream(http2Stream, channelFuture);
            }
        });
    }

    @Override
    public void onError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable) {
        Object object = Http2CodecUtil.getEmbeddedHttp2Exception(throwable);
        if (Http2Exception.isStreamError((Http2Exception)object)) {
            this.onStreamError(channelHandlerContext, bl, throwable, (Http2Exception.StreamException)object);
        } else if (object instanceof Http2Exception.CompositeStreamException) {
            object = (Http2Exception.CompositeStreamException)object;
            object = ((Http2Exception.CompositeStreamException)object).iterator();
            while (object.hasNext()) {
                Http2Exception.StreamException streamException = (Http2Exception.StreamException)object.next();
                this.onStreamError(channelHandlerContext, bl, throwable, streamException);
            }
        } else {
            this.onConnectionError(channelHandlerContext, bl, throwable, (Http2Exception)object);
        }
        channelHandlerContext.flush();
    }

    protected boolean isGracefulShutdownComplete() {
        return this.connection().numActiveStreams() == 0;
    }

    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception http2Exception) {
        if (http2Exception == null) {
            http2Exception = new Http2Exception(Http2Error.INTERNAL_ERROR, throwable.getMessage(), throwable);
        }
        ChannelPromise channelPromise = channelHandlerContext.newPromise();
        throwable = this.goAway(channelHandlerContext, http2Exception, channelHandlerContext.newPromise());
        if (http2Exception.shutdownHint() == Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN) {
            this.doGracefulShutdown(channelHandlerContext, (ChannelFuture)throwable, channelPromise);
            return;
        }
        throwable.addListener((GenericFutureListener)this.newClosingChannelFutureListener(channelHandlerContext, channelPromise));
    }

    protected void onStreamError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception.StreamException streamException) {
        int n = streamException.streamId();
        Http2Stream http2Stream = this.connection().stream(n);
        if (streamException instanceof Http2Exception.HeaderListSizeException && ((Http2Exception.HeaderListSizeException)streamException).duringDecode() && this.connection().isServer()) {
            if (http2Stream == null) {
                try {
                    http2Stream = this.encoder.connection().remote().createStream(n, true);
                }
                catch (Http2Exception http2Exception) {
                    this.resetUnknownStream(channelHandlerContext, n, streamException.error().code(), channelHandlerContext.newPromise());
                    return;
                }
            }
            if (http2Stream != null && !http2Stream.isHeadersSent()) {
                try {
                    this.handleServerHeaderDecodeSizeError(channelHandlerContext, http2Stream);
                }
                catch (Throwable throwable2) {
                    this.onError(channelHandlerContext, bl, Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable2, "Error DecodeSizeError", new Object[0]));
                }
            }
        }
        if (http2Stream == null) {
            if (!bl || this.connection().local().mayHaveCreatedStream(n)) {
                this.resetUnknownStream(channelHandlerContext, n, streamException.error().code(), channelHandlerContext.newPromise());
                return;
            }
        } else {
            this.resetStream(channelHandlerContext, http2Stream, streamException.error().code(), channelHandlerContext.newPromise());
        }
    }

    protected void handleServerHeaderDecodeSizeError(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream) {
        this.encoder().writeHeaders(channelHandlerContext, http2Stream.id(), HEADERS_TOO_LARGE_HEADERS, 0, true, channelHandlerContext.newPromise());
    }

    protected Http2FrameWriter frameWriter() {
        return this.encoder().frameWriter();
    }

    private ChannelFuture resetUnknownStream(final ChannelHandlerContext channelHandlerContext, int n, long l, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.frameWriter().writeRstStream(channelHandlerContext, n, l, channelPromise);
        if (channelFuture.isDone()) {
            this.closeConnectionOnError(channelHandlerContext, channelFuture);
        } else {
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    Http2ConnectionHandler.this.closeConnectionOnError(channelHandlerContext, channelFuture);
                }
            });
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture resetStream(ChannelHandlerContext channelHandlerContext, int n, long l, ChannelPromise channelPromise) {
        Http2Stream http2Stream = this.connection().stream(n);
        if (http2Stream == null) {
            return this.resetUnknownStream(channelHandlerContext, n, l, channelPromise.unvoid());
        }
        return this.resetStream(channelHandlerContext, http2Stream, l, channelPromise);
    }

    private ChannelFuture resetStream(final ChannelHandlerContext channelHandlerContext, final Http2Stream http2Stream, long l, ChannelPromise channelPromise) {
        channelPromise = channelPromise.unvoid();
        if (http2Stream.isResetSent()) {
            return channelPromise.setSuccess();
        }
        http2Stream.resetSent();
        Object object = http2Stream.state() == Http2Stream.State.IDLE || this.connection().local().created(http2Stream) && !http2Stream.isHeadersSent() && !http2Stream.isPushPromiseSent() ? channelPromise.setSuccess() : this.frameWriter().writeRstStream(channelHandlerContext, http2Stream.id(), l, channelPromise);
        if (object.isDone()) {
            this.processRstStreamWriteResult(channelHandlerContext, http2Stream, (ChannelFuture)object);
        } else {
            object.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    Http2ConnectionHandler.this.processRstStreamWriteResult(channelHandlerContext, http2Stream, channelFuture);
                }
            });
        }
        return object;
    }

    @Override
    public ChannelFuture goAway(final ChannelHandlerContext channelHandlerContext, final int n, final long l, final ByteBuf byteBuf, ChannelPromise channelPromise) {
        channelPromise = channelPromise.unvoid();
        Http2Connection http2Connection = this.connection();
        try {
            if (!http2Connection.goAwaySent(n, l, byteBuf)) {
                byteBuf.release();
                channelPromise.trySuccess();
                return channelPromise;
            }
        }
        catch (Throwable throwable) {
            byteBuf.release();
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
        byteBuf.retain();
        http2Connection = this.frameWriter().writeGoAway(channelHandlerContext, n, l, byteBuf, channelPromise);
        if (http2Connection.isDone()) {
            Http2ConnectionHandler.processGoAwayWriteResult(channelHandlerContext, n, l, byteBuf, (ChannelFuture)http2Connection);
        } else {
            http2Connection.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    Http2ConnectionHandler.processGoAwayWriteResult(channelHandlerContext, n, l, byteBuf, channelFuture);
                }
            });
        }
        return http2Connection;
    }

    private void checkCloseConnection(ChannelFuture channelFuture) {
        if (this.closeListener != null && this.isGracefulShutdownComplete()) {
            ChannelFutureListener channelFutureListener = this.closeListener;
            this.closeListener = null;
            try {
                channelFutureListener.operationComplete((Future)channelFuture);
                return;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Close listener threw an unexpected exception", exception);
            }
        }
    }

    private ChannelFuture goAway(ChannelHandlerContext channelHandlerContext, Http2Exception http2Exception, ChannelPromise channelPromise) {
        long l = http2Exception != null ? http2Exception.error().code() : Http2Error.NO_ERROR.code();
        int n = http2Exception != null && http2Exception.shutdownHint() == Http2Exception.ShutdownHint.HARD_SHUTDOWN ? Integer.MAX_VALUE : this.connection().remote().lastStreamCreated();
        return this.goAway(channelHandlerContext, n, l, Http2CodecUtil.toByteBuf(channelHandlerContext, http2Exception), channelPromise);
    }

    private void processRstStreamWriteResult(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, ChannelFuture channelFuture) {
        if (channelFuture.isSuccess()) {
            this.closeStream(http2Stream, channelFuture);
            return;
        }
        this.onConnectionError(channelHandlerContext, true, channelFuture.cause(), null);
    }

    private void closeConnectionOnError(ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.onConnectionError(channelHandlerContext, true, channelFuture.cause(), null);
        }
    }

    private void doCloseStream(Http2Stream http2Stream, ChannelFuture channelFuture) {
        http2Stream.close();
        this.checkCloseConnection(channelFuture);
    }

    private static ByteBuf clientPrefaceString(Http2Connection http2Connection) {
        if (http2Connection.isServer()) {
            return Http2CodecUtil.connectionPrefaceBuf();
        }
        return null;
    }

    private static void processGoAwayWriteResult(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf, ChannelFuture channelFuture) {
        try {
            if (channelFuture.isSuccess()) {
                if (l != Http2Error.NO_ERROR.code()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} Sent GOAWAY: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", new Object[]{channelHandlerContext.channel(), n, l, byteBuf.toString(CharsetUtil.UTF_8), channelFuture.cause()});
                    }
                    channelHandlerContext.close();
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Sending GOAWAY failed: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", new Object[]{channelHandlerContext.channel(), n, l, byteBuf.toString(CharsetUtil.UTF_8), channelFuture.cause()});
                }
                channelHandlerContext.close();
            }
            return;
        }
        finally {
            byteBuf.release();
        }
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;
        private final Future<?> timeoutTask;
        private boolean closed;

        ClosingChannelFutureListener(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.ctx = channelHandlerContext;
            this.promise = channelPromise;
            this.timeoutTask = null;
        }

        ClosingChannelFutureListener(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, long l, TimeUnit timeUnit) {
            this.ctx = channelHandlerContext;
            this.promise = channelPromise;
            this.timeoutTask = channelHandlerContext.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    ClosingChannelFutureListener.this.doClose();
                }
            }, l, timeUnit);
        }

        public final void operationComplete(ChannelFuture channelFuture) {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            this.doClose();
        }

        private void doClose() {
            if (this.closed) {
                assert (this.timeoutTask != null);
                return;
            }
            this.closed = true;
            if (this.promise == null) {
                this.ctx.close();
                return;
            }
            this.ctx.close(this.promise);
        }
    }

    private final class FrameDecoder
    extends BaseDecoder {
        private FrameDecoder() {
        }

        @Override
        public final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            try {
                Http2ConnectionHandler.this.decoder.decodeFrame(channelHandlerContext, byteBuf, list);
                return;
            }
            catch (Throwable throwable) {
                Http2ConnectionHandler.this.onError(channelHandlerContext, false, throwable);
                return;
            }
        }
    }

    private final class PrefaceDecoder
    extends BaseDecoder {
        private ByteBuf clientPrefaceString;
        private boolean prefaceSent;

        PrefaceDecoder(ChannelHandlerContext channelHandlerContext) {
            this.clientPrefaceString = Http2ConnectionHandler.clientPrefaceString(Http2ConnectionHandler.this.encoder.connection());
            this.sendPreface(channelHandlerContext);
        }

        @Override
        public final boolean prefaceSent() {
            return this.prefaceSent;
        }

        @Override
        public final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            try {
                if (channelHandlerContext.channel().isActive() && this.readClientPrefaceString(byteBuf) && this.verifyFirstFrameIsSettings(byteBuf)) {
                    Http2ConnectionHandler.this.byteDecoder = new FrameDecoder();
                    Http2ConnectionHandler.this.byteDecoder.decode(channelHandlerContext, byteBuf, list);
                }
                return;
            }
            catch (Throwable throwable) {
                Http2ConnectionHandler.this.onError(channelHandlerContext, false, throwable);
                return;
            }
        }

        @Override
        public final void channelActive(ChannelHandlerContext channelHandlerContext) {
            this.sendPreface(channelHandlerContext);
            if (Http2ConnectionHandler.this.flushPreface) {
                channelHandlerContext.flush();
            }
        }

        @Override
        public final void channelInactive(ChannelHandlerContext channelHandlerContext) {
            this.cleanup();
            super.channelInactive(channelHandlerContext);
        }

        @Override
        public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
            this.cleanup();
        }

        private void cleanup() {
            if (this.clientPrefaceString != null) {
                this.clientPrefaceString.release();
                this.clientPrefaceString = null;
            }
        }

        private boolean readClientPrefaceString(ByteBuf object) {
            int n;
            block7: {
                block6: {
                    if (this.clientPrefaceString == null) {
                        return true;
                    }
                    n = this.clientPrefaceString.readableBytes();
                    n = Math.min(object.readableBytes(), n);
                    if (n == 0) break block6;
                    ByteBuf byteBuf = object;
                    if (ByteBufUtil.equals((ByteBuf)byteBuf, (int)byteBuf.readerIndex(), (ByteBuf)this.clientPrefaceString, (int)this.clientPrefaceString.readerIndex(), (int)n)) break block7;
                }
                ByteBuf byteBuf = object;
                n = ByteBufUtil.indexOf((ByteBuf)HTTP_1_X_BUF, (ByteBuf)byteBuf.slice(byteBuf.readerIndex(), Math.min(object.readableBytes(), 1024)));
                if (n != -1) {
                    ByteBuf byteBuf2 = object;
                    object = byteBuf2.toString(byteBuf2.readerIndex(), n - object.readerIndex(), CharsetUtil.US_ASCII);
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Unexpected HTTP/1.x request: %s", object);
                }
                ByteBuf byteBuf3 = object;
                object = ByteBufUtil.hexDump((ByteBuf)byteBuf3, (int)byteBuf3.readerIndex(), (int)Math.min(object.readableBytes(), this.clientPrefaceString.readableBytes()));
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP/2 client preface string missing or corrupt. Hex dump for received bytes: %s", object);
            }
            object.skipBytes(n);
            this.clientPrefaceString.skipBytes(n);
            if (!this.clientPrefaceString.isReadable()) {
                this.clientPrefaceString.release();
                this.clientPrefaceString = null;
                return true;
            }
            return false;
        }

        private boolean verifyFirstFrameIsSettings(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() < 5) {
                return false;
            }
            ByteBuf byteBuf2 = byteBuf;
            short s = byteBuf2.getUnsignedByte(byteBuf2.readerIndex() + 3);
            ByteBuf byteBuf3 = byteBuf;
            short s2 = byteBuf3.getUnsignedByte(byteBuf3.readerIndex() + 4);
            if (s != 4 || (s2 & 1) != 0) {
                Object[] objectArray = new Object[1];
                ByteBuf byteBuf4 = byteBuf;
                objectArray[0] = ByteBufUtil.hexDump((ByteBuf)byteBuf4, (int)byteBuf4.readerIndex(), (int)5);
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "First received frame was not SETTINGS. Hex dump for first 5 bytes: %s", objectArray);
            }
            return true;
        }

        private void sendPreface(ChannelHandlerContext channelHandlerContext) {
            if (this.prefaceSent || !channelHandlerContext.channel().isActive()) {
                return;
            }
            this.prefaceSent = true;
            boolean bl = !Http2ConnectionHandler.this.connection().isServer();
            if (bl) {
                channelHandlerContext.write((Object)Http2CodecUtil.connectionPrefaceBuf()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            }
            Http2ConnectionHandler.this.encoder.writeSettings(channelHandlerContext, Http2ConnectionHandler.this.initialSettings, channelHandlerContext.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            if (bl) {
                Http2ConnectionHandler.this.userEventTriggered(channelHandlerContext, Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE);
            }
        }
    }

    private abstract class BaseDecoder {
        private BaseDecoder() {
        }

        public abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3);

        public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        }

        public void channelActive(ChannelHandlerContext channelHandlerContext) {
        }

        public void channelInactive(ChannelHandlerContext channelHandlerContext) {
            Http2ConnectionHandler.this.encoder().close();
            Http2ConnectionHandler.this.decoder().close();
            Http2ConnectionHandler.this.connection().close((Promise<Void>)channelHandlerContext.voidPromise());
        }

        public boolean prefaceSent() {
            return true;
        }
    }
}

