/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ReadOnlyHttp2Headers
implements Http2Headers {
    private static final byte PSEUDO_HEADER_TOKEN = 58;
    private final AsciiString[] pseudoHeaders;
    private final AsciiString[] otherHeaders;

    public static ReadOnlyHttp2Headers trailers(boolean bl, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl, EmptyArrays.EMPTY_ASCII_STRINGS, asciiStringArray);
    }

    public static ReadOnlyHttp2Headers clientHeaders(boolean bl, AsciiString asciiString, AsciiString asciiString2, AsciiString asciiString3, AsciiString asciiString4, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl, new AsciiString[]{Http2Headers.PseudoHeaderName.METHOD.value(), asciiString, Http2Headers.PseudoHeaderName.PATH.value(), asciiString2, Http2Headers.PseudoHeaderName.SCHEME.value(), asciiString3, Http2Headers.PseudoHeaderName.AUTHORITY.value(), asciiString4}, asciiStringArray);
    }

    public static ReadOnlyHttp2Headers serverHeaders(boolean bl, AsciiString asciiString, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl, new AsciiString[]{Http2Headers.PseudoHeaderName.STATUS.value(), asciiString}, asciiStringArray);
    }

    private ReadOnlyHttp2Headers(boolean bl, AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        assert ((asciiStringArray.length & 1) == 0);
        if ((asciiStringArray2.length & 1) != 0) {
            throw ReadOnlyHttp2Headers.newInvalidArraySizeException();
        }
        if (bl) {
            ReadOnlyHttp2Headers.validateHeaders(asciiStringArray, asciiStringArray2);
        }
        this.pseudoHeaders = asciiStringArray;
        this.otherHeaders = asciiStringArray2;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("pseudoHeaders and otherHeaders must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        int n;
        for (n = 1; n < asciiStringArray.length; n += 2) {
            ObjectUtil.checkNotNullArrayParam((Object)asciiStringArray[n], (int)n, (String)"pseudoHeaders");
        }
        n = 0;
        int n2 = asciiStringArray2.length - 1;
        for (int i = 0; i < n2; i += 2) {
            AsciiString asciiString = asciiStringArray2[i];
            DefaultHttp2Headers.HTTP2_NAME_VALIDATOR.validateName((Object)asciiString);
            if (n == 0 && !asciiString.isEmpty() && asciiString.byteAt(0) != 58) {
                n = 1;
            } else if (n != 0 && !asciiString.isEmpty() && asciiString.byteAt(0) == 58) {
                throw new IllegalArgumentException("otherHeaders name at index " + i + " is a pseudo header that appears after non-pseudo headers.");
            }
            ObjectUtil.checkNotNullArrayParam((Object)asciiStringArray2[i + 1], (int)(i + 1), (String)"otherHeaders");
        }
    }

    private AsciiString get0(CharSequence charSequence) {
        int n;
        int n2 = AsciiString.hashCode((CharSequence)charSequence);
        int n3 = this.pseudoHeaders.length - 1;
        for (n = 0; n < n3; n += 2) {
            AsciiString asciiString = this.pseudoHeaders[n];
            if (asciiString.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.pseudoHeaders[n + 1];
        }
        n = this.otherHeaders.length - 1;
        for (int i = 0; i < n; i += 2) {
            AsciiString asciiString = this.otherHeaders[i];
            if (asciiString.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.otherHeaders[i + 1];
        }
        return null;
    }

    public final CharSequence get(CharSequence charSequence) {
        return this.get0(charSequence);
    }

    public final CharSequence get(CharSequence charSequence, CharSequence charSequence2) {
        if ((charSequence = this.get(charSequence)) != null) {
            return charSequence;
        }
        return charSequence2;
    }

    public final CharSequence getAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final CharSequence getAndRemove(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    public final List<CharSequence> getAll(CharSequence charSequence) {
        int n;
        int n2 = AsciiString.hashCode((CharSequence)charSequence);
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n3 = this.pseudoHeaders.length - 1;
        for (n = 0; n < n3; n += 2) {
            AsciiString asciiString = this.pseudoHeaders[n];
            if (asciiString.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add((CharSequence)this.pseudoHeaders[n + 1]);
        }
        n = this.otherHeaders.length - 1;
        for (int i = 0; i < n; i += 2) {
            AsciiString asciiString = this.otherHeaders[i];
            if (asciiString.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add((CharSequence)this.otherHeaders[i + 1]);
        }
        return arrayList;
    }

    public final List<CharSequence> getAllAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final Boolean getBoolean(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) != null) {
            return CharSequenceValueConverter.INSTANCE.convertToBoolean(charSequence);
        }
        return null;
    }

    public final boolean getBoolean(CharSequence object, boolean bl) {
        if ((object = this.getBoolean((CharSequence)object)) != null) {
            return (Boolean)object;
        }
        return bl;
    }

    public final Byte getByte(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) != null) {
            return CharSequenceValueConverter.INSTANCE.convertToByte(charSequence);
        }
        return null;
    }

    public final byte getByte(CharSequence object, byte by) {
        if ((object = this.getByte((CharSequence)object)) != null) {
            return (Byte)object;
        }
        return by;
    }

    public final Character getChar(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) != null) {
            return Character.valueOf(CharSequenceValueConverter.INSTANCE.convertToChar(charSequence));
        }
        return null;
    }

    public final char getChar(CharSequence object, char c) {
        if ((object = this.getChar((CharSequence)object)) != null) {
            return ((Character)object).charValue();
        }
        return c;
    }

    public final Short getShort(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) != null) {
            return CharSequenceValueConverter.INSTANCE.convertToShort(charSequence);
        }
        return null;
    }

    public final short getShort(CharSequence object, short s) {
        if ((object = this.getShort((CharSequence)object)) != null) {
            return (Short)object;
        }
        return s;
    }

    public final Integer getInt(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) != null) {
            return CharSequenceValueConverter.INSTANCE.convertToInt(charSequence);
        }
        return null;
    }

    public final int getInt(CharSequence object, int n) {
        if ((object = this.getInt((CharSequence)object)) != null) {
            return (Integer)object;
        }
        return n;
    }

    public final Long getLong(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) != null) {
            return CharSequenceValueConverter.INSTANCE.convertToLong(charSequence);
        }
        return null;
    }

    public final long getLong(CharSequence object, long l) {
        if ((object = this.getLong((CharSequence)object)) != null) {
            return (Long)object;
        }
        return l;
    }

    public final Float getFloat(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) != null) {
            return Float.valueOf(CharSequenceValueConverter.INSTANCE.convertToFloat(charSequence));
        }
        return null;
    }

    public final float getFloat(CharSequence object, float f) {
        if ((object = this.getFloat((CharSequence)object)) != null) {
            return ((Float)object).floatValue();
        }
        return f;
    }

    public final Double getDouble(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) != null) {
            return CharSequenceValueConverter.INSTANCE.convertToDouble(charSequence);
        }
        return null;
    }

    public final double getDouble(CharSequence object, double d) {
        if ((object = this.getDouble((CharSequence)object)) != null) {
            return (Double)object;
        }
        return d;
    }

    public final Long getTimeMillis(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) != null) {
            return CharSequenceValueConverter.INSTANCE.convertToTimeMillis(charSequence);
        }
        return null;
    }

    public final long getTimeMillis(CharSequence object, long l) {
        if ((object = this.getTimeMillis((CharSequence)object)) != null) {
            return (Long)object;
        }
        return l;
    }

    public final Boolean getBooleanAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final boolean getBooleanAndRemove(CharSequence charSequence, boolean bl) {
        throw new UnsupportedOperationException("read only");
    }

    public final Byte getByteAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final byte getByteAndRemove(CharSequence charSequence, byte by) {
        throw new UnsupportedOperationException("read only");
    }

    public final Character getCharAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final char getCharAndRemove(CharSequence charSequence, char c) {
        throw new UnsupportedOperationException("read only");
    }

    public final Short getShortAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final short getShortAndRemove(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    public final Integer getIntAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final int getIntAndRemove(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    public final Long getLongAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final long getLongAndRemove(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public final Float getFloatAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final float getFloatAndRemove(CharSequence charSequence, float f) {
        throw new UnsupportedOperationException("read only");
    }

    public final Double getDoubleAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final double getDoubleAndRemove(CharSequence charSequence, double d) {
        throw new UnsupportedOperationException("read only");
    }

    public final Long getTimeMillisAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final long getTimeMillisAndRemove(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public final boolean contains(CharSequence charSequence) {
        return this.get(charSequence) != null;
    }

    public final boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        return this.contains(charSequence, charSequence2, false);
    }

    public final boolean containsObject(CharSequence charSequence, Object object) {
        if (object instanceof CharSequence) {
            return this.contains(charSequence, (CharSequence)object);
        }
        return this.contains(charSequence, object.toString());
    }

    public final boolean containsBoolean(CharSequence charSequence, boolean bl) {
        return this.contains(charSequence, String.valueOf(bl));
    }

    public final boolean containsByte(CharSequence charSequence, byte by) {
        return this.contains(charSequence, String.valueOf(by));
    }

    public final boolean containsChar(CharSequence charSequence, char c) {
        return this.contains(charSequence, String.valueOf(c));
    }

    public final boolean containsShort(CharSequence charSequence, short s) {
        return this.contains(charSequence, String.valueOf(s));
    }

    public final boolean containsInt(CharSequence charSequence, int n) {
        return this.contains(charSequence, String.valueOf(n));
    }

    public final boolean containsLong(CharSequence charSequence, long l) {
        return this.contains(charSequence, String.valueOf(l));
    }

    public final boolean containsFloat(CharSequence charSequence, float f) {
        return false;
    }

    public final boolean containsDouble(CharSequence charSequence, double d) {
        return this.contains(charSequence, String.valueOf(d));
    }

    public final boolean containsTimeMillis(CharSequence charSequence, long l) {
        return this.contains(charSequence, String.valueOf(l));
    }

    public final int size() {
        return this.pseudoHeaders.length + this.otherHeaders.length >>> 1;
    }

    public final boolean isEmpty() {
        return this.pseudoHeaders.length == 0 && this.otherHeaders.length == 0;
    }

    public final Set<CharSequence> names() {
        int n;
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<CharSequence> linkedHashSet = new LinkedHashSet<CharSequence>(this.size());
        int n2 = this.pseudoHeaders.length - 1;
        for (n = 0; n < n2; n += 2) {
            linkedHashSet.add((CharSequence)this.pseudoHeaders[n]);
        }
        n = this.otherHeaders.length - 1;
        for (n2 = 0; n2 < n; n2 += 2) {
            linkedHashSet.add((CharSequence)this.otherHeaders[n2]);
        }
        return linkedHashSet;
    }

    public final Http2Headers add(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers add(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers add(CharSequence charSequence, CharSequence ... charSequenceArray) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addObject(CharSequence charSequence, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addObject(CharSequence charSequence, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addObject(CharSequence charSequence, Object ... objectArray) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addBoolean(CharSequence charSequence, boolean bl) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addByte(CharSequence charSequence, byte by) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addChar(CharSequence charSequence, char c) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addShort(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addInt(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addLong(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addFloat(CharSequence charSequence, float f) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addDouble(CharSequence charSequence, double d) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addTimeMillis(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers set(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers set(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers set(CharSequence charSequence, CharSequence ... charSequenceArray) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setObject(CharSequence charSequence, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setObject(CharSequence charSequence, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setObject(CharSequence charSequence, Object ... objectArray) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setBoolean(CharSequence charSequence, boolean bl) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setByte(CharSequence charSequence, byte by) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setChar(CharSequence charSequence, char c) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setShort(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setInt(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setLong(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setFloat(CharSequence charSequence, float f) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setDouble(CharSequence charSequence, double d) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setTimeMillis(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    public final boolean remove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers clear() {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new ReadOnlyIterator();
    }

    @Override
    public final Iterator<CharSequence> valueIterator(CharSequence charSequence) {
        return new ReadOnlyValueIterator(charSequence);
    }

    @Override
    public final Http2Headers method(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers scheme(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers authority(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers path(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers status(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final CharSequence method() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value());
    }

    @Override
    public final CharSequence scheme() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.SCHEME.value());
    }

    @Override
    public final CharSequence authority() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public final CharSequence path() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.PATH.value());
    }

    @Override
    public final CharSequence status() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.STATUS.value());
    }

    @Override
    public final boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        HashingStrategy hashingStrategy;
        int n;
        int n2 = AsciiString.hashCode((CharSequence)charSequence);
        return ReadOnlyHttp2Headers.contains(charSequence, n2, charSequence2, n = (hashingStrategy = bl ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER).hashCode((Object)charSequence2), (HashingStrategy<CharSequence>)hashingStrategy, this.otherHeaders) || ReadOnlyHttp2Headers.contains(charSequence, n2, charSequence2, n, (HashingStrategy<CharSequence>)hashingStrategy, this.pseudoHeaders);
    }

    private static boolean contains(CharSequence charSequence, int n, CharSequence charSequence2, int n2, HashingStrategy<CharSequence> hashingStrategy, AsciiString[] asciiStringArray) {
        int n3 = asciiStringArray.length - 1;
        for (int i = 0; i < n3; i += 2) {
            AsciiString asciiString = asciiStringArray[i];
            AsciiString asciiString2 = asciiStringArray[i + 1];
            if (asciiString.hashCode() != n || asciiString2.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence) || !hashingStrategy.equals((Object)asciiString2, (Object)charSequence2)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String string = "";
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            stringBuilder.append(string);
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue());
            string = ", ";
        }
        return stringBuilder.append(']').toString();
    }

    private final class ReadOnlyIterator
    implements Iterator<Map.Entry<CharSequence, CharSequence>>,
    Map.Entry<CharSequence, CharSequence> {
        private int i;
        private AsciiString[] current;
        private AsciiString key;
        private AsciiString value;

        private ReadOnlyIterator() {
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
        }

        @Override
        public final boolean hasNext() {
            return this.i != this.current.length;
        }

        @Override
        public final Map.Entry<CharSequence, CharSequence> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = this.current[this.i];
            this.value = this.current[this.i + 1];
            this.i += 2;
            if (this.i == this.current.length && this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.i = 0;
            }
            return this;
        }

        @Override
        public final CharSequence getKey() {
            return this.key;
        }

        @Override
        public final CharSequence getValue() {
            return this.value;
        }

        @Override
        public final CharSequence setValue(CharSequence charSequence) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }

    private final class ReadOnlyValueIterator
    implements Iterator<CharSequence> {
        private int i;
        private final int nameHash;
        private final CharSequence name;
        private AsciiString[] current;
        private AsciiString next;

        ReadOnlyValueIterator(CharSequence charSequence) {
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
            this.nameHash = AsciiString.hashCode((CharSequence)charSequence);
            this.name = charSequence;
            this.calculateNext();
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final CharSequence next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AsciiString asciiString = this.next;
            this.calculateNext();
            return asciiString;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        private void calculateNext() {
            while (this.i < this.current.length) {
                AsciiString asciiString = this.current[this.i];
                if (asciiString.hashCode() == this.nameHash && asciiString.contentEqualsIgnoreCase(this.name)) {
                    if (this.i + 1 < this.current.length) {
                        this.next = this.current[this.i + 1];
                        this.i += 2;
                    }
                    return;
                }
                this.i += 2;
            }
            if (this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.i = 0;
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.calculateNext();
                return;
            }
            this.next = null;
        }
    }
}

