/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;

public final class ProtoTypeTableUtilKt {
    public static final List<ProtoBuf.Type> supertypes(ProtoBuf.Class iterator2, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = ((ProtoBuf.Class)((Object)iterator2)).getSupertypeList();
        Object object = (Collection)iterable;
        Iterable<ProtoBuf.Type> iterable2 = !object.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = ((ProtoBuf.Class)((Object)iterator2)).getSupertypeIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            iterator2 = iterable;
            iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                object = (Integer)object;
                Iterable<ProtoBuf.Type> iterable3 = iterable;
                Intrinsics.checkNotNull((Object)object);
                iterable3.add((ProtoBuf.Type)typeTable.get((Integer)object));
            }
            iterable2 = iterable;
        }
        return iterable2;
    }

    public static final ProtoBuf.Type inlineClassUnderlyingType(ProtoBuf.Class clazz, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (clazz.hasInlineClassUnderlyingType()) {
            return clazz.getInlineClassUnderlyingType();
        }
        if (clazz.hasInlineClassUnderlyingTypeId()) {
            return typeTable.get(clazz.getInlineClassUnderlyingTypeId());
        }
        return null;
    }

    public static final ProtoBuf.Type type(ProtoBuf.Type.Argument argument, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (argument.hasType()) {
            return argument.getType();
        }
        if (argument.hasTypeId()) {
            return typeTable.get(argument.getTypeId());
        }
        return null;
    }

    public static final ProtoBuf.Type flexibleUpperBound(ProtoBuf.Type type, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (type.hasFlexibleUpperBound()) {
            return type.getFlexibleUpperBound();
        }
        if (type.hasFlexibleUpperBoundId()) {
            return typeTable.get(type.getFlexibleUpperBoundId());
        }
        return null;
    }

    public static final List<ProtoBuf.Type> upperBounds(ProtoBuf.TypeParameter iterator2, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = ((ProtoBuf.TypeParameter)((Object)iterator2)).getUpperBoundList();
        Object object = (Collection)iterable;
        Iterable<ProtoBuf.Type> iterable2 = !object.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = ((ProtoBuf.TypeParameter)((Object)iterator2)).getUpperBoundIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            iterator2 = iterable;
            iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                object = (Integer)object;
                Iterable<ProtoBuf.Type> iterable3 = iterable;
                Intrinsics.checkNotNull((Object)object);
                iterable3.add((ProtoBuf.Type)typeTable.get((Integer)object));
            }
            iterable2 = iterable;
        }
        return iterable2;
    }

    public static final ProtoBuf.Type returnType(ProtoBuf.Function function, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (function.hasReturnType()) {
            ProtoBuf.Type type = function.getReturnType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"");
            return type;
        }
        if (function.hasReturnTypeId()) {
            return typeTable.get(function.getReturnTypeId());
        }
        throw new IllegalStateException("No returnType in ProtoBuf.Function".toString());
    }

    public static final boolean hasReceiver(ProtoBuf.Function function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"");
        return function.hasReceiverType() || function.hasReceiverTypeId();
    }

    public static final ProtoBuf.Type receiverType(ProtoBuf.Function function, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (function.hasReceiverType()) {
            return function.getReceiverType();
        }
        if (function.hasReceiverTypeId()) {
            return typeTable.get(function.getReceiverTypeId());
        }
        return null;
    }

    public static final ProtoBuf.Type returnType(ProtoBuf.Property property, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (property.hasReturnType()) {
            ProtoBuf.Type type = property.getReturnType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"");
            return type;
        }
        if (property.hasReturnTypeId()) {
            return typeTable.get(property.getReturnTypeId());
        }
        throw new IllegalStateException("No returnType in ProtoBuf.Property".toString());
    }

    public static final boolean hasReceiver(ProtoBuf.Property property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        return property.hasReceiverType() || property.hasReceiverTypeId();
    }

    public static final ProtoBuf.Type receiverType(ProtoBuf.Property property, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (property.hasReceiverType()) {
            return property.getReceiverType();
        }
        if (property.hasReceiverTypeId()) {
            return typeTable.get(property.getReceiverTypeId());
        }
        return null;
    }

    public static final ProtoBuf.Type type(ProtoBuf.ValueParameter valueParameter, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)valueParameter, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (valueParameter.hasType()) {
            ProtoBuf.Type type = valueParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"");
            return type;
        }
        if (valueParameter.hasTypeId()) {
            return typeTable.get(valueParameter.getTypeId());
        }
        throw new IllegalStateException("No type in ProtoBuf.ValueParameter".toString());
    }

    public static final ProtoBuf.Type varargElementType(ProtoBuf.ValueParameter valueParameter, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)valueParameter, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (valueParameter.hasVarargElementType()) {
            return valueParameter.getVarargElementType();
        }
        if (valueParameter.hasVarargElementTypeId()) {
            return typeTable.get(valueParameter.getVarargElementTypeId());
        }
        return null;
    }

    public static final ProtoBuf.Type outerType(ProtoBuf.Type type, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (type.hasOuterType()) {
            return type.getOuterType();
        }
        if (type.hasOuterTypeId()) {
            return typeTable.get(type.getOuterTypeId());
        }
        return null;
    }

    public static final ProtoBuf.Type abbreviatedType(ProtoBuf.Type type, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (type.hasAbbreviatedType()) {
            return type.getAbbreviatedType();
        }
        if (type.hasAbbreviatedTypeId()) {
            return typeTable.get(type.getAbbreviatedTypeId());
        }
        return null;
    }

    public static final ProtoBuf.Type underlyingType(ProtoBuf.TypeAlias typeAlias, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (typeAlias.hasUnderlyingType()) {
            ProtoBuf.Type type = typeAlias.getUnderlyingType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"");
            return type;
        }
        if (typeAlias.hasUnderlyingTypeId()) {
            return typeTable.get(typeAlias.getUnderlyingTypeId());
        }
        throw new IllegalStateException("No underlyingType in ProtoBuf.TypeAlias".toString());
    }

    public static final ProtoBuf.Type expandedType(ProtoBuf.TypeAlias typeAlias, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (typeAlias.hasExpandedType()) {
            ProtoBuf.Type type = typeAlias.getExpandedType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"");
            return type;
        }
        if (typeAlias.hasExpandedTypeId()) {
            return typeTable.get(typeAlias.getExpandedTypeId());
        }
        throw new IllegalStateException("No expandedType in ProtoBuf.TypeAlias".toString());
    }

    public static final List<ProtoBuf.Type> contextReceiverTypes(ProtoBuf.Class iterator2, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = ((ProtoBuf.Class)((Object)iterator2)).getContextReceiverTypeList();
        Object object = (Collection)iterable;
        Iterable<ProtoBuf.Type> iterable2 = !object.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = ((ProtoBuf.Class)((Object)iterator2)).getContextReceiverTypeIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            iterator2 = iterable;
            iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                object = (Integer)object;
                Iterable<ProtoBuf.Type> iterable3 = iterable;
                Intrinsics.checkNotNull((Object)object);
                iterable3.add((ProtoBuf.Type)typeTable.get((Integer)object));
            }
            iterable2 = iterable;
        }
        return iterable2;
    }

    public static final List<ProtoBuf.Type> contextReceiverTypes(ProtoBuf.Function iterator2, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = ((ProtoBuf.Function)((Object)iterator2)).getContextReceiverTypeList();
        Object object = (Collection)iterable;
        Iterable<ProtoBuf.Type> iterable2 = !object.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = ((ProtoBuf.Function)((Object)iterator2)).getContextReceiverTypeIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            iterator2 = iterable;
            iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                object = (Integer)object;
                Iterable<ProtoBuf.Type> iterable3 = iterable;
                Intrinsics.checkNotNull((Object)object);
                iterable3.add((ProtoBuf.Type)typeTable.get((Integer)object));
            }
            iterable2 = iterable;
        }
        return iterable2;
    }

    public static final List<ProtoBuf.Type> contextReceiverTypes(ProtoBuf.Property iterator2, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = ((ProtoBuf.Property)((Object)iterator2)).getContextReceiverTypeList();
        Object object = (Collection)iterable;
        Iterable<ProtoBuf.Type> iterable2 = !object.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = ((ProtoBuf.Property)((Object)iterator2)).getContextReceiverTypeIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            iterator2 = iterable;
            iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                object = (Integer)object;
                Iterable<ProtoBuf.Type> iterable3 = iterable;
                Intrinsics.checkNotNull((Object)object);
                iterable3.add((ProtoBuf.Type)typeTable.get((Integer)object));
            }
            iterable2 = iterable;
        }
        return iterable2;
    }
}

