/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.SealedClassInheritorsProvider;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ResolutionScope;

public final class CliSealedClassInheritorsProvider
extends SealedClassInheritorsProvider {
    public static final CliSealedClassInheritorsProvider INSTANCE = new CliSealedClassInheritorsProvider();

    private CliSealedClassInheritorsProvider() {
    }

    public final Collection<ClassDescriptor> computeSealedSubclasses(ClassDescriptor classDescriptor, boolean bl) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        if (classDescriptor.getModality() != Modality.SEALED) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet<ClassDescriptor> linkedHashSet = new LinkedHashSet<ClassDescriptor>();
        if (!bl) {
            object2 = classDescriptor.getContainingDeclaration();
        } else {
            Object v1;
            block5: {
                object = DescriptorUtilsKt.getParents(classDescriptor);
                object = object.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)e;
                    if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) continue;
                    v1 = e;
                    break block5;
                }
                v1 = null;
            }
            object2 = object = (DeclarationDescriptor)v1;
        }
        if (object2 instanceof PackageFragmentDescriptor) {
            CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses(classDescriptor, linkedHashSet, ((PackageFragmentDescriptor)object).getMemberScope(), bl);
        }
        MemberScope memberScope = classDescriptor.getUnsubstitutedInnerClassesScope();
        Intrinsics.checkNotNullExpressionValue((Object)memberScope, (String)"");
        CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses(classDescriptor, linkedHashSet, memberScope, true);
        object = linkedHashSet;
        return CollectionsKt.sortedWith((Iterable)object, (Comparator)new Comparator(){

            public final int compare(T object, T object2) {
                ClassDescriptor classDescriptor = (ClassDescriptor)object;
                object = classDescriptor;
                object = (ClassDescriptor)object2;
                object2 = (Comparable)((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor).asString());
                return ComparisonsKt.compareValues(object2, (Comparable)((Comparable)((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object).asString())));
            }
        });
    }

    private static final void computeSealedSubclasses$collectSubclasses(ClassDescriptor classDescriptor, LinkedHashSet<ClassDescriptor> linkedHashSet, MemberScope memberScope, boolean bl) {
        for (DeclarationDescriptor declarationDescriptor : ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope, DescriptorKindFilter.CLASSIFIERS, null, 2, null)) {
            ClassDescriptor classDescriptor2;
            if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
            if (((ClassDescriptor)declarationDescriptor).isExpect()) {
                Name name = ((ClassDescriptor)declarationDescriptor).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                declarationDescriptor = memberScope.getContributedClassifier(name, NoLookupLocation.WHEN_GET_ALL_DESCRIPTORS);
                classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : (declarationDescriptor instanceof TypeAliasDescriptor ? ((TypeAliasDescriptor)declarationDescriptor).getClassDescriptor() : null);
            } else {
                classDescriptor2 = (ClassDescriptor)declarationDescriptor;
            }
            if (classDescriptor2 == null) continue;
            declarationDescriptor = classDescriptor2;
            if (DescriptorUtils.isDirectSubclass(classDescriptor2, classDescriptor)) {
                linkedHashSet.add((ClassDescriptor)declarationDescriptor);
            }
            if (!bl) continue;
            MemberScope memberScope2 = declarationDescriptor.getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"");
            CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses(classDescriptor, linkedHashSet, memberScope2, bl);
        }
    }
}

