/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.util.AbstractArrayMapOwner;
import kotlin.reflect.jvm.internal.impl.util.ArrayMap;
import kotlin.reflect.jvm.internal.impl.util.ArrayMapImpl;
import kotlin.reflect.jvm.internal.impl.util.EmptyArrayMap;
import kotlin.reflect.jvm.internal.impl.util.OneElementArrayMap;

public abstract class AttributeArrayOwner<K, T>
extends AbstractArrayMapOwner<K, T> {
    private ArrayMap<T> arrayMap;

    protected AttributeArrayOwner(ArrayMap<T> arrayMap) {
        Intrinsics.checkNotNullParameter(arrayMap, (String)"");
        this.arrayMap = arrayMap;
    }

    @Override
    protected final ArrayMap<T> getArrayMap() {
        return this.arrayMap;
    }

    public AttributeArrayOwner() {
        EmptyArrayMap emptyArrayMap = EmptyArrayMap.INSTANCE;
        Intrinsics.checkNotNull((Object)emptyArrayMap);
        this(emptyArrayMap);
    }

    @Override
    protected final void registerComponent(String string, T t) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        int n = this.getTypeRegistry().getId(string);
        switch (this.arrayMap.getSize()) {
            case 0: {
                ArrayMap<T> arrayMap = this.arrayMap;
                if (!(arrayMap instanceof EmptyArrayMap)) {
                    throw new IllegalStateException(this.buildDiagnosticMessage(arrayMap, 0, "EmptyArrayMap"));
                }
                this.arrayMap = new OneElementArrayMap<T>(t, n);
                return;
            }
            case 1: {
                OneElementArrayMap oneElementArrayMap;
                OneElementArrayMap oneElementArrayMap2 = this.arrayMap;
                try {
                    Intrinsics.checkNotNull(oneElementArrayMap2);
                    oneElementArrayMap = oneElementArrayMap2;
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException(this.buildDiagnosticMessage(oneElementArrayMap2, 1, "OneElementArrayMap"), classCastException);
                }
                oneElementArrayMap2 = oneElementArrayMap;
                if (oneElementArrayMap2.getIndex() == n) {
                    this.arrayMap = new OneElementArrayMap<T>(t, n);
                    return;
                }
                this.arrayMap = new ArrayMapImpl();
                this.arrayMap.set(oneElementArrayMap2.getIndex(), oneElementArrayMap2.getValue());
            }
        }
        this.arrayMap.set(n, t);
    }

    private final String buildDiagnosticMessage(ArrayMap<T> object, int n, String charSequence) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append("Race condition happened, the size of ArrayMap is " + n + " but it isn't an `" + (String)charSequence + '`').append('\n');
        stringBuilder2.append("Type: " + object.getClass()).append('\n');
        StringBuilder stringBuilder3 = new StringBuilder();
        charSequence = stringBuilder3;
        Map<String, Integer> map = this.getTypeRegistry().allValuesThreadUnsafeForRendering();
        ((StringBuilder)charSequence).append("[\n");
        Object object2 = object = (Iterable)object;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        int n2 = 0;
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object v0;
            Object object3;
            Iterable<T> iterable;
            int n3;
            Object e;
            block3: {
                e = object2.next();
                if ((n3 = n2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                iterable = object;
                object3 = map.entrySet();
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    Object e2 = object3.next();
                    Map.Entry entry = (Map.Entry)e2;
                    if (!(((Number)entry.getValue()).intValue() == n3)) continue;
                    v0 = e2;
                    break block3;
                }
                v0 = null;
            }
            object3 = v0;
            iterable.add((StringBuilder)((StringBuilder)charSequence).append("  " + object3 + '[' + n3 + "]: " + e).append('\n'));
        }
        List cfr_ignored_0 = (List)object;
        ((StringBuilder)charSequence).append("]\n");
        object = stringBuilder3.toString();
        stringBuilder2.append("Content: " + (String)object).append('\n');
        return stringBuilder.toString();
    }
}

