/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.common.av.AudioFormat;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.SourcedInterruptedException;
import com.jogamp.openal.sound3d.Context;
import com.jogamp.openal.sound3d.Device;
import com.jogamp.openal.sound3d.Source;
import com.jogamp.openal.util.ALAudioSink;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public final class SimpleSineSynth {
    private static final boolean DEBUG = false;
    private static final float PI = (float)Math.PI;
    private static final float TWO_PI = (float)Math.PI * 2;
    private static final float EPSILON = 1.1920929E-7f;
    private static final float SHORT_MAX = 32767.0f;
    public static final float MIDDLE_C = 261.625f;
    private final ALAudioSink audioSink;
    private final Object stateLock = new Object();
    private volatile float audioAmplitude = 1.0f;
    private volatile float audioFreq = 261.625f;
    private volatile int lastAudioPTS = 0;
    private SynthWorker streamWorker;
    static int SynthWorkerInstanceId = 0;

    public SimpleSineSynth() {
        this(null);
    }

    public SimpleSineSynth(Device device) {
        this.audioSink = new ALAudioSink(device);
        this.streamWorker = new SynthWorker();
    }

    public final ALAudioSink getSink() {
        return this.audioSink;
    }

    public final Device getDevice() {
        return this.audioSink.getDevice();
    }

    public final Context getContext() {
        return this.audioSink.getContext();
    }

    public final Source getSource() {
        return this.audioSink.getSource();
    }

    public final void setFreq(float f) {
        this.audioFreq = f;
    }

    public final float getFreq() {
        return this.audioFreq;
    }

    public final void setAmplitude(float f) {
        this.audioAmplitude = Math.min(1.0f, Math.max(0.0f, f));
    }

    public final float getAmplitude() {
        return this.audioAmplitude;
    }

    public final int getLatency() {
        if (this.streamWorker != null) {
            return this.streamWorker.frameDuration;
        }
        return 64;
    }

    public final void play() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.streamWorker == null) {
                this.streamWorker = new SynthWorker();
            }
            this.streamWorker.doResume();
            return;
        }
    }

    public final void pause() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.streamWorker != null) {
                this.streamWorker.doPause(true);
            }
            return;
        }
    }

    public final void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.streamWorker != null) {
                this.streamWorker.doStop();
                this.streamWorker = null;
            }
            return;
        }
    }

    public final boolean isPlaying() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.streamWorker != null) {
                return this.streamWorker.isPlaying();
            }
        }
        return false;
    }

    public final boolean isRunning() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.streamWorker != null) {
                return this.streamWorker.isRunning();
            }
        }
        return false;
    }

    public final int getGenPTS() {
        return this.lastAudioPTS;
    }

    public final int getPTS() {
        return this.audioSink.getPTS();
    }

    public final String toString() {
        Object object = this.stateLock;
        synchronized (object) {
            int n = this.getPTS();
            int n2 = this.getGenPTS() - n;
            return this.getClass().getSimpleName() + "[f " + this.audioFreq + ", a " + this.audioAmplitude + ", latency " + this.getLatency() + ", state[running " + this.isRunning() + ", playing " + this.isPlaying() + "], pts[gen " + this.getGenPTS() + ", play " + n + ", lag " + n2 + "], " + this.audioSink.toString() + "]";
        }
    }

    private static ByteBuffer allocate(int n) {
        return Buffers.newDirectByteBuffer((int)n);
    }

    class SynthWorker
    extends InterruptSource.Thread {
        private volatile boolean isRunning = false;
        private volatile boolean isPlaying = false;
        private volatile boolean isBlocked = false;
        private volatile boolean shallPause = true;
        private volatile boolean shallStop = false;
        private final boolean useFloat32SampleType;
        private final int bytesPerSample;
        private final AudioFormat audioFormat;
        private ByteBuffer sampleBuffer;
        private int frameDuration;
        private int audioQueueLimit;
        private float lastFreq;
        private float nextSin;
        private boolean upSin;
        private int nextStep;

        SynthWorker() {
            this.setDaemon(true);
            SynthWorker synthWorker = this;
            synchronized (synthWorker) {
                SimpleSineSynth.this.lastAudioPTS = 0;
                AudioFormat audioFormat = new AudioFormat(((SimpleSineSynth)SimpleSineSynth.this).audioSink.getPreferredFormat().sampleRate, 32, 1, true, false, false, true);
                if (SimpleSineSynth.this.audioSink.isSupported(audioFormat)) {
                    this.useFloat32SampleType = true;
                    this.bytesPerSample = 4;
                    this.audioFormat = audioFormat;
                } else {
                    this.useFloat32SampleType = false;
                    this.bytesPerSample = 2;
                    this.audioFormat = new AudioFormat(((SimpleSineSynth)SimpleSineSynth.this).audioSink.getPreferredFormat().sampleRate, this.bytesPerSample << 3, 1, true, true, false, true);
                }
                System.err.println("OpenAL float32 supported: " + this.useFloat32SampleType);
                this.sampleBuffer = SimpleSineSynth.allocate(this.audioFormat.getDurationsByteSize(0.03f));
                this.frameDuration = 10;
                this.audioQueueLimit = Math.max(16, Math.min(96, 3 * Math.round(1000.0f * SimpleSineSynth.this.audioSink.getDefaultLatency())));
                SimpleSineSynth.this.audioSink.init(this.audioFormat, this.frameDuration, this.audioQueueLimit, 0, this.audioQueueLimit);
                this.frameDuration = Math.round(1000.0f * SimpleSineSynth.this.audioSink.getLatency());
                this.lastFreq = 0.0f;
                this.nextSin = 0.0f;
                this.upSin = true;
                this.nextStep = 0;
                this.start();
                try {
                    ((Object)((Object)this)).notifyAll();
                    while (!this.isRunning && !this.shallStop) {
                        ((Object)((Object)this)).wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                return;
            }
        }

        private final int findNextStep(boolean bl, float f, float f2, int n, int n2) {
            f2 = (float)Math.PI * 2 * f2 / (float)n;
            float f3 = Float.MAX_VALUE;
            int n3 = -1;
            float f4 = 0.0f;
            for (int i = 0; i < n2 && f3 >= 1.1920929E-7f; ++i) {
                float f5;
                float f6 = (float)Math.sin(f2 * (float)i);
                float f7 = Math.abs(f - f6);
                if (f5 < f3 && (bl && f6 >= f4 || !bl && f6 < f4)) {
                    f3 = f7;
                    n3 = i;
                }
                f4 = f6;
            }
            return n3;
        }

        private final void enqueueWave() {
            SynthWorker synthWorker;
            int n;
            float f = SimpleSineSynth.this.audioFreq;
            float f2 = SimpleSineSynth.this.audioAmplitude;
            float cfr_ignored_0 = 1.0f / f;
            float f3 = (float)Math.PI * 2 * f / (float)this.audioFormat.sampleRate;
            float f4 = (float)this.frameDuration / 1000.0f;
            int n2 = (int)(f4 * (float)this.audioFormat.sampleRate);
            if (Math.abs(f - this.lastFreq) >= 1.1920929E-7f) {
                this.lastFreq = f;
                this.nextStep = this.findNextStep(this.upSin, this.nextSin, f, this.audioFormat.sampleRate, n2);
            } else if (this.nextStep + n2 >= 2147483) {
                this.nextStep = this.findNextStep(this.upSin, this.nextSin, f, this.audioFormat.sampleRate, n2);
            }
            if (this.sampleBuffer.capacity() < this.bytesPerSample * n2) {
                this.sampleBuffer = SimpleSineSynth.allocate(this.bytesPerSample * n2);
            }
            float f5 = 0.0f;
            if (this.useFloat32SampleType) {
                int n3;
                FloatBuffer floatBuffer = this.sampleBuffer.asFloatBuffer();
                for (n = n3 = this.nextStep; n < n3 + n2; ++n) {
                    f5 = (float)Math.sin(f3 * (float)n);
                    floatBuffer.put(f5 * f2);
                }
            } else {
                int n4;
                for (n = n4 = this.nextStep; n < n4 + n2; ++n) {
                    f5 = (float)Math.sin(f3 * (float)n);
                    short s = (short)(32767.0f * f5 * f2);
                    this.sampleBuffer.put((byte)s);
                    this.sampleBuffer.put((byte)(s >>> 8));
                }
            }
            this.nextStep = n;
            this.nextSin = (float)Math.sin(f3 * (float)this.nextStep);
            this.upSin = synthWorker.nextSin >= f5;
            this.sampleBuffer.rewind();
            SimpleSineSynth.this.audioSink.enqueueData(SimpleSineSynth.this.lastAudioPTS, this.sampleBuffer, n2 * this.bytesPerSample);
            this.sampleBuffer.clear();
            SimpleSineSynth.this.lastAudioPTS += this.frameDuration;
        }

        public final synchronized void doPause(boolean bl) {
            if (this.isPlaying) {
                this.shallPause = true;
                if (Thread.currentThread() != this) {
                    if (this.isBlocked && this.isPlaying) {
                        this.interrupt();
                    }
                    if (bl) {
                        try {
                            while (this.isPlaying && this.isRunning) {
                                ((Object)((Object)this)).wait();
                            }
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedRuntimeException(interruptedException);
                        }
                    }
                }
            }
        }

        public final synchronized void doResume() {
            if (this.isRunning && !this.isPlaying) {
                this.shallPause = false;
                if (Thread.currentThread() != this) {
                    try {
                        ((Object)((Object)this)).notifyAll();
                        while (!this.isPlaying && !this.shallPause && this.isRunning) {
                            ((Object)((Object)this)).wait();
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedException interruptedException2 = interruptedException;
                        interruptedException2 = SourcedInterruptedException.wrap((InterruptedException)interruptedException);
                        this.doPause(false);
                        throw new InterruptedRuntimeException(interruptedException2);
                    }
                }
            }
        }

        public final synchronized void doStop() {
            if (this.isRunning) {
                this.shallStop = true;
                if (Thread.currentThread() != this) {
                    if (this.isBlocked && this.isRunning) {
                        this.interrupt();
                    }
                    try {
                        ((Object)((Object)this)).notifyAll();
                        while (this.isRunning) {
                            ((Object)((Object)this)).wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedRuntimeException(interruptedException);
                    }
                }
            }
            SimpleSineSynth.this.audioSink.destroy();
        }

        public final boolean isRunning() {
            return this.isRunning;
        }

        public final boolean isPlaying() {
            return this.isPlaying;
        }

        public final void run() {
            this.setName(this.getName() + "-SynthWorker_" + SynthWorkerInstanceId);
            ++SynthWorkerInstanceId;
            SynthWorker synthWorker = this;
            synchronized (synthWorker) {
                this.isRunning = true;
                ((Object)((Object)this)).notifyAll();
            }
            while (!this.shallStop) {
                if (this.shallPause) {
                    synthWorker = this;
                    synchronized (synthWorker) {
                        while (this.shallPause && !this.shallStop) {
                            SimpleSineSynth.this.audioSink.pause();
                            this.isPlaying = false;
                            ((Object)((Object)this)).notifyAll();
                            try {
                                ((Object)((Object)this)).wait();
                            }
                            catch (InterruptedException interruptedException) {
                                if (this.shallPause) continue;
                                interruptedException.printStackTrace();
                            }
                        }
                        SimpleSineSynth.this.audioSink.play();
                        this.isPlaying = true;
                        ((Object)((Object)this)).notifyAll();
                    }
                }
                if (this.shallStop) continue;
                this.isBlocked = true;
                this.enqueueWave();
                this.isBlocked = false;
            }
            synthWorker = this;
            synchronized (synthWorker) {
                this.isRunning = false;
                this.isPlaying = false;
                ((Object)((Object)this)).notifyAll();
                return;
            }
        }
    }
}

