/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.subst.NodeToStringTransformer;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.Loader;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class OptionHelper {
    static final String DELIM_START = "${";
    static final char DELIM_STOP = '}';
    static final String DELIM_DEFAULT = ":-";
    static final int DELIM_START_LEN = 2;
    static final int DELIM_STOP_LEN = 1;
    static final int DELIM_DEFAULT_LEN = 2;
    static final String _IS_UNDEFINED = "_IS_UNDEFINED";

    public static Object instantiateByClassName(String string, Class<?> clazz, Context object) {
        object = Loader.getClassLoaderOfObject(object);
        return OptionHelper.instantiateByClassName(string, clazz, (ClassLoader)object);
    }

    public static Object instantiateByClassNameAndParameter(String string, Class<?> clazz, Context object, Class<?> clazz2, Object object2) {
        object = Loader.getClassLoaderOfObject(object);
        return OptionHelper.instantiateByClassNameAndParameter(string, clazz, (ClassLoader)object, clazz2, object2);
    }

    public static Object instantiateByClassName(String string, Class<?> clazz, ClassLoader classLoader) {
        return OptionHelper.instantiateByClassNameAndParameter(string, clazz, classLoader, null, null);
    }

    public static Object instantiateByClassNameAndParameter(String string, Class<?> genericDeclaration, ClassLoader clazz, Class<?> clazz2, Object object) {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            clazz = ((ClassLoader)((Object)clazz)).loadClass(string);
            if (!genericDeclaration.isAssignableFrom(clazz)) {
                throw new IncompatibleClassException((Class<?>)genericDeclaration, clazz);
            }
            if (clazz2 == null) {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            genericDeclaration = clazz.getConstructor(clazz2);
            return ((Constructor)genericDeclaration).newInstance(object);
        }
        catch (IncompatibleClassException incompatibleClassException) {
            clazz = incompatibleClassException;
            throw incompatibleClassException;
        }
        catch (Throwable throwable) {
            throw new DynamicClassLoadingException("Failed to instantiate type " + string, throwable);
        }
    }

    public static String substVars(String string, PropertyContainer propertyContainer) {
        return OptionHelper.substVars(string, propertyContainer, null);
    }

    public static String substVars(String string, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) {
        return NodeToStringTransformer.substituteVariable(string, propertyContainer, propertyContainer2);
    }

    public static String propertyLookup(String string, PropertyContainer object, PropertyContainer propertyContainer) {
        if ((object = object.getProperty(string)) == null && propertyContainer != null) {
            object = propertyContainer.getProperty(string);
        }
        if (object == null) {
            object = OptionHelper.getSystemProperty(string, null);
        }
        if (object == null) {
            object = OptionHelper.getEnv(string);
        }
        return object;
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static String getEnv(String string) {
        try {
            return System.getenv(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static void setSystemProperties(ContextAware contextAware, Properties properties) {
        for (Object object : properties.keySet()) {
            object = (String)object;
            String string = properties.getProperty((String)object);
            OptionHelper.setSystemProperty(contextAware, (String)object, string);
        }
    }

    public static void setSystemProperty(ContextAware contextAware, String string, String string2) {
        try {
            System.setProperty(string, string2);
            return;
        }
        catch (SecurityException securityException) {
            contextAware.addError("Failed to set system property [" + string + "]", securityException);
            return;
        }
    }

    public static Properties getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (SecurityException securityException) {
            return new Properties();
        }
    }

    public static String[] extractDefaultReplacement(String string) {
        String[] stringArray = new String[2];
        if (string == null) {
            return stringArray;
        }
        stringArray[0] = string;
        int n = string.indexOf(DELIM_DEFAULT);
        if (n != -1) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 2);
        }
        return stringArray;
    }

    public static boolean toBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if ("true".equalsIgnoreCase(string = string.trim())) {
            return true;
        }
        if ("false".equalsIgnoreCase(string)) {
            return false;
        }
        return bl;
    }

    public static boolean isEmpty(String string) {
        return OptionHelper.isNullOrEmptyOrAllSpaces(string);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNullOrEmptyOrAllSpaces(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static final boolean isNullOrEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static final boolean isNotEmtpy(Object[] objectArray) {
        return !OptionHelper.isNullOrEmpty(objectArray);
    }
}

