/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Fill;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextForegroundStyle;
import androidx.compose.ui.text.style.TextOverflow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Landroidx/compose/ui/text/TextPainter;", "", "<init>", "()V", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "ui-text"})
public final class TextPainter {
    public static final TextPainter INSTANCE = new TextPainter();
    public static final int $stable;

    private TextPainter() {
    }

    public final void paint(Canvas canvas, TextLayoutResult textLayoutResult) {
        DrawStyle drawStyle;
        Shadow shadow;
        TextDecoration textDecoration;
        SpanStyle spanStyle;
        TextDecoration textDecoration2;
        Shadow shadow2;
        long l;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"");
        boolean bl = textLayoutResult.getHasVisualOverflow() && !TextOverflow.equals-impl0(textLayoutResult.getLayoutInput().getOverflow-gIe3tQ8(), TextOverflow.Companion.getVisible-gIe3tQ8());
        if (bl) {
            long l2 = textLayoutResult.getSize-YbymL2g();
            float f = (int)(l2 >> 32);
            long l3 = textLayoutResult.getSize-YbymL2g();
            float f2 = (int)l3;
            l = Float.floatToRawIntBits(f);
            long l4 = Float.floatToRawIntBits(f2);
            shadow2 = RectKt.Rect-tz77jQw((long)Offset.Companion.getZero-F1C5BW0(), (long)Size.constructor-impl((long)(l << 32 | l4 & 0xFFFFFFFFL)));
            canvas.save();
            Canvas.clipRect-mtrdD-E$default((Canvas)canvas, (Rect)shadow2, (int)0, (int)2, null);
        }
        if ((textDecoration2 = (spanStyle = textLayoutResult.getLayoutInput().getStyle().getSpanStyle$ui_text()).getTextDecoration()) == null) {
            textDecoration2 = textDecoration = TextDecoration.Companion.getNone();
        }
        if ((shadow = spanStyle.getShadow()) == null) {
            shadow = shadow2 = Shadow.Companion.getNone();
        }
        if ((drawStyle = spanStyle.getDrawStyle()) == null) {
            drawStyle = (DrawStyle)Fill.INSTANCE;
        }
        DrawStyle drawStyle2 = drawStyle;
        try {
            Brush brush = spanStyle.getBrush();
            if (brush != null) {
                float f = spanStyle.getTextForegroundStyle$ui_text() != TextForegroundStyle.Unspecified.INSTANCE ? spanStyle.getTextForegroundStyle$ui_text().getAlpha() : 1.0f;
                MultiParagraph.paint-hn5TExg$default(textLayoutResult.getMultiParagraph(), canvas, brush, f, shadow2, textDecoration, drawStyle2, 0, 64, null);
            } else {
                l = spanStyle.getTextForegroundStyle$ui_text() != TextForegroundStyle.Unspecified.INSTANCE ? spanStyle.getTextForegroundStyle$ui_text().getColor-0d7_KjU() : Color.Companion.getBlack-0d7_KjU();
                MultiParagraph.paint-LG529CI$default(textLayoutResult.getMultiParagraph(), canvas, l, shadow2, textDecoration, drawStyle2, 0, 32, null);
            }
            return;
        }
        finally {
            if (bl) {
                canvas.restore();
            }
        }
    }
}

