/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.util.IntSupplier;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class EpollEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollEventLoop.class);
    private static final long EPOLL_WAIT_MILLIS_THRESHOLD = SystemPropertyUtil.getLong((String)"io.netty.channel.epoll.epollWaitThreshold", (long)10L);
    private FileDescriptor epollFd;
    private FileDescriptor eventFd;
    private FileDescriptor timerFd;
    private final IntObjectMap<AbstractEpollChannel> channels = new IntObjectHashMap(4096);
    private final boolean allowGrowing;
    private final EpollEventArray events;
    private IovArray iovArray;
    private NativeDatagramPacketArray datagramPacketArray;
    private final SelectStrategy selectStrategy;
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        public int get() {
            return EpollEventLoop.this.epollWaitNow();
        }
    };
    private static final long AWAKE = -1L;
    private static final long NONE = Long.MAX_VALUE;
    private final AtomicLong nextWakeupNanos = new AtomicLong(-1L);
    private boolean pendingWakeup;
    private volatile int ioRatio = 50;
    private static final long MAX_SCHEDULED_TIMERFD_NS = 999999999L;

    EpollEventLoop(EventLoopGroup eventLoopGroup, Executor executor, int n, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory, EventLoopTaskQueueFactory eventLoopTaskQueueFactory2) {
        super(eventLoopGroup, executor, false, EpollEventLoop.newTaskQueue(eventLoopTaskQueueFactory), EpollEventLoop.newTaskQueue(eventLoopTaskQueueFactory2), rejectedExecutionHandler);
        this.selectStrategy = (SelectStrategy)ObjectUtil.checkNotNull((Object)selectStrategy, (String)"strategy");
        if (n == 0) {
            this.allowGrowing = true;
            this.events = new EpollEventArray(4096);
        } else {
            this.allowGrowing = false;
            this.events = new EpollEventArray(n);
        }
        this.openFileDescriptors();
    }

    public void openFileDescriptors() {
        FileDescriptor fileDescriptor = null;
        FileDescriptor fileDescriptor2 = null;
        FileDescriptor fileDescriptor3 = null;
        try {
            this.epollFd = fileDescriptor = Native.newEpollCreate();
            this.eventFd = fileDescriptor2 = Native.newEventFd();
            try {
                Native.epollCtlAdd(fileDescriptor.intValue(), fileDescriptor2.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to add eventFd filedescriptor to epoll", iOException);
            }
            this.timerFd = fileDescriptor3 = Native.newTimerFd();
            try {
                Native.epollCtlAdd(fileDescriptor.intValue(), fileDescriptor3.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to add timerFd filedescriptor to epoll", iOException);
            }
        }
        catch (Throwable throwable) {
            EpollEventLoop.closeFileDescriptor(fileDescriptor);
            EpollEventLoop.closeFileDescriptor(fileDescriptor2);
            EpollEventLoop.closeFileDescriptor(fileDescriptor3);
            throw throwable;
        }
    }

    private static void closeFileDescriptor(FileDescriptor fileDescriptor) {
        if (fileDescriptor != null) {
            try {
                fileDescriptor.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        if (eventLoopTaskQueueFactory == null) {
            return EpollEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    IovArray cleanIovArray() {
        if (this.iovArray == null) {
            this.iovArray = new IovArray();
        } else {
            this.iovArray.clear();
        }
        return this.iovArray;
    }

    NativeDatagramPacketArray cleanDatagramPacketArray() {
        if (this.datagramPacketArray == null) {
            this.datagramPacketArray = new NativeDatagramPacketArray();
        } else {
            this.datagramPacketArray.clear();
        }
        return this.datagramPacketArray;
    }

    protected void wakeup(boolean bl) {
        if (!bl && this.nextWakeupNanos.getAndSet(-1L) != -1L) {
            Native.eventFdWrite(this.eventFd.intValue(), 1L);
        }
    }

    protected boolean beforeScheduledTaskSubmitted(long l) {
        return l < this.nextWakeupNanos.get();
    }

    protected boolean afterScheduledTaskSubmitted(long l) {
        return l < this.nextWakeupNanos.get();
    }

    void add(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        int n = abstractEpollChannel.socket.intValue();
        Native.epollCtlAdd(this.epollFd.intValue(), n, abstractEpollChannel.flags);
        abstractEpollChannel = (AbstractEpollChannel)((Object)this.channels.put(n, (Object)abstractEpollChannel));
        assert (abstractEpollChannel == null || !abstractEpollChannel.isOpen());
    }

    void modify(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        Native.epollCtlMod(this.epollFd.intValue(), abstractEpollChannel.socket.intValue(), abstractEpollChannel.flags);
    }

    void remove(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        int n = abstractEpollChannel.socket.intValue();
        AbstractEpollChannel abstractEpollChannel2 = (AbstractEpollChannel)((Object)this.channels.remove(n));
        if (abstractEpollChannel2 != null && abstractEpollChannel2 != abstractEpollChannel) {
            this.channels.put(n, (Object)abstractEpollChannel2);
            assert (!abstractEpollChannel.isOpen());
        } else if (abstractEpollChannel.isOpen()) {
            Native.epollCtlDel(this.epollFd.intValue(), n);
        }
    }

    protected Queue<Runnable> newTaskQueue(int n) {
        return EpollEventLoop.newTaskQueue0(n);
    }

    private static Queue<Runnable> newTaskQueue0(int n) {
        if (n == Integer.MAX_VALUE) {
            return PlatformDependent.newMpscQueue();
        }
        return PlatformDependent.newMpscQueue((int)n);
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int n) {
        if (n <= 0 || n > 100) {
            throw new IllegalArgumentException("ioRatio: " + n + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n;
    }

    public int registeredChannels() {
        return this.channels.size();
    }

    public Iterator<Channel> registeredChannelsIterator() {
        assert (this.inEventLoop());
        IntObjectMap<AbstractEpollChannel> intObjectMap = this.channels;
        if (intObjectMap.isEmpty()) {
            return SingleThreadEventLoop.ChannelsReadOnlyIterator.empty();
        }
        return new SingleThreadEventLoop.ChannelsReadOnlyIterator((Iterable)intObjectMap.values());
    }

    private long epollWait(long l) {
        if (l == Long.MAX_VALUE) {
            return Native.epollWait(this.epollFd, this.events, this.timerFd, Integer.MAX_VALUE, 0, EPOLL_WAIT_MILLIS_THRESHOLD);
        }
        long l2 = EpollEventLoop.deadlineToDelayNanos((long)l);
        int n = (int)Math.min(l2 / 1000000000L, Integer.MAX_VALUE);
        int n2 = (int)Math.min(l2 - (long)n * 1000000000L, 999999999L);
        return Native.epollWait(this.epollFd, this.events, this.timerFd, n, n2, EPOLL_WAIT_MILLIS_THRESHOLD);
    }

    private int epollWaitNoTimerChange() {
        return Native.epollWait(this.epollFd, this.events, false);
    }

    private int epollWaitNow() {
        return Native.epollWait(this.epollFd, this.events, true);
    }

    private int epollBusyWait() {
        return Native.epollBusyWait(this.epollFd, this.events);
    }

    private int epollWaitTimeboxed() {
        return Native.epollWait(this.epollFd, this.events, 1000);
    }

    /*
     * Exception decompiling
     */
    protected void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void closeAll() {
        AbstractEpollChannel[] abstractEpollChannelArray = this.channels.values().toArray(new AbstractEpollChannel[0]);
        AbstractEpollChannel[] abstractEpollChannelArray2 = abstractEpollChannelArray;
        abstractEpollChannelArray2 = abstractEpollChannelArray;
        int n = abstractEpollChannelArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractEpollChannel abstractEpollChannel = abstractEpollChannelArray2[i];
            abstractEpollChannel.unsafe().close(abstractEpollChannel.unsafe().voidPromise());
        }
    }

    private boolean processReady(EpollEventArray epollEventArray, int n) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = epollEventArray.fd(i);
            if (n2 == this.eventFd.intValue()) {
                this.pendingWakeup = false;
                continue;
            }
            if (n2 == this.timerFd.intValue()) {
                bl = true;
                continue;
            }
            long l = epollEventArray.events(i);
            AbstractEpollChannel abstractEpollChannel = (AbstractEpollChannel)((Object)this.channels.get(n2));
            if (abstractEpollChannel != null) {
                AbstractEpollChannel.AbstractEpollUnsafe abstractEpollUnsafe = (AbstractEpollChannel.AbstractEpollUnsafe)abstractEpollChannel.unsafe();
                if ((l & (long)(Native.EPOLLERR | Native.EPOLLOUT)) != 0L) {
                    abstractEpollUnsafe.epollOutReady();
                }
                if ((l & (long)(Native.EPOLLERR | Native.EPOLLIN)) != 0L) {
                    abstractEpollUnsafe.epollInReady();
                }
                if ((l & (long)Native.EPOLLRDHUP) == 0L) continue;
                abstractEpollUnsafe.epollRdHupReady();
                continue;
            }
            try {
                Native.epollCtlDel(this.epollFd.intValue(), n2);
                continue;
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    protected void cleanup() {
        try {
            this.closeFileDescriptors();
            return;
        }
        finally {
            if (this.iovArray != null) {
                this.iovArray.release();
                this.iovArray = null;
            }
            if (this.datagramPacketArray != null) {
                this.datagramPacketArray.release();
                this.datagramPacketArray = null;
            }
            this.events.free();
        }
    }

    public void closeFileDescriptors() {
        block8: while (this.pendingWakeup) {
            try {
                int n = this.epollWaitTimeboxed();
                if (n == 0) break;
                for (int i = 0; i < n; ++i) {
                    if (this.events.fd(i) != this.eventFd.intValue()) continue;
                    this.pendingWakeup = false;
                    continue block8;
                }
            }
            catch (IOException iOException) {
            }
        }
        try {
            this.eventFd.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close the event fd.", (Throwable)iOException);
        }
        try {
            this.timerFd.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close the timer fd.", (Throwable)iOException);
        }
        try {
            this.epollFd.close();
            return;
        }
        catch (IOException iOException) {
            logger.warn("Failed to close the epoll fd.", (Throwable)iOException);
            return;
        }
    }

    static {
        Epoll.ensureAvailability();
    }
}

