/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.SpringEstimationKt;
import androidx.compose.animation.core.SpringSimulation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J(\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J \u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/core/FloatSpringSpec;", "Landroidx/compose/animation/core/FloatAnimationSpec;", "dampingRatio", "", "stiffness", "visibilityThreshold", "<init>", "(FFF)V", "getDampingRatio", "()F", "getStiffness", "spring", "Landroidx/compose/animation/core/SpringSimulation;", "getValueFromNanos", "playTimeNanos", "", "initialValue", "targetValue", "initialVelocity", "getVelocityFromNanos", "getEndVelocity", "getDurationNanos", "animation-core"})
public final class FloatSpringSpec
implements FloatAnimationSpec {
    private final float dampingRatio;
    private final float stiffness;
    private final float visibilityThreshold;
    private final SpringSimulation spring;
    public static final int $stable = 8;

    public FloatSpringSpec(float f, float f2, float f3) {
        SpringSimulation springSimulation;
        this.dampingRatio = f;
        this.stiffness = f2;
        this.visibilityThreshold = f3;
        SpringSimulation springSimulation2 = springSimulation = new SpringSimulation(1.0f);
        FloatSpringSpec floatSpringSpec = this;
        springSimulation2.setDampingRatio(this.dampingRatio);
        springSimulation2.setStiffness(this.stiffness);
        floatSpringSpec.spring = springSimulation;
    }

    public /* synthetic */ FloatSpringSpec(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1500.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.01f;
        }
        this(f, f2, f3);
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final float getStiffness() {
        return this.stiffness;
    }

    @Override
    public final float getValueFromNanos(long l2, float f, float f2, float f3) {
        long l3 = l2 / 1000000L;
        this.spring.setFinalPosition(f2);
        long l4 = this.spring.updateValues-IJZedt4$animation_core(f, f3, l3);
        int n = (int)(l4 >> 32);
        return Float.intBitsToFloat(n);
    }

    @Override
    public final float getVelocityFromNanos(long l2, float f, float f2, float f3) {
        long l3 = l2 / 1000000L;
        this.spring.setFinalPosition(f2);
        long l4 = this.spring.updateValues-IJZedt4$animation_core(f, f3, l3);
        int n = (int)l4;
        return Float.intBitsToFloat(n);
    }

    @Override
    public final float getEndVelocity(float f, float f2, float f3) {
        return 0.0f;
    }

    @Override
    public final long getDurationNanos(float f, float f2, float f3) {
        float f4 = this.spring.getStiffness();
        float f5 = this.spring.getDampingRatio();
        f = (f - f2) / this.visibilityThreshold;
        f2 = f3 / this.visibilityThreshold;
        return SpringEstimationKt.estimateAnimationDurationMillis(f4, f5, f2, f, 1.0f) * 1000000L;
    }

    public FloatSpringSpec() {
        this(0.0f, 0.0f, 0.0f, 7, null);
    }
}

