/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.node.DepthSortedSetsForDifferentPasses;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasureAndLayoutDelegate;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/node/LayoutTreeConsistencyChecker;", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "relayoutNodes", "Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;", "postponedMeasureRequests", "", "Landroidx/compose/ui/node/MeasureAndLayoutDelegate$PostponedRequest;", "<init>", "(Landroidx/compose/ui/node/LayoutNode;Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;Ljava/util/List;)V", "assertConsistent", "", "isTreeConsistent", "", "node", "consistentLayoutState", "nodeToString", "", "logTree", "ui"})
public final class LayoutTreeConsistencyChecker {
    private final LayoutNode root;
    private final DepthSortedSetsForDifferentPasses relayoutNodes;
    private final List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests;
    public static final int $stable = 8;

    public LayoutTreeConsistencyChecker(LayoutNode layoutNode, DepthSortedSetsForDifferentPasses depthSortedSetsForDifferentPasses, List<MeasureAndLayoutDelegate.PostponedRequest> list) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"");
        Intrinsics.checkNotNullParameter((Object)depthSortedSetsForDifferentPasses, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.root = layoutNode;
        this.relayoutNodes = depthSortedSetsForDifferentPasses;
        this.postponedMeasureRequests = list;
    }

    public final void assertConsistent() {
        LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this;
        boolean bl = !layoutTreeConsistencyChecker.isTreeConsistent(layoutTreeConsistencyChecker.root);
        if (bl) {
            System.out.println((Object)this.logTree());
            throw new IllegalStateException("Inconsistency found!");
        }
    }

    private final boolean isTreeConsistent(LayoutNode object) {
        if (!this.consistentLayoutState((LayoutNode)object)) {
            return false;
        }
        object = ((LayoutNode)object).getChildren$ui();
        int n2 = ((Collection)object).size();
        for (int i = 0; i < n2; ++i) {
            Object object2 = object.get(i);
            if (this.isTreeConsistent((LayoutNode)(object2 = (LayoutNode)object2))) continue;
            return false;
        }
        return true;
    }

    private final boolean consistentLayoutState(LayoutNode layoutNode) {
        block31: {
            LayoutNode.LayoutState layoutState;
            LayoutNode layoutNode2;
            block32: {
                block34: {
                    block33: {
                        MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
                        MeasureAndLayoutDelegate.PostponedRequest postponedRequest2;
                        int n2;
                        int n3;
                        List<MeasureAndLayoutDelegate.PostponedRequest> list;
                        block25: {
                            block30: {
                                block29: {
                                    boolean bl;
                                    block22: {
                                        block26: {
                                            block28: {
                                                block27: {
                                                    block24: {
                                                        layoutNode2 = layoutNode.getParent$ui();
                                                        LayoutNode.LayoutState layoutState2 = layoutState = layoutNode2 != null ? layoutNode2.getLayoutState$ui() : null;
                                                        if (layoutNode.isPlaced()) break block24;
                                                        if (layoutNode.getPlaceOrder$ui() == Integer.MAX_VALUE) break block25;
                                                        LayoutNode layoutNode3 = layoutNode2;
                                                        boolean bl2 = layoutNode3 != null ? layoutNode3.isPlaced() : false;
                                                        if (!bl2) break block25;
                                                    }
                                                    if (layoutNode.getMeasurePending$ui()) {
                                                        MeasureAndLayoutDelegate.PostponedRequest postponedRequest3;
                                                        block21: {
                                                            list = this.postponedMeasureRequests;
                                                            n3 = ((Collection)list).size();
                                                            for (n2 = 0; n2 < n3; ++n2) {
                                                                MeasureAndLayoutDelegate.PostponedRequest postponedRequest4 = list.get(n2);
                                                                postponedRequest2 = postponedRequest4;
                                                                postponedRequest2 = postponedRequest4;
                                                                postponedRequest = postponedRequest4;
                                                                if (!(Intrinsics.areEqual((Object)postponedRequest4.getNode(), (Object)layoutNode) && !postponedRequest.isLookahead())) continue;
                                                                postponedRequest3 = postponedRequest2;
                                                                break block21;
                                                            }
                                                            postponedRequest3 = null;
                                                        }
                                                        if (postponedRequest3 != null) {
                                                            return true;
                                                        }
                                                    }
                                                    if (layoutNode.isDeactivated()) {
                                                        return true;
                                                    }
                                                    if (!layoutNode.getMeasurePending$ui()) break block26;
                                                    if (this.relayoutNodes.contains(layoutNode) || layoutNode.getLayoutState$ui() == LayoutNode.LayoutState.LookaheadMeasuring) break block27;
                                                    LayoutNode layoutNode4 = layoutNode2;
                                                    if (layoutNode4 != null ? layoutNode4.getMeasurePending$ui() : false) break block27;
                                                    LayoutNode layoutNode5 = layoutNode2;
                                                    boolean bl3 = layoutNode5 != null ? layoutNode5.getLookaheadMeasurePending$ui() : false;
                                                    if (!bl3 && layoutState != LayoutNode.LayoutState.Measuring) break block28;
                                                }
                                                return true;
                                            }
                                            return false;
                                        }
                                        if (!layoutNode.getLayoutPending$ui()) break block25;
                                        if (this.relayoutNodes.contains(layoutNode) || layoutNode2 == null || layoutNode2.getMeasurePending$ui() || layoutNode2.getLayoutPending$ui() || layoutState == LayoutNode.LayoutState.Measuring || layoutState == LayoutNode.LayoutState.LayingOut) break block29;
                                        list = this.postponedMeasureRequests;
                                        n3 = ((Collection)list).size();
                                        for (n2 = 0; n2 < n3; ++n2) {
                                            MeasureAndLayoutDelegate.PostponedRequest postponedRequest5 = list.get(n2);
                                            postponedRequest2 = postponedRequest5;
                                            postponedRequest2 = postponedRequest5;
                                            postponedRequest = postponedRequest5;
                                            if (!Intrinsics.areEqual((Object)postponedRequest5.getNode(), (Object)layoutNode)) continue;
                                            bl = true;
                                            break block22;
                                        }
                                        bl = false;
                                    }
                                    if (!bl && layoutNode.getLayoutState$ui() != LayoutNode.LayoutState.Measuring) break block30;
                                }
                                return true;
                            }
                            return false;
                        }
                        if (!Intrinsics.areEqual((Object)layoutNode.isPlacedInLookahead(), (Object)Boolean.TRUE)) break block31;
                        if (layoutNode.getLookaheadMeasurePending$ui()) {
                            MeasureAndLayoutDelegate.PostponedRequest postponedRequest6;
                            block23: {
                                list = this.postponedMeasureRequests;
                                n3 = ((Collection)list).size();
                                for (n2 = 0; n2 < n3; ++n2) {
                                    MeasureAndLayoutDelegate.PostponedRequest postponedRequest7 = list.get(n2);
                                    postponedRequest2 = postponedRequest7;
                                    postponedRequest2 = postponedRequest7;
                                    postponedRequest = postponedRequest7;
                                    if (!(Intrinsics.areEqual((Object)postponedRequest7.getNode(), (Object)layoutNode) && postponedRequest.isLookahead())) continue;
                                    postponedRequest6 = postponedRequest2;
                                    break block23;
                                }
                                postponedRequest6 = null;
                            }
                            if (postponedRequest6 != null) {
                                return true;
                            }
                        }
                        if (!layoutNode.getLookaheadMeasurePending$ui()) break block32;
                        if (this.relayoutNodes.contains(layoutNode, true)) break block33;
                        LayoutNode layoutNode6 = layoutNode2;
                        if ((layoutNode6 != null ? layoutNode6.getLookaheadMeasurePending$ui() : false) || layoutState == LayoutNode.LayoutState.LookaheadMeasuring) break block33;
                        LayoutNode layoutNode7 = layoutNode2;
                        boolean bl = layoutNode7 != null ? layoutNode7.getMeasurePending$ui() : false;
                        if (!bl || !Intrinsics.areEqual((Object)layoutNode.getLookaheadRoot$ui(), (Object)layoutNode)) break block34;
                    }
                    return true;
                }
                return false;
            }
            if (layoutNode.getLookaheadLayoutPending$ui()) {
                return this.relayoutNodes.contains(layoutNode, true) || layoutNode2 == null || layoutNode2.getLookaheadMeasurePending$ui() || layoutNode2.getLookaheadLayoutPending$ui() || layoutState == LayoutNode.LayoutState.LookaheadMeasuring || layoutState == LayoutNode.LayoutState.LookaheadLayingOut || layoutNode2.getLayoutPending$ui() && Intrinsics.areEqual((Object)layoutNode.getLookaheadRoot$ui(), (Object)layoutNode);
            }
        }
        return true;
    }

    private final String nodeToString(LayoutNode layoutNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(layoutNode);
        stringBuilder.append("[" + layoutNode.getLayoutState$ui() + "]");
        if (!layoutNode.isPlaced()) {
            stringBuilder.append("[!isPlaced]");
        }
        stringBuilder.append("[measuredByParent=" + layoutNode.getMeasuredByParent$ui() + "]");
        if (!this.consistentLayoutState(layoutNode)) {
            stringBuilder.append("[INCONSISTENT]");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private final String logTree() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tree state:\n");
        LayoutTreeConsistencyChecker.logTree$printSubTree(this, stringBuilder, this.root, 0);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final void logTree$printSubTree(LayoutTreeConsistencyChecker layoutTreeConsistencyChecker, StringBuilder stringBuilder, LayoutNode layoutNode, int n2) {
        int n3 = n2;
        Object object = layoutTreeConsistencyChecker.nodeToString(layoutNode);
        if (((CharSequence)object).length() > 0) {
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append("..");
            }
            stringBuilder.append((String)object).append('\n');
            n3 = n2 + 1;
        }
        List<LayoutNode> list = layoutNode.getChildren$ui();
        n2 = ((Collection)list).size();
        for (int i = 0; i < n2; ++i) {
            object = list.get(i);
            LayoutTreeConsistencyChecker.logTree$printSubTree(layoutTreeConsistencyChecker, stringBuilder, (LayoutNode)object, n3);
        }
    }
}

