/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopTextInputService;
import androidx.compose.ui.platform.DesktopTextInputService2Kt;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0005*\u0001.\b\u0001\u0018\u00002\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0004\u0012\u00020\u00120\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\u001a\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016J\u000e\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+H\u0002J\u0015\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u00100R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u00062"}, d2={"Landroidx/compose/ui/platform/DesktopTextInputService;", "Landroidx/compose/ui/text/input/PlatformTextInputService;", "component", "Landroidx/compose/ui/platform/PlatformComponent;", "<init>", "(Landroidx/compose/ui/platform/PlatformComponent;)V", "currentInput", "Landroidx/compose/ui/platform/DesktopTextInputService$CurrentInput;", "charKeyPressed", "", "getCharKeyPressed", "()Z", "setCharKeyPressed", "(Z)V", "needToDeletePreviousChar", "getNeedToDeletePreviousChar", "setNeedToDeletePreviousChar", "startInput", "", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "stopInput", "showSoftwareKeyboard", "hideSoftwareKeyboard", "updateState", "oldValue", "newValue", "notifyFocusedRect", "rect", "Landroidx/compose/ui/geometry/Rect;", "onKeyEvent", "keyEvent", "Ljava/awt/event/KeyEvent;", "inputMethodTextChanged", "event", "Ljava/awt/event/InputMethodEvent;", "replaceInputMethodText", "methodRequestsForInput", "androidx/compose/ui/platform/DesktopTextInputService$methodRequestsForInput$1", "input", "(Landroidx/compose/ui/platform/DesktopTextInputService$CurrentInput;)Landroidx/compose/ui/platform/DesktopTextInputService$methodRequestsForInput$1;", "CurrentInput", "ui"})
public final class DesktopTextInputService
implements PlatformTextInputService {
    private final PlatformComponent component;
    private CurrentInput currentInput;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;
    public static final int $stable = 8;

    public DesktopTextInputService(PlatformComponent platformComponent) {
        Intrinsics.checkNotNullParameter((Object)platformComponent, (String)"");
        this.component = platformComponent;
    }

    public final boolean getCharKeyPressed() {
        return this.charKeyPressed;
    }

    public final void setCharKeyPressed(boolean bl) {
        this.charKeyPressed = bl;
    }

    public final boolean getNeedToDeletePreviousChar() {
        return this.needToDeletePreviousChar;
    }

    public final void setNeedToDeletePreviousChar(boolean bl) {
        this.needToDeletePreviousChar = bl;
    }

    public final void startInput(TextFieldValue object, ImeOptions imeOptions, Function1<? super List<? extends EditCommand>, Unit> function1, Function1<? super ImeAction, Unit> function12) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(function12, (String)"");
        object = new CurrentInput((TextFieldValue)object, (Function1)function1, (Function1)function12, imeOptions.getImeAction-eUduSuo(), null, 16, null);
        this.currentInput = object;
        this.component.enableInput(this.methodRequestsForInput((CurrentInput)object));
    }

    public final void stopInput() {
        if (this.currentInput == null) {
            return;
        }
        this.component.disableInput();
        this.currentInput = null;
    }

    public final void showSoftwareKeyboard() {
    }

    public final void hideSoftwareKeyboard() {
    }

    public final void updateState(TextFieldValue textFieldValue, TextFieldValue textFieldValue2) {
        Intrinsics.checkNotNullParameter((Object)textFieldValue2, (String)"");
        CurrentInput currentInput = this.currentInput;
        if (currentInput != null) {
            currentInput.setValue(textFieldValue2);
            return;
        }
    }

    public final void notifyFocusedRect(Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"");
        CurrentInput currentInput = this.currentInput;
        if (currentInput != null) {
            currentInput.setFocusedRect(rect);
            return;
        }
    }

    public final void onKeyEvent(KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"");
        switch (keyEvent.getID()) {
            case 400: {
                this.charKeyPressed = true;
                return;
            }
            case 402: {
                this.charKeyPressed = false;
            }
        }
    }

    public final void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        Intrinsics.checkNotNullParameter((Object)inputMethodEvent, (String)"");
        if (this.currentInput != null && !inputMethodEvent.isConsumed()) {
            this.replaceInputMethodText(inputMethodEvent);
            inputMethodEvent.consume();
        }
    }

    private final void replaceInputMethodText(InputMethodEvent object) {
        CurrentInput currentInput = this.currentInput;
        if (currentInput == null) {
            return;
        }
        CurrentInput currentInput2 = currentInput;
        String string = DesktopTextInputService2Kt.getCommittedText((InputMethodEvent)object);
        object = DesktopTextInputService2Kt.getComposingText((InputMethodEvent)object);
        List list = new ArrayList();
        if (this.needToDeletePreviousChar && TextRange.getMin-impl((long)currentInput2.getValue().getSelection-d9O1mEE()) > 0 && ((CharSequence)object).length() == 0) {
            this.needToDeletePreviousChar = false;
            list.add(new DeleteSurroundingTextInCodePointsCommand(1, 0));
        }
        list.add(new CommitTextCommand(string, 1));
        if (((CharSequence)object).length() > 0) {
            list.add(new SetComposingTextCommand((String)object, 1));
        }
        currentInput2.getOnEditCommand().invoke((Object)list);
    }

    private final methodRequestsForInput.1 methodRequestsForInput(CurrentInput currentInput) {
        return new InputMethodRequests(currentInput, this){
            final /* synthetic */ CurrentInput $input;
            final /* synthetic */ DesktopTextInputService this$0;
            {
                this.$input = currentInput;
                this.this$0 = desktopTextInputService;
            }

            public final TextHitInfo getLocationOffset(int n2, int n3) {
                if (this.$input.getValue().getComposition-MzsxiRA() != null) {
                    return TextHitInfo.leading(0);
                }
                return null;
            }

            public final AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
                return null;
            }

            public final int getInsertPositionOffset() {
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                int n2 = textRange != null ? TextRange.getStart-impl((long)textRange.unbox-impl()) : 0;
                TextRange textRange2 = this.$input.getValue().getComposition-MzsxiRA();
                int n3 = textRange2 != null ? TextRange.getEnd-impl((long)textRange2.unbox-impl()) : 0;
                int n4 = TextRange.getStart-impl((long)this.$input.getValue().getSelection-d9O1mEE());
                if (n4 < n2) {
                    return n4;
                }
                if (n4 < n3) {
                    return n2;
                }
                return n4 - (n3 - n2);
            }

            public final int getCommittedTextLength() {
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                return this.$input.getValue().getText().length() - (textRange != null ? TextRange.getLength-impl((long)textRange.unbox-impl()) : 0);
            }

            public final AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] object) {
                if (this.this$0.getCharKeyPressed() && OsArch_jvmKt.getHostOs() == OS.MacOS) {
                    this.this$0.setNeedToDeletePreviousChar(true);
                }
                object = TextRangeKt.substring-FDrldGo((CharSequence)this.$input.getValue().getText(), (long)this.$input.getValue().getSelection-d9O1mEE());
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString((String)object).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"");
                return attributedCharacterIterator;
            }

            public final Rectangle getTextLocation(TextHitInfo textHitInfo) {
                Rect rect = this.$input.getFocusedRect();
                if (rect != null) {
                    textHitInfo = rect;
                    DesktopTextInputService desktopTextInputService = this.this$0;
                    int n2 = (int)(textHitInfo.getRight() / DesktopTextInputService.access$getComponent$p(desktopTextInputService).getDensity().getDensity()) + DesktopTextInputService.access$getComponent$p((DesktopTextInputService)desktopTextInputService).getLocationOnScreen().x;
                    int n3 = (int)(textHitInfo.getTop() / DesktopTextInputService.access$getComponent$p(desktopTextInputService).getDensity().getDensity()) + DesktopTextInputService.access$getComponent$p((DesktopTextInputService)desktopTextInputService).getLocationOnScreen().y;
                    TextHitInfo textHitInfo2 = textHitInfo;
                    int n4 = (int)(textHitInfo2.getRight() - textHitInfo2.getLeft());
                    textHitInfo2 = textHitInfo;
                    return new Rectangle(n2, n3, n4, (int)(textHitInfo2.getBottom() - textHitInfo2.getTop()));
                }
                return null;
            }

            public final AttributedCharacterIterator getCommittedText(int n2, int n3, AttributedCharacterIterator.Attribute[] textRange) {
                textRange = this.$input.getValue().getComposition-MzsxiRA();
                String string = this.$input.getValue().getText();
                long l2 = TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)n2, (int)string.length()), (int)RangesKt.coerceAtMost((int)n3, (int)string.length()));
                if (textRange == null) {
                    String string2 = TextRangeKt.substring-FDrldGo((CharSequence)string, (long)l2);
                    AttributedCharacterIterator attributedCharacterIterator = new AttributedString(string2).getIterator();
                    Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"");
                    return attributedCharacterIterator;
                }
                String string3 = TextRangeKt.substring-FDrldGo((CharSequence)string, (long)TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)Math.min(TextRange.getMin-impl((long)l2), TextRange.getMin-impl((long)textRange.unbox-impl())), (int)string.length()), (int)RangesKt.coerceAtMost((int)Math.max(TextRange.getMax-impl((long)l2), TextRange.getMax-impl((long)textRange.unbox-impl())), (int)string.length())));
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString(string3).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"");
                return attributedCharacterIterator;
            }
        };
    }

    public static final /* synthetic */ PlatformComponent access$getComponent$p(DesktopTextInputService desktopTextInputService) {
        return desktopTextInputService.component;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u0010\u0010!\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\"\u0010\u0018J\u000b\u0010#\u001a\u0004\u0018\u00010\rH\u00c6\u0003Jb\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00052\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00052\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00a2\u0006\u0004\b%\u0010&J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R#\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0013\u0010\u000b\u001a\u00020\n\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Landroidx/compose/ui/platform/DesktopTextInputService$CurrentInput;", "", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "imeAction", "focusedRect", "Landroidx/compose/ui/geometry/Rect;", "<init>", "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ILandroidx/compose/ui/geometry/Rect;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "getOnEditCommand", "()Lkotlin/jvm/functions/Function1;", "getOnImeActionPerformed", "getImeAction-eUduSuo", "()I", "I", "getFocusedRect", "()Landroidx/compose/ui/geometry/Rect;", "setFocusedRect", "(Landroidx/compose/ui/geometry/Rect;)V", "component1", "component2", "component3", "component4", "component4-eUduSuo", "component5", "copy", "copy-tNiH39Q", "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ILandroidx/compose/ui/geometry/Rect;)Landroidx/compose/ui/platform/DesktopTextInputService$CurrentInput;", "equals", "", "other", "hashCode", "", "toString", "", "ui"})
    public static final class CurrentInput {
        private TextFieldValue value;
        private final Function1<List<? extends EditCommand>, Unit> onEditCommand;
        private final Function1<ImeAction, Unit> onImeActionPerformed;
        private final int imeAction;
        private Rect focusedRect;
        public static final int $stable = 8;

        private CurrentInput(TextFieldValue textFieldValue, Function1<? super List<? extends EditCommand>, Unit> function1, Function1<? super ImeAction, Unit> function12, int n2, Rect rect) {
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
            Intrinsics.checkNotNullParameter(function1, (String)"");
            Intrinsics.checkNotNullParameter(function12, (String)"");
            this.value = textFieldValue;
            this.onEditCommand = function1;
            this.onImeActionPerformed = function12;
            this.imeAction = n2;
            this.focusedRect = rect;
        }

        public /* synthetic */ CurrentInput(TextFieldValue textFieldValue, Function1 function1, Function1 function12, int n2, Rect rect, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x10) != 0) {
                rect = null;
            }
            this(textFieldValue, function1, function12, n2, rect, null);
        }

        public final TextFieldValue getValue() {
            return this.value;
        }

        public final void setValue(TextFieldValue textFieldValue) {
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
            this.value = textFieldValue;
        }

        public final Function1<List<? extends EditCommand>, Unit> getOnEditCommand() {
            return this.onEditCommand;
        }

        public final Function1<ImeAction, Unit> getOnImeActionPerformed() {
            return this.onImeActionPerformed;
        }

        public final int getImeAction-eUduSuo() {
            return this.imeAction;
        }

        public final Rect getFocusedRect() {
            return this.focusedRect;
        }

        public final void setFocusedRect(Rect rect) {
            this.focusedRect = rect;
        }

        public final TextFieldValue component1() {
            return this.value;
        }

        public final Function1<List<? extends EditCommand>, Unit> component2() {
            return this.onEditCommand;
        }

        public final Function1<ImeAction, Unit> component3() {
            return this.onImeActionPerformed;
        }

        public final int component4-eUduSuo() {
            return this.imeAction;
        }

        public final Rect component5() {
            return this.focusedRect;
        }

        public final CurrentInput copy-tNiH39Q(TextFieldValue textFieldValue, Function1<? super List<? extends EditCommand>, Unit> function1, Function1<? super ImeAction, Unit> function12, int n2, Rect rect) {
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
            Intrinsics.checkNotNullParameter(function1, (String)"");
            Intrinsics.checkNotNullParameter(function12, (String)"");
            return new CurrentInput(textFieldValue, function1, function12, n2, rect, null);
        }

        public static /* synthetic */ CurrentInput copy-tNiH39Q$default(CurrentInput currentInput, TextFieldValue textFieldValue, Function1 function1, Function1 function12, int n2, Rect rect, int n3, Object object) {
            if ((n3 & 1) != 0) {
                textFieldValue = currentInput.value;
            }
            if ((n3 & 2) != 0) {
                function1 = currentInput.onEditCommand;
            }
            if ((n3 & 4) != 0) {
                function12 = currentInput.onImeActionPerformed;
            }
            if ((n3 & 8) != 0) {
                n2 = currentInput.imeAction;
            }
            if ((n3 & 0x10) != 0) {
                rect = currentInput.focusedRect;
            }
            return currentInput.copy-tNiH39Q(textFieldValue, function1, function12, n2, rect);
        }

        public final String toString() {
            return "CurrentInput(value=" + this.value + ", onEditCommand=" + this.onEditCommand + ", onImeActionPerformed=" + this.onImeActionPerformed + ", imeAction=" + ImeAction.toString-impl((int)this.imeAction) + ", focusedRect=" + this.focusedRect + ")";
        }

        public final int hashCode() {
            int n2 = this.value.hashCode();
            n2 = n2 * 31 + this.onEditCommand.hashCode();
            n2 = n2 * 31 + this.onImeActionPerformed.hashCode();
            n2 = n2 * 31 + ImeAction.hashCode-impl((int)this.imeAction);
            n2 = n2 * 31 + (this.focusedRect == null ? 0 : this.focusedRect.hashCode());
            return n2;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CurrentInput)) {
                return false;
            }
            object = (CurrentInput)object;
            if (!Intrinsics.areEqual((Object)this.value, (Object)((CurrentInput)object).value)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onEditCommand, ((CurrentInput)object).onEditCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onImeActionPerformed, ((CurrentInput)object).onImeActionPerformed)) {
                return false;
            }
            if (!ImeAction.equals-impl0((int)this.imeAction, (int)((CurrentInput)object).imeAction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.focusedRect, (Object)((CurrentInput)object).focusedRect);
        }

        public /* synthetic */ CurrentInput(TextFieldValue textFieldValue, Function1 function1, Function1 function12, int n2, Rect rect, DefaultConstructorMarker defaultConstructorMarker) {
            this(textFieldValue, (Function1<? super List<? extends EditCommand>, Unit>)function1, (Function1<? super ImeAction, Unit>)function12, n2, rect);
        }
    }
}

