/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import dorkbox.jna.linux.GCallback;
import dorkbox.jna.linux.GObject;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenu;
import dorkbox.systemTray.util.EventDispatch;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class GtkMenuItem
extends GtkBaseMenuItem
implements GCallback,
MenuItemPeer {
    private final GtkMenu parent;
    private volatile ActionListener callback;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';

    GtkMenuItem(GtkMenu gtkMenu) {
        super(Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic(""));
        this.parent = gtkMenu;
        GObject.g_signal_connect_object((Pointer)this._native, (String)"activate", (Callback)this, null, (int)0);
    }

    public int callback(Pointer object, Pointer pointer) {
        object = this.callback;
        if (object != null) {
            GtkEventDispatch.proxyClick((ActionListener)object);
        }
        return 1;
    }

    @Override
    public void setImage(MenuItem menuItem) {
        boolean bl = this.hasImage();
        this.setLegitImage(menuItem.getImage() != null);
        GtkEventDispatch.dispatch(() -> {
            if (this.image != null) {
                Gtk.Gtk2.gtk_container_remove(this._native, this.image);
                this.image = null;
            }
            if (menuItem.getImage() != null) {
                this.removeSpacerImage();
                this.image = Gtk.Gtk2.gtk_image_new_from_file(menuItem.getImage().getAbsolutePath());
                Gtk.Gtk2.gtk_image_menu_item_set_image(this._native, this.image);
                Gtk.Gtk2.gtk_image_menu_item_set_always_show_image(this._native, true);
            } else if (bl) {
                this.addSpacerImage();
            }
            Gtk.Gtk2.gtk_widget_show_all(this._native);
        });
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_sensitive(this._native, menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem object) {
        int n;
        String string;
        object = this.mnemonicKey != '\u0000' ? ((string = ((MenuItem)object).getText()) != null ? ((n = string.toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? string.substring(0, n) + "_" + string.substring(n) : ((MenuItem)object).getText()) : null) : ((MenuItem)object).getText();
        GtkEventDispatch.dispatch(() -> this.lambda$setText$2((String)object));
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    1 v0 = this;
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(v0.menuItem, 1001, ""));
                            return;
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)v0.menuItem.getText(), (Object)throwable);
                            return;
                        }
                    });
                }
            };
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char c = menuItem.getShortcut();
        this.mnemonicKey = c != '\u0000' ? Character.toLowerCase(c) : (char)'\u0000';
        this.setText(menuItem);
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_tooltip_text(this._native, menuItem.getTooltip()));
    }

    @Override
    public void remove() {
        GtkEventDispatch.dispatch(() -> {
            GtkMenuItem.super.remove();
            this.callback = null;
            Gtk.Gtk2.gtk_container_remove(this.parent._nativeMenu, this._native);
            if (this.image != null) {
                Gtk.Gtk2.gtk_container_remove(this._native, this.image);
                this.image = null;
            }
            this.parent.remove(this);
        });
    }

    private /* synthetic */ void lambda$setText$2(String string) {
        Gtk.Gtk2.gtk_menu_item_set_label(this._native, string);
        Gtk.Gtk2.gtk_widget_show_all(this._native);
    }
}

