/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.AddressResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AddressResolverGroup<T extends SocketAddress>
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AddressResolverGroup.class);
    private final Map<EventExecutor, AddressResolver<T>> resolvers = new IdentityHashMap<EventExecutor, AddressResolver<T>>();
    private final Map<EventExecutor, GenericFutureListener<Future<Object>>> executorTerminationListeners = new IdentityHashMap<EventExecutor, GenericFutureListener<Future<Object>>>();

    protected AddressResolverGroup() {
    }

    public AddressResolver<T> getResolver(final EventExecutor eventExecutor) {
        AddressResolver<T> addressResolver;
        ObjectUtil.checkNotNull((Object)eventExecutor, (String)"executor");
        if (eventExecutor.isShuttingDown()) {
            throw new IllegalStateException("executor not accepting a task");
        }
        Map<EventExecutor, AddressResolver<T>> map = this.resolvers;
        synchronized (map) {
            addressResolver = this.resolvers.get(eventExecutor);
            if (addressResolver == null) {
                try {
                    addressResolver = this.newResolver(eventExecutor);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to create a new resolver", exception);
                }
                this.resolvers.put(eventExecutor, addressResolver);
                FutureListener<Object> futureListener = new FutureListener<Object>(){

                    public void operationComplete(Future<Object> object) {
                        object = AddressResolverGroup.this.resolvers;
                        synchronized (object) {
                            AddressResolverGroup.this.resolvers.remove(eventExecutor);
                            AddressResolverGroup.this.executorTerminationListeners.remove(eventExecutor);
                        }
                        addressResolver.close();
                    }
                };
                this.executorTerminationListeners.put(eventExecutor, (GenericFutureListener<Future<Object>>)futureListener);
                eventExecutor.terminationFuture().addListener((GenericFutureListener)futureListener);
            }
        }
        return addressResolver;
    }

    protected abstract AddressResolver<T> newResolver(EventExecutor var1);

    @Override
    public void close() {
        Object[] objectArray = this.resolvers;
        synchronized (this.resolvers) {
            Object object;
            int n;
            AddressResolver[] addressResolverArray = this.resolvers.values().toArray(new AddressResolver[0]);
            this.resolvers.clear();
            Map.Entry[] entryArray = this.executorTerminationListeners.entrySet().toArray(new Map.Entry[0]);
            this.executorTerminationListeners.clear();
            // ** MonitorExit[var3_1] (shouldn't be in output)
            objectArray = entryArray;
            int n2 = entryArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                ((EventExecutor)object.getKey()).terminationFuture().removeListener((GenericFutureListener)object.getValue());
            }
            objectArray = addressResolverArray;
            n2 = addressResolverArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                try {
                    object.close();
                    continue;
                }
                catch (Throwable throwable) {
                    logger.warn("Failed to close a resolver:", throwable);
                }
            }
            return;
        }
    }
}

