/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.formtypes;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlUtil;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FormFieldRegistry {
    private static final Logger LOGGER = Logger.getLogger(FormFieldRegistry.class.getName());
    private static final Map<String, Map<String, FormField.Type>> REGISTRY = new HashMap<String, Map<String, FormField.Type>>();
    private static final Map<String, FormField.Type> CLARK_NOTATION_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();
    private static final Map<String, FormField.Type> LOOKASIDE_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();

    public static void register(DataForm object) {
        if (((DataForm)((Object)object)).getType() != DataForm.Type.form) {
            throw new IllegalArgumentException();
        }
        String string = null;
        TextSingleFormField textSingleFormField = ((DataForm)((Object)object)).getHiddenFormTypeField();
        if (textSingleFormField != null) {
            string = textSingleFormField.getValue();
        }
        for (FormField formField : ((DataForm)((Object)object)).getFields()) {
            FormField.Type type;
            if (formField == textSingleFormField || (type = formField.getType()) == FormField.Type.fixed) continue;
            String string2 = formField.getFieldName();
            FormFieldRegistry.register(string, string2, type);
        }
    }

    public static void register(String string, FormField.Type type, String ... stringArray) {
        for (String string2 : stringArray) {
            FormFieldRegistry.register(string, string2, type);
        }
    }

    public static void register(String object, String string, FormField.Type type) {
        StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"fieldName must be provided");
        Objects.requireNonNull((Object)((Object)type));
        if (object == null) {
            if (XmlUtil.isClarkNotation((String)string)) {
                CLARK_NOTATION_FIELD_REGISTRY.put(string, type);
            }
            return;
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            Map<String, FormField.Type> map2 = REGISTRY.get(object);
            if (map2 == null) {
                map2 = new HashMap<String, FormField.Type>();
                REGISTRY.put((String)object, map2);
            } else {
                object = map2.get(string);
                if (object != null && object != type) {
                    throw new IllegalArgumentException();
                }
            }
            object = map2.put(string, type);
        }
        if (object != null && type != object) {
            LOGGER.warning("Form field registry inconsitency detected: Registered field '" + string + "' of type " + (Object)((Object)type) + " but previous type was " + object);
        }
    }

    public static FormField.Type lookup(String object, String string) {
        if (object == null) {
            if (XmlUtil.isClarkNotation((String)string)) {
                return CLARK_NOTATION_FIELD_REGISTRY.get(string);
            }
            return LOOKASIDE_FIELD_REGISTRY.get(string);
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            object = REGISTRY.get(object);
            if (object != null && (object = (FormField.Type)((Object)object.get(string))) != null) {
                return object;
            }
        }
        return null;
    }

    public static synchronized FormField.Type lookup(String string) {
        return FormFieldRegistry.lookup(null, string);
    }

    public static void addLookasideFieldRegistryEntry(String string, FormField.Type type) {
        LOOKASIDE_FIELD_REGISTRY.put(string, type);
    }
}

