/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pep;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.e.a.e;
import org.e.a.i;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.jidtype.FromJidTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepListener;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubFeature;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.filter.EventItemsExtensionFilter;

public final class PepManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(PepManager.class.getName());
    private static final Map<XMPPConnection, PepManager> INSTANCES = new WeakHashMap<XMPPConnection, PepManager>();
    private static final StanzaFilter PEP_EVENTS_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_HEADLINE, FromJidTypeFilter.ENTITY_BARE_JID, EventItemsExtensionFilter.INSTANCE});
    private final Set<PepListener> pepListeners = new CopyOnWriteArraySet<PepListener>();
    private final AsyncButOrdered<e> asyncButOrdered = new AsyncButOrdered();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final PubSubManager pepPubSubManager;
    private final MultiMap<String, PepEventListenerCoupling<? extends ExtensionElement>> pepEventListeners = new MultiMap();
    private final Map<PepEventListener<?>, PepEventListenerCoupling<?>> listenerToCouplingMap = new HashMap();
    private static final PubSubFeature[] REQUIRED_FEATURES = new PubSubFeature[]{PubSubFeature.auto_create, PubSubFeature.auto_subscribe, PubSubFeature.filtered_notifications};

    public static synchronized PepManager getInstanceFor(XMPPConnection xMPPConnection) {
        PepManager pepManager = INSTANCES.get(xMPPConnection);
        if (pepManager == null) {
            pepManager = new PepManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, pepManager);
        }
        return pepManager;
    }

    private PepManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        this.pepPubSubManager = PubSubManager.getInstanceFor(xMPPConnection, null);
        StanzaListener stanzaListener = new StanzaListener(){

            public void processStanza(Stanza object) {
                Message message = (Message)object;
                object = EventElement.from(object);
                assert (object != null);
                e e2 = message.getFrom().o();
                assert (e2 != null);
                PepManager.this.asyncButOrdered.performAsyncButOrdered((Object)e2, new Runnable((EventElement)object, e2, message){
                    final /* synthetic */ EventElement val$event;
                    final /* synthetic */ e val$from;
                    final /* synthetic */ Message val$message;
                    {
                        this.val$event = eventElement;
                        this.val$from = e2;
                        this.val$message = message;
                    }

                    @Override
                    public void run() {
                        Object object;
                        Object object22;
                        ItemsExtension itemsExtension = (ItemsExtension)this.val$event.getEvent();
                        Object object3 = itemsExtension.getNode();
                        for (Object object22 : PepManager.this.pepListeners) {
                            object22.eventReceived(this.val$from, this.val$event, this.val$message);
                        }
                        object22 = PepManager.this.pepEventListeners;
                        synchronized (object22) {
                            object = PepManager.this.pepEventListeners.getAll(object3);
                            if (object.isEmpty()) {
                                return;
                            }
                            object = CollectionUtil.newListWith((Collection)object);
                        }
                        object22 = object.iterator();
                        while (object22.hasNext()) {
                            object3 = (PepEventListenerCoupling)object22.next();
                            object = itemsExtension.getItems();
                            object = object.iterator();
                            while (object.hasNext()) {
                                Object object4 = (NamedElement)object.next();
                                object4 = (Item)object4;
                                String string = object4.getId();
                                object4 = (PayloadItem)object4;
                                object4 = object4.getPayload();
                                ((PepEventListenerCoupling)object3).invoke(this.val$from, (ExtensionElement)object4, string, this.val$message);
                            }
                        }
                    }
                });
            }
        };
        xMPPConnection.addSyncStanzaListener(stanzaListener, PEP_EVENTS_FILTER);
    }

    public final <E extends ExtensionElement> boolean addPepEventListener(String string, Class<E> object, PepEventListener<E> pepEventListener) {
        object = new PepEventListenerCoupling(string, (Class)object, pepEventListener);
        MultiMap<String, PepEventListenerCoupling<? extends ExtensionElement>> multiMap = this.pepEventListeners;
        synchronized (multiMap) {
            if (this.listenerToCouplingMap.containsKey(pepEventListener)) {
                return false;
            }
            this.listenerToCouplingMap.put(pepEventListener, (PepEventListenerCoupling<?>)object);
            boolean bl = this.pepEventListeners.put((Object)string, object);
            if (!bl) {
                this.serviceDiscoveryManager.addFeature(string + "+notify");
            }
        }
        return true;
    }

    public final boolean removePepEventListener(PepEventListener<?> object) {
        MultiMap<String, PepEventListenerCoupling<? extends ExtensionElement>> multiMap = this.pepEventListeners;
        synchronized (multiMap) {
            object = this.listenerToCouplingMap.remove(object);
            if (object == null) {
                return false;
            }
            String string = ((PepEventListenerCoupling)object).node;
            boolean bl = this.pepEventListeners.removeOne((Object)string, object);
            assert (bl);
            if (!this.pepEventListeners.containsKey((Object)((PepEventListenerCoupling)object).node)) {
                this.serviceDiscoveryManager.removeFeature(string + "+notify");
            }
        }
        return true;
    }

    public final PubSubManager getPepPubSubManager() {
        return this.pepPubSubManager;
    }

    @Deprecated
    public final boolean addPepListener(PepListener pepListener) {
        return this.pepListeners.add(pepListener);
    }

    @Deprecated
    public final boolean removePepListener(PepListener pepListener) {
        return this.pepListeners.remove(pepListener);
    }

    public final LeafNode publish(String string, Item item) {
        return this.pepPubSubManager.tryToPublishAndPossibleAutoCreate(string, item);
    }

    public final boolean isSupported() {
        XMPPConnection xMPPConnection = this.connection();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        xMPPConnection = xMPPConnection.getUser().n();
        return serviceDiscoveryManager.supportsFeatures((i)xMPPConnection, REQUIRED_FEATURES);
    }

    private static final class PepEventListenerCoupling<E extends ExtensionElement> {
        private final String node;
        private final Class<E> extensionElementType;
        private final PepEventListener<E> pepEventListener;

        private PepEventListenerCoupling(String string, Class<E> clazz, PepEventListener<E> pepEventListener) {
            this.node = string;
            this.extensionElementType = clazz;
            this.pepEventListener = pepEventListener;
        }

        private void invoke(e e2, ExtensionElement extensionElement, String string, Message message) {
            if (!this.extensionElementType.isInstance(extensionElement)) {
                LOGGER.warning("Ignoring " + extensionElement + " from " + message + " as it is not of type " + this.extensionElementType);
                return;
            }
            extensionElement = (ExtensionElement)this.extensionElementType.cast(extensionElement);
            this.pepEventListener.onPepEvent(e2, extensionElement, string, message);
        }
    }
}

