/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class PooledUnsafeDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final ObjectPool<PooledUnsafeDirectByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledUnsafeDirectByteBuf>(){

        public final PooledUnsafeDirectByteBuf newObject(ObjectPool.Handle<PooledUnsafeDirectByteBuf> handle) {
            return new PooledUnsafeDirectByteBuf(handle, 0);
        }
    });
    private long memoryAddress;

    static PooledUnsafeDirectByteBuf newInstance(int n) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = (PooledUnsafeDirectByteBuf)RECYCLER.get();
        pooledUnsafeDirectByteBuf.reuse(n);
        return pooledUnsafeDirectByteBuf;
    }

    private PooledUnsafeDirectByteBuf(ObjectPool.Handle<PooledUnsafeDirectByteBuf> handle, int n) {
        super(handle, n);
    }

    @Override
    final void init(PoolChunk<ByteBuffer> poolChunk, ByteBuffer byteBuffer, long l, int n, int n2, int n3, PoolThreadCache poolThreadCache) {
        super.init(poolChunk, byteBuffer, l, n, n2, n3, poolThreadCache);
        this.initMemoryAddress();
    }

    @Override
    final void initUnpooled(PoolChunk<ByteBuffer> poolChunk, int n) {
        super.initUnpooled(poolChunk, n);
        this.initMemoryAddress();
    }

    private void initMemoryAddress() {
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)((ByteBuffer)this.memory)) + (long)this.offset;
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    protected final byte _getByte(int n) {
        return UnsafeByteBufUtil.getByte(this.addr(n));
    }

    @Override
    protected final short _getShort(int n) {
        return UnsafeByteBufUtil.getShort(this.addr(n));
    }

    @Override
    protected final short _getShortLE(int n) {
        return UnsafeByteBufUtil.getShortLE(this.addr(n));
    }

    @Override
    protected final int _getUnsignedMedium(int n) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n));
    }

    @Override
    protected final int _getUnsignedMediumLE(int n) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(n));
    }

    @Override
    protected final int _getInt(int n) {
        return UnsafeByteBufUtil.getInt(this.addr(n));
    }

    @Override
    protected final int _getIntLE(int n) {
        return UnsafeByteBufUtil.getIntLE(this.addr(n));
    }

    @Override
    protected final long _getLong(int n) {
        return UnsafeByteBufUtil.getLong(this.addr(n));
    }

    @Override
    protected final long _getLongLE(int n) {
        return UnsafeByteBufUtil.getLongLE(this.addr(n));
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n), n, byteBuf, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n), n, byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n), n, byteBuffer);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n), n, outputStream, n2);
        return this;
    }

    @Override
    protected final void _setByte(int n, int n2) {
        UnsafeByteBufUtil.setByte(this.addr(n), (byte)n2);
    }

    @Override
    protected final void _setShort(int n, int n2) {
        UnsafeByteBufUtil.setShort(this.addr(n), n2);
    }

    @Override
    protected final void _setShortLE(int n, int n2) {
        UnsafeByteBufUtil.setShortLE(this.addr(n), n2);
    }

    @Override
    protected final void _setMedium(int n, int n2) {
        UnsafeByteBufUtil.setMedium(this.addr(n), n2);
    }

    @Override
    protected final void _setMediumLE(int n, int n2) {
        UnsafeByteBufUtil.setMediumLE(this.addr(n), n2);
    }

    @Override
    protected final void _setInt(int n, int n2) {
        UnsafeByteBufUtil.setInt(this.addr(n), n2);
    }

    @Override
    protected final void _setIntLE(int n, int n2) {
        UnsafeByteBufUtil.setIntLE(this.addr(n), n2);
    }

    @Override
    protected final void _setLong(int n, long l) {
        UnsafeByteBufUtil.setLong(this.addr(n), l);
    }

    @Override
    protected final void _setLongLE(int n, long l) {
        UnsafeByteBufUtil.setLongLE(this.addr(n), l);
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n), n, byteBuf, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n), n, byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n), n, byteBuffer);
        return this;
    }

    @Override
    public final int setBytes(int n, InputStream inputStream, int n2) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.setBytes(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n), n, inputStream, n2);
    }

    @Override
    public final ByteBuf copy(int n, int n2) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.copy(pooledUnsafeDirectByteBuf, pooledUnsafeDirectByteBuf.addr(n), n, n2);
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public final boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public final long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    private long addr(int n) {
        return this.memoryAddress + (long)n;
    }

    @Override
    protected final SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public final ByteBuf setZero(int n, int n2) {
        this.checkIndex(n, n2);
        UnsafeByteBufUtil.setZero(this.addr(n), n2);
        return this;
    }

    @Override
    public final ByteBuf writeZero(int n) {
        ((ByteBuf)this).ensureWritable(n);
        int n2 = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(n2), n);
        this.writerIndex = n2 + n;
        return this;
    }
}

