/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.jvm;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.cache.TempJarCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class JNILibLoaderBase {
    public static final boolean DEBUG;
    protected static final boolean PERF;
    private static final Object perfSync;
    private static long perfTotal;
    private static long perfCount;
    private static final HashSet<String> loaded;
    private static LoaderAction loaderAction;
    private static final String nativeJarTagPackage = "jogamp.nativetag";
    private static final Method customLoadLibraryMethod;

    public static boolean isLoaded(String string) {
        return loaded.contains(string);
    }

    public static void addLoaded(String string) {
        loaded.add(string);
        if (DEBUG) {
            System.err.println("JNILibLoaderBase: Loaded Native Library: " + string);
        }
    }

    public static void disableLoading() {
        JNILibLoaderBase.setLoadingAction(null);
    }

    public static void enableLoading() {
        JNILibLoaderBase.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction loaderAction) {
        JNILibLoaderBase.loaderAction = loaderAction;
    }

    private static final boolean addNativeJarLibsImpl(Class<?> clazz, Uri uri, Uri.Encoded encoded, Uri.Encoded encoded2) {
        boolean bl;
        long l;
        block24: {
            Object object;
            Object object2;
            block22: {
                if (DEBUG) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("JNILibLoaderBase: addNativeJarLibsImpl(").append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  classFromJavaJar  = ").append(clazz).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  classJarURI       = ").append(uri).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  jarBasename       = ").append(encoded).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  os.and.arch       = ").append(PlatformPropsImpl.os_and_arch).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  nativeJarBasename = ").append(encoded2).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append(")");
                    System.err.println(stringBuilder.toString());
                }
                l = PERF ? System.currentTimeMillis() : 0L;
                bl = false;
                object2 = uri.getContainedUri();
                if (object2 == null) {
                    throw new IllegalArgumentException("JarSubURI is null of: " + uri);
                }
                uri = ((Uri)object2).getDirectory();
                if (DEBUG) {
                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: initial: %s -> %s%n", object2, uri);
                }
                object2 = String.format(null, "natives/%s/", PlatformPropsImpl.os_and_arch);
                if (DEBUG) {
                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: nativeLibraryPath: %s%n", object2);
                }
                object = JarUtil.getJarFileUri(uri.getEncoded().concat(encoded2));
                if (DEBUG) {
                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: module: %s -> %s%n", encoded2, object);
                }
                try {
                    bl = TempJarCache.addNativeLibs(clazz, (Uri)object, (String)object2);
                }
                catch (Exception exception) {
                    if (!DEBUG) break block22;
                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: Caught %s%n", exception.getMessage());
                    exception.printStackTrace();
                }
            }
            if (!bl) {
                Object object3;
                Object object4;
                block23: {
                    object = clazz.getClassLoader();
                    object4 = ((ClassLoader)object).getResource((String)object2);
                    if (object4 != null) {
                        object3 = JarUtil.getJarFileUri(uri.getEncoded().concat(encoded));
                        try {
                            if (TempJarCache.addNativeLibs(clazz, (Uri)object3, (String)object2)) {
                                bl = true;
                                if (DEBUG) {
                                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: fat: %s -> %s%n", encoded, object3);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!DEBUG) break block23;
                            System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: Caught %s%n", exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
                if (!bl) {
                    object3 = clazz.getPackage().getName();
                    int n = ((String)object3).lastIndexOf(46);
                    object4 = n >= 0 ? ((String)object3).substring(n + 1) : object3;
                    object3 = PlatformPropsImpl.os_and_arch.replace('-', '.');
                    String string = "jogamp.nativetag." + (String)object4 + "." + (String)object3 + ".TAG";
                    try {
                        if (DEBUG) {
                            System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: ClassLoader/TAG: Locating module %s, os.and.arch %s: %s%n", object4, object3, string);
                        }
                        Uri uri2 = JarUtil.getJarUri(string, (ClassLoader)object);
                        if (DEBUG) {
                            System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: ClassLoader/TAG: %s -> %s%n", string, uri2);
                        }
                        bl = TempJarCache.addNativeLibs(clazz, uri2, (String)object2);
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block24;
                        System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: Caught %s%n", exception.getMessage());
                        exception.printStackTrace();
                    }
                }
            }
        }
        if (DEBUG || PERF) {
            long l2;
            long l3;
            long l4 = System.currentTimeMillis() - l;
            Object object = perfSync;
            synchronized (object) {
                l3 = perfCount + 1L;
                perfTotal = l2 = perfTotal + l4;
                perfCount = l3;
            }
            double d = (double)l2 / (double)l3;
            System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl.X: %s / %s -> ok: %b; duration: now %d ms, total %d ms (count %d, avrg %.3f ms)%n", encoded, encoded2, bl, l4, l2, l3, d);
        }
        return bl;
    }

    public static final boolean addNativeJarLibsJoglCfg(Class<?>[] classArray) {
        return JNILibLoaderBase.addNativeJarLibs(classArray, "-all");
    }

    public static boolean addNativeJarLibs(Class<?>[] classArray, String string) {
        if (DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JNILibLoaderBase: addNativeJarLibs(").append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append("  classesFromJavaJars   = ").append(Arrays.asList(classArray)).append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append("  singleJarMarker       = ").append(string).append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append(")");
            System.err.println(stringBuilder.toString());
        }
        boolean bl = false;
        if (TempJarCache.isInitialized(true)) {
            bl = JNILibLoaderBase.addNativeJarLibsWithTempJarCache(classArray, string);
        } else if (DEBUG) {
            System.err.println("JNILibLoaderBase: addNativeJarLibs0: disabled due to uninitialized TempJarCache");
        }
        return bl;
    }

    private static boolean addNativeJarLibsWithTempJarCache(Class<?>[] classArray, String string) {
        boolean bl;
        int n = 0;
        try {
            boolean bl2 = false;
            bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                Uri.Encoded encoded;
                Class<?> clazz = classArray[i];
                if (clazz == null) continue;
                Object object = clazz.getClassLoader();
                object = JarUtil.getJarUri(clazz.getName(), (ClassLoader)object);
                Uri.Encoded encoded2 = JarUtil.getJarBasename((Uri)object);
                if (encoded2 == null) continue;
                Uri.Encoded encoded3 = encoded2.substring(0, encoded2.indexOf(".jar"));
                if (DEBUG) {
                    System.err.printf("JNILibLoaderBase: jarBasename: %s%n", encoded3);
                }
                if (string != null && encoded3.indexOf(string) >= 0) {
                    bl2 = true;
                }
                if (bl = JNILibLoaderBase.addNativeJarLibsImpl(clazz, (Uri)object, encoded2, encoded = Uri.Encoded.cast(String.format(null, "%s-natives-%s.jar", encoded3.get(), PlatformPropsImpl.os_and_arch)))) {
                    ++n;
                }
                if (!DEBUG || !bl2) continue;
                System.err.printf("JNILibLoaderBase: addNativeJarLibs0: done: %s%n", encoded3);
            }
        }
        catch (Exception exception) {
            System.err.printf("JNILibLoaderBase: Caught %s: %s%n", exception.getClass().getSimpleName(), exception.getMessage());
            if (DEBUG) {
                exception.printStackTrace();
            }
            bl = false;
        }
        if (DEBUG) {
            System.err.printf("JNILibLoaderBase: addNativeJarLibsWhenInitialized: count %d, ok %b%n", n, bl);
        }
        return bl;
    }

    protected static synchronized boolean loadLibrary(String string, boolean bl, ClassLoader classLoader) {
        if (loaderAction != null) {
            return loaderAction.loadLibrary(string, bl, classLoader);
        }
        return false;
    }

    protected static synchronized void loadLibrary(String string, String[] stringArray, boolean bl, ClassLoader classLoader) {
        if (loaderAction != null) {
            loaderAction.loadLibrary(string, stringArray, bl, classLoader);
        }
    }

    private static void loadLibraryInternal(String string, ClassLoader object) {
        int n = 0;
        if (customLoadLibraryMethod != null && !string.equals("jawt")) {
            if (DEBUG) {
                System.err.println("JNILibLoaderBase: customLoad(" + string + ") - mode 1");
            }
            try {
                customLoadLibraryMethod.invoke(null, string);
                n = 1;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                Throwable throwable = exception;
                if (exception instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("can not load library " + string).initCause(exception2);
            }
        }
        Object object2 = NativeLibrary.findLibrary(string, (ClassLoader)object);
        if (DEBUG) {
            System.err.println("JNILibLoaderBase: loadLibraryInternal(" + string + "), TempJarCache: " + (String)object2);
        }
        if (object2 != null) {
            if (DEBUG) {
                System.err.println("JNILibLoaderBase: System.load(" + (String)object2 + ") - mode 2");
            }
            System.load((String)object2);
            n = 2;
        } else {
            if (DEBUG) {
                System.err.println("JNILibLoaderBase: System.loadLibrary(" + string + ") - mode 3: SystemEnvLibraryPaths: " + NativeLibrary.getSystemEnvLibraryPaths());
            }
            try {
                System.loadLibrary(string);
                n = 3;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (DEBUG) {
                    System.err.println("ERROR mode 3 - " + unsatisfiedLinkError.getMessage());
                }
                String string2 = string;
                object = NativeLibrary.enumerateLibraryPaths(string2, string2, string, (ClassLoader)object);
                object2 = object.iterator();
                while (n == 0 && object2.hasNext()) {
                    String string3 = (String)object2.next();
                    if (DEBUG) {
                        System.err.println("JNILibLoaderBase: System.load(" + string3 + ") - mode 4");
                    }
                    try {
                        System.load(string3);
                        n = 4;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                        if (DEBUG) {
                            System.err.println("n/a - " + unsatisfiedLinkError2.getMessage());
                        }
                        if (object2.hasNext()) continue;
                        throw new UnsatisfiedLinkError("Couldn't load library '" + string + "' generically including " + NativeLibrary.getSystemEnvLibraryPaths() + ", nor as " + object);
                    }
                }
            }
        }
        if (DEBUG) {
            System.err.println("JNILibLoaderBase: loadLibraryInternal(" + string + "): OK - mode " + n);
        }
    }

    static {
        Method method;
        Debug.initSingleton();
        DEBUG = Debug.debug("JNILibLoader");
        PERF = DEBUG || PropertyAccess.isPropertyDefined("jogamp.debug.JNILibLoader.Perf", true);
        perfSync = new Object();
        perfTotal = 0L;
        perfCount = 0L;
        loaded = new HashSet();
        loaderAction = new DefaultAction();
        customLoadLibraryMethod = method = SecurityUtil.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                Method method;
                block13: {
                    String string;
                    boolean bl = PropertyAccess.getBooleanProperty("sun.jnlp.applet.launcher", true);
                    Class<?> clazz = null;
                    method = null;
                    if (bl) {
                        try {
                            clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            System.err.println("JNILibLoaderBase: <org.jdesktop.applet.util.JNLPAppletLauncher> not found, despite enabled property <sun.jnlp.applet.launcher>, JNLPAppletLauncher was probably used before");
                            System.setProperty("sun.jnlp.applet.launcher", Boolean.FALSE.toString());
                        }
                        catch (LinkageError linkageError) {
                            LinkageError linkageError2 = linkageError;
                            throw linkageError;
                        }
                        if (clazz != null) {
                            try {
                                method = clazz.getDeclaredMethod("loadLibrary", String.class);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                if (DEBUG) {
                                    noSuchMethodException.printStackTrace();
                                }
                                clazz = null;
                            }
                        }
                    }
                    if (clazz == null && (string = PropertyAccess.getProperty("jnlp.launcher.class", false)) != null) {
                        try {
                            clazz = Class.forName(string);
                            method = clazz.getDeclaredMethod("loadLibrary", String.class);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (DEBUG) {
                                classNotFoundException.printStackTrace();
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (!DEBUG) break block13;
                            noSuchMethodException.printStackTrace();
                        }
                    }
                }
                return method;
            }
        });
    }

    public static interface LoaderAction {
        public boolean loadLibrary(String var1, boolean var2, ClassLoader var3);

        public void loadLibrary(String var1, String[] var2, boolean var3, ClassLoader var4);
    }

    private static class DefaultAction
    implements LoaderAction {
        private DefaultAction() {
        }

        @Override
        public boolean loadLibrary(String string, boolean bl, ClassLoader classLoader) {
            boolean bl2;
            block5: {
                bl2 = true;
                if (!JNILibLoaderBase.isLoaded(string)) {
                    try {
                        JNILibLoaderBase.loadLibraryInternal(string, classLoader);
                        JNILibLoaderBase.addLoaded(string);
                        if (DEBUG) {
                            System.err.println("JNILibLoaderBase: loaded " + string);
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        bl2 = false;
                        if (DEBUG) {
                            unsatisfiedLinkError.printStackTrace();
                        }
                        if (bl || unsatisfiedLinkError.getMessage().indexOf("already loaded") >= 0) break block5;
                        throw unsatisfiedLinkError;
                    }
                }
            }
            return bl2;
        }

        @Override
        public void loadLibrary(String string, String[] stringArray, boolean bl, ClassLoader classLoader) {
            if (!JNILibLoaderBase.isLoaded(string)) {
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.loadLibrary(stringArray[i], bl, classLoader);
                    }
                }
                this.loadLibrary(string, false, classLoader);
            }
        }
    }
}

