/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public abstract class FlatAbstractIcon
implements Icon,
UIResource {
    protected final int width;
    protected final int height;
    protected Color color;

    public FlatAbstractIcon(int n, int n2, Color color) {
        this.width = n;
        this.height = n2;
        this.color = color;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics);
            ((Graphics2D)graphics).translate(n, n2);
            UIScale.scaleGraphics((Graphics2D)graphics);
            if (this.color != null) {
                graphics.setColor(this.color);
            }
            this.paintIcon(component, (Graphics2D)graphics);
            return;
        }
        finally {
            graphics.dispose();
        }
    }

    protected abstract void paintIcon(Component var1, Graphics2D var2);

    @Override
    public int getIconWidth() {
        return UIScale.scale(this.width);
    }

    @Override
    public int getIconHeight() {
        return UIScale.scale(this.height);
    }
}

