/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.NativeLibrary;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.security.CodeSource;

class FlatNativeLibrary {
    private static boolean initialized;
    private static NativeLibrary nativeLibrary;

    FlatNativeLibrary() {
    }

    private static native int getApiVersion();

    static synchronized boolean isLoaded(int n) {
        FlatNativeLibrary.initialize(n);
        if (nativeLibrary != null) {
            return nativeLibrary.isLoaded();
        }
        return false;
    }

    private static void initialize(int n) {
        String string;
        Object object;
        if (initialized) {
            return;
        }
        initialized = true;
        if (!FlatSystemProperties.getBoolean("flatlaf.useNativeLibrary", true)) {
            return;
        }
        if (SystemInfo.isWindows_10_orLater && (SystemInfo.isX86 || SystemInfo.isX86_64 || SystemInfo.isAARCH64)) {
            object = SystemInfo.isAARCH64 ? "windows-arm64" : (SystemInfo.isX86_64 ? "windows-x86_64" : "windows-x86");
            string = "dll";
        } else if (SystemInfo.isMacOS_10_14_Mojave_orLater && (SystemInfo.isAARCH64 || SystemInfo.isX86_64)) {
            object = SystemInfo.isAARCH64 ? "macos-arm64" : "macos-x86_64";
            string = "dylib";
        } else if (SystemInfo.isLinux && SystemInfo.isX86_64) {
            object = "linux-x86_64";
            string = "so";
            FlatNativeLibrary.loadJAWT();
        } else {
            return;
        }
        object = FlatNativeLibrary.createNativeLibrary((String)object, string);
        if (!((NativeLibrary)object).isLoaded()) {
            return;
        }
        try {
            int n2 = FlatNativeLibrary.getApiVersion();
            if (n2 != n) {
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Wrong API version in native library (expected " + n + ", actual " + n2 + "). Ignoring native library.", null);
                return;
            }
        }
        catch (Throwable throwable) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to get API version of native library. Ignoring native library.", throwable);
            return;
        }
        nativeLibrary = object;
    }

    private static NativeLibrary createNativeLibrary(String string, String string2) {
        Object object;
        String string3 = "flatlaf-" + string;
        Object object2 = System.getProperty("flatlaf.nativeLibraryPath");
        if (object2 != null) {
            if ("system".equals(object2)) {
                object = new NativeLibrary(string3, true);
                if (((NativeLibrary)object).isLoaded()) {
                    return object;
                }
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Native library '" + System.mapLibraryName(string3) + "' not found in java.library.path '" + System.getProperty("java.library.path") + "'. Using extracted native library instead.", null);
            } else {
                object = new File((String)object2, System.mapLibraryName(string3));
                if (((File)object).exists()) {
                    return new NativeLibrary((File)object, true);
                }
                String string4 = null;
                File file = FlatNativeLibrary.getJarFile();
                if (file != null && ((File)(object2 = new File((String)object2, string4 = FlatNativeLibrary.buildLibraryName(file, string, string2)))).exists()) {
                    return new NativeLibrary((File)object2, true);
                }
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Native library '" + ((File)object).getName() + (string4 != null ? "' or '" + string4 : "") + "' not found in '" + ((File)object).getParentFile().getAbsolutePath() + "'. Using extracted native library instead.", null);
            }
        }
        if ((object = FlatNativeLibrary.findLibraryBesideJar(string, string2)) != null) {
            return new NativeLibrary((File)object, true);
        }
        return new NativeLibrary("com/formdev/flatlaf/natives/" + string3, null, true);
    }

    private static File findLibraryBesideJar(String string, String object) {
        File[] fileArray;
        File file;
        File file2;
        File file3 = FlatNativeLibrary.getJarFile();
        if (file3 == null) {
            return null;
        }
        string = FlatNativeLibrary.buildLibraryName(file3, string, (String)object);
        File file4 = file3.getParentFile();
        File file5 = new File(file4, string);
        if (file5.isFile()) {
            return file5;
        }
        if (file4.getName().equalsIgnoreCase("lib") && (file2 = new File(file4.getParentFile(), "bin/" + string)).isFile()) {
            return file2;
        }
        String string2 = file4.getAbsolutePath().replace('\\', '/');
        if (string2.contains("/.gradle/caches/") && string.contains((file = file4.getParentFile()).getName()) && (fileArray = file.listFiles()) != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file7 = fileArray2[i];
                file7 = new File(file7, string);
                if (!file7.isFile()) continue;
                return file7;
            }
        }
        return null;
    }

    private static File getJarFile() {
        try {
            Serializable serializable = FlatNativeLibrary.class.getProtectionDomain().getCodeSource();
            if ((serializable = serializable != null ? ((CodeSource)serializable).getLocation() : null) == null) {
                return null;
            }
            if (!"file".equals(((URL)serializable).getProtocol())) {
                return null;
            }
            if (!((File)(serializable = new File(((URL)serializable).toURI()))).isFile()) {
                return null;
            }
            return serializable;
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(exception.getMessage(), exception);
            return null;
        }
    }

    private static String buildLibraryName(File object, String string, String string2) {
        object = ((File)object).getName();
        object = ((String)object).substring(0, ((String)object).lastIndexOf(46));
        object = StringUtils.removeTrailing((String)object, "-no-natives");
        return (String)object + (((String)object).contains("flatlaf") ? "" : "-flatlaf") + '-' + string + '.' + string2;
    }

    private static void loadJAWT() {
        try {
            System.loadLibrary("jawt");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            UnsatisfiedLinkError unsatisfiedLinkError2 = unsatisfiedLinkError;
            String string = unsatisfiedLinkError.getMessage();
            if (string == null || !string.contains("already loaded in another classloader")) {
                LoggingFacade.INSTANCE.logSevere(string, unsatisfiedLinkError2);
            }
            return;
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(exception.getMessage(), exception);
            return;
        }
    }
}

