/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class FlatToolBarSeparatorUI
extends BasicToolBarSeparatorUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    private static final int LINE_WIDTH = 1;
    @FlatStylingSupport.Styleable
    protected int separatorWidth;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        if (FlatUIUtils.canUseSharedUI(jComponent)) {
            return FlatUIUtils.createSharedUI(FlatToolBarSeparatorUI.class, () -> new FlatToolBarSeparatorUI(true));
        }
        return new FlatToolBarSeparatorUI(false);
    }

    protected FlatToolBarSeparatorUI(boolean bl) {
        this.shared = bl;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle((JSeparator)jComponent);
    }

    @Override
    protected void installDefaults(JSeparator jSeparator) {
        super.installDefaults(jSeparator);
        if (!this.defaults_initialized) {
            this.separatorWidth = UIManager.getInt("ToolBar.separatorWidth");
            this.separatorColor = UIManager.getColor("ToolBar.separatorColor");
            this.defaults_initialized = true;
        }
        jSeparator.setAlignmentX(0.0f);
    }

    @Override
    protected void uninstallDefaults(JSeparator jSeparator) {
        super.uninstallDefaults(jSeparator);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners(JSeparator jSeparator) {
        super.installListeners(jSeparator);
        jSeparator.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSeparator jSeparator) {
        super.uninstallListeners(jSeparator);
        jSeparator.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent serializable) {
        switch (((PropertyChangeEvent)serializable).getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                serializable = (JSeparator)((EventObject)serializable).getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty((JComponent)serializable)) {
                    ((JSeparator)serializable).updateUI();
                } else {
                    this.installStyle((JSeparator)serializable);
                }
                ((JComponent)serializable).revalidate();
                ((Component)serializable).repaint();
            }
        }
    }

    protected void installStyle(JSeparator jSeparator) {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(jSeparator, "ToolBarSeparator"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = ((JToolBar.Separator)jComponent).getSeparatorSize();
        if (dimension != null) {
            return UIScale.scale(dimension);
        }
        int n = this.separatorWidth;
        FlatToolBarUI flatToolBarUI = this.getToolBarUI(jComponent);
        if (flatToolBarUI != null && flatToolBarUI.separatorWidth != null) {
            n = flatToolBarUI.separatorWidth;
        }
        n = (UIScale.scale((n - 1) / 2) << 1) + UIScale.scale(1);
        boolean bl = this.isVertical(jComponent);
        return new Dimension(bl ? n : 0, bl ? 0 : n);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (this.isVertical(jComponent)) {
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, dimension.height);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        float f = UIScale.scale(1.0f);
        float f2 = UIScale.scale(2.0f);
        Color color = this.separatorColor;
        Object[] objectArray = this.getToolBarUI(jComponent);
        if (objectArray != null && objectArray.separatorColor != null) {
            color = objectArray.separatorColor;
        }
        objectArray = FlatUIUtils.setRenderingHints(graphics);
        graphics.setColor(color);
        if (this.isVertical(jComponent)) {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float(Math.round(((float)n - f) / 2.0f), f2, f, (float)n2 - f2 * 2.0f));
        } else {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float(f2, Math.round(((float)n2 - f) / 2.0f), (float)n - f2 * 2.0f, f));
        }
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    private boolean isVertical(JComponent jComponent) {
        return ((JToolBar.Separator)jComponent).getOrientation() == 1;
    }

    private FlatToolBarUI getToolBarUI(JComponent container) {
        if ((container = container.getParent()) instanceof JToolBar && ((JToolBar)container).getUI() instanceof FlatToolBarUI) {
            return (FlatToolBarUI)((JToolBar)container).getUI();
        }
        return null;
    }
}

