/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateEncoder;
import java.util.List;

class PerMessageDeflateEncoder
extends DeflateEncoder {
    private boolean compressing;

    PerMessageDeflateEncoder(int n, int n2, boolean bl) {
        super(n, n2, bl, WebSocketExtensionFilter.NEVER_SKIP);
    }

    PerMessageDeflateEncoder(int n, int n2, boolean bl, WebSocketExtensionFilter webSocketExtensionFilter) {
        super(n, n2, bl, webSocketExtensionFilter);
    }

    public boolean acceptOutboundMessage(Object object) {
        if (!super.acceptOutboundMessage(object)) {
            return false;
        }
        object = (WebSocketFrame)((Object)object);
        if (this.extensionEncoderFilter().mustSkip((WebSocketFrame)((Object)object))) {
            if (this.compressing) {
                throw new IllegalStateException("Cannot skip per message deflate encoder, compression in progress");
            }
            return false;
        }
        return (object instanceof TextWebSocketFrame || object instanceof BinaryWebSocketFrame) && (((WebSocketFrame)((Object)object)).rsv() & 4) == 0 || object instanceof ContinuationWebSocketFrame && this.compressing;
    }

    @Override
    protected int rsv(WebSocketFrame webSocketFrame) {
        if (webSocketFrame instanceof TextWebSocketFrame || webSocketFrame instanceof BinaryWebSocketFrame) {
            return webSocketFrame.rsv() | 4;
        }
        return webSocketFrame.rsv();
    }

    @Override
    protected boolean removeFrameTail(WebSocketFrame webSocketFrame) {
        return webSocketFrame.isFinalFragment();
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        super.encode(channelHandlerContext, webSocketFrame, list);
        if (webSocketFrame.isFinalFragment()) {
            this.compressing = false;
            return;
        }
        if (webSocketFrame instanceof TextWebSocketFrame || webSocketFrame instanceof BinaryWebSocketFrame) {
            this.compressing = true;
        }
    }
}

