/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.util;

import kotlin.Metadata;
import kotlin.math.MathKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0001\u001a)\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0086\b\u001a)\u0010\f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0086\b\u001a\u001d\u0010\r\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\b\u001a\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\b\u001a\u0015\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\b\u001a\u001d\u0010\r\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0012H\u0086\b\u001a\u0015\u0010\u0010\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0012H\u0086\b\u001a\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0012H\u0086\b\u001a\u001d\u0010\r\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0086\b\u001a\u0015\u0010\u0010\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0086\b\u001a\u0015\u0010\u0011\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0086\b\u001a\u001d\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0086\b\u001a\u0015\u0010\u0010\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0086\b\u001a\u0015\u0010\u0011\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0086\b\u001a\r\u0010\u0013\u001a\u00020\u0014*\u00020\u0001H\u0086\b\u001a\r\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0086\b\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u0011\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0086\b\u001a\u0011\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0086\b\u00a8\u0006\u001a"}, d2={"lerp", "", "start", "stop", "fraction", "", "", "fastMinOf", "a", "b", "c", "d", "fastMaxOf", "fastCoerceIn", "minimumValue", "maximumValue", "fastCoerceAtLeast", "fastCoerceAtMost", "", "fastIsFinite", "", "fastCbrt", "x", "normalizedAngleSin", "normalizedDegrees", "normalizedAngleCos", "ui-util"})
public final class MathHelpersKt {
    public static final float lerp(float f, float f2, float f3) {
        return (1.0f - f3) * f + f3 * f2;
    }

    public static final int lerp(int n, int n2, float f) {
        double d = (double)(n2 - n) * (double)f;
        return n + (int)Math.round(d);
    }

    public static final long lerp(long l, long l2, float f) {
        return l + MathKt.roundToLong((double)((double)(l2 - l) * (double)f));
    }

    public static final float fastMinOf(float f, float f2, float f3, float f4) {
        return Math.min(f, Math.min(f2, Math.min(f3, f4)));
    }

    public static final float fastMaxOf(float f, float f2, float f3, float f4) {
        return Math.max(f, Math.max(f2, Math.max(f3, f4)));
    }

    public static final float fastCoerceIn(float f, float f2, float f3) {
        float f4 = f = f < f2 ? f2 : f;
        if (f4 > f3) {
            return f3;
        }
        return f;
    }

    public static final float fastCoerceAtLeast(float f, float f2) {
        if (f < f2) {
            return f2;
        }
        return f;
    }

    public static final float fastCoerceAtMost(float f, float f2) {
        if (f > f2) {
            return f2;
        }
        return f;
    }

    public static final double fastCoerceIn(double d, double d2, double d3) {
        double d4;
        double d5 = d4 = d < d2 ? d2 : d;
        if (d5 > d3) {
            return d3;
        }
        return d4;
    }

    public static final double fastCoerceAtLeast(double d, double d2) {
        if (d < d2) {
            return d2;
        }
        return d;
    }

    public static final double fastCoerceAtMost(double d, double d2) {
        if (d > d2) {
            return d2;
        }
        return d;
    }

    public static final int fastCoerceIn(int n, int n2, int n3) {
        if ((n = n < n2 ? n2 : n) > n3) {
            return n3;
        }
        return n;
    }

    public static final int fastCoerceAtLeast(int n, int n2) {
        if (n < n2) {
            return n2;
        }
        return n;
    }

    public static final int fastCoerceAtMost(int n, int n2) {
        if (n > n2) {
            return n2;
        }
        return n;
    }

    public static final long fastCoerceIn(long l, long l2, long l3) {
        long l4 = l < l2 ? l2 : l;
        if (l4 > l3) {
            return l3;
        }
        return l4;
    }

    public static final long fastCoerceAtLeast(long l, long l2) {
        if (l < l2) {
            return l2;
        }
        return l;
    }

    public static final long fastCoerceAtMost(long l, long l2) {
        if (l > l2) {
            return l2;
        }
        return l;
    }

    public static final boolean fastIsFinite(float f) {
        return (Float.floatToRawIntBits(f) & Integer.MAX_VALUE) < 2139095040;
    }

    public static final boolean fastIsFinite(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MAX_VALUE) < 0x7FF0000000000000L;
    }

    public static final float fastCbrt(float f) {
        float f2;
        long l = (long)Float.floatToRawIntBits(f) & 0x1FFFFFFFFL;
        int n = 709952852 + (int)(l / 3L);
        float f3 = f2 = Float.intBitsToFloat(n);
        f2 -= (f2 - f / (f3 * f3)) * 0.33333334f;
        float f4 = f2;
        f2 -= (f2 - f / (f4 * f4)) * 0.33333334f;
        return f2;
    }

    public static final float normalizedAngleSin(float f) {
        float f2 = f;
        f = f2 - (float)Math.floor(f2 + 0.5f);
        float f3 = 2.0f * Math.abs(f);
        float f4 = 1.0f - f3;
        return 8.0f * f * f4 / (1.25f - f3 * f4);
    }

    public static final float normalizedAngleCos(float f) {
        f += 0.25f;
        f -= (float)Math.floor(f + 0.5f);
        float f2 = 2.0f * Math.abs(f);
        float f3 = 1.0f - f2;
        return 8.0f * f * f3 / (1.25f - f2 * f3);
    }
}

