/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ChunkedStream
implements ChunkedInput<ByteBuf> {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final PushbackInputStream in;
    private final int chunkSize;
    private long offset;
    private boolean closed;

    public ChunkedStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public ChunkedStream(InputStream inputStream, int n) {
        ObjectUtil.checkNotNull((Object)inputStream, (String)"in");
        ObjectUtil.checkPositive((int)n, (String)"chunkSize");
        this.in = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        this.chunkSize = n;
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        if (this.closed) {
            return true;
        }
        if (this.in.available() > 0) {
            return false;
        }
        int n = this.in.read();
        if (n < 0) {
            return true;
        }
        this.in.unread(n);
        return false;
    }

    @Override
    public void close() {
        this.closed = true;
        this.in.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) {
        boolean bl;
        int n;
        block5: {
            if (this.isEndOfInput()) {
                return null;
            }
            n = this.in.available();
            n = n <= 0 ? this.chunkSize : Math.min(this.chunkSize, this.in.available());
            bl = true;
            byteBufAllocator = byteBufAllocator.buffer(n);
            try {
                n = byteBufAllocator.writeBytes((InputStream)this.in, n);
                if (n >= 0) break block5;
            }
            catch (Throwable throwable) {
                if (bl) {
                    byteBufAllocator.release();
                }
                throw throwable;
            }
            byteBufAllocator.release();
            return null;
        }
        this.offset += (long)n;
        bl = false;
        ByteBufAllocator byteBufAllocator2 = byteBufAllocator;
        return byteBufAllocator2;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

