/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;

final class HttpPostBodyUtil {
    public static final int chunkSize = 8096;
    public static final String DEFAULT_BINARY_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_TEXT_CONTENT_TYPE = "text/plain";

    private HttpPostBodyUtil() {
    }

    static int findNonWhitespace(String string, int n) {
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    static int findEndOfString(String string) {
        int n;
        for (n = string.length(); n > 0 && Character.isWhitespace(string.charAt(n - 1)); --n) {
        }
        return n;
    }

    static int findLineBreak(ByteBuf byteBuf, int n) {
        int n2 = byteBuf.readableBytes() - (n - byteBuf.readerIndex());
        if ((n2 = byteBuf.bytesBefore(n, n2, (byte)10)) == -1) {
            return -1;
        }
        if (n2 > 0 && byteBuf.getByte(n + n2 - 1) == 13) {
            --n2;
        }
        return n2;
    }

    static int findLastLineBreak(ByteBuf byteBuf, int n) {
        int n2;
        int n3 = HttpPostBodyUtil.findLineBreak(byteBuf, n);
        int n4 = 0;
        if (n3 >= 0) {
            n4 = byteBuf.getByte(n + n3) == 13 ? 2 : 1;
            n3 += n4;
        }
        while (n3 > 0 && (n2 = HttpPostBodyUtil.findLineBreak(byteBuf, n + n3)) >= 0) {
            n4 = byteBuf.getByte(n + (n3 += n2)) == 13 ? 2 : 1;
            n3 += n4;
        }
        return n3 - n4;
    }

    static int findDelimiter(ByteBuf byteBuf, int n, byte[] byArray, boolean bl) {
        int n2 = byArray.length;
        int n3 = byteBuf.readerIndex();
        int n4 = byteBuf.writerIndex();
        n4 -= n;
        boolean bl2 = true;
        while (bl2 && n2 <= n4) {
            int n5 = byteBuf.bytesBefore(n, n4, byArray[0]);
            if (n5 < 0) {
                return -1;
            }
            n += n5;
            if ((n4 -= n5) >= n2) {
                bl2 = false;
                for (n5 = 0; n5 < n2; ++n5) {
                    if (byteBuf.getByte(n + n5) == byArray[n5]) continue;
                    ++n;
                    --n4;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) continue;
            if (bl && n > n3) {
                if (byteBuf.getByte(n - 1) == 10) {
                    if (--n > n3 && byteBuf.getByte(n - 1) == 13) {
                        --n;
                    }
                } else {
                    ++n;
                    --n4;
                    bl2 = true;
                    continue;
                }
            }
            return n - n3;
        }
        return -1;
    }

    static class SeekAheadOptimize {
        byte[] bytes;
        int readerIndex;
        int pos;
        int origPos;
        int limit;
        ByteBuf buffer;

        SeekAheadOptimize(ByteBuf byteBuf) {
            if (!byteBuf.hasArray()) {
                throw new IllegalArgumentException("buffer hasn't backing byte array");
            }
            this.buffer = byteBuf;
            this.bytes = byteBuf.array();
            this.readerIndex = byteBuf.readerIndex();
            SeekAheadOptimize seekAheadOptimize = this;
            seekAheadOptimize.origPos = seekAheadOptimize.pos = byteBuf.arrayOffset() + this.readerIndex;
            this.limit = byteBuf.arrayOffset() + byteBuf.writerIndex();
        }

        void setReadPosition(int n) {
            this.pos -= n;
            this.readerIndex = this.getReadPosition(this.pos);
            this.buffer.readerIndex(this.readerIndex);
        }

        int getReadPosition(int n) {
            return n - this.origPos + this.readerIndex;
        }
    }

    public static enum TransferEncodingMechanism {
        BIT7("7bit"),
        BIT8("8bit"),
        BINARY("binary");

        private final String value;

        private TransferEncodingMechanism(String string2) {
            this.value = string2;
        }

        public final String value() {
            return this.value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

