/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostStandardRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private final int maxFields;
    private final int maxBufferedBytes;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private HttpPostRequestDecoder.MultiPartStatus currentStatus = HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;

    public HttpPostStandardRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        this(httpDataFactory, httpRequest, charset, 128, 1024);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset, int n, int n2) {
        this.request = (HttpRequest)ObjectUtil.checkNotNull((Object)httpRequest, (String)"request");
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        this.factory = (HttpDataFactory)ObjectUtil.checkNotNull((Object)httpDataFactory, (String)"factory");
        this.maxFields = n;
        this.maxBufferedBytes = n2;
        try {
            if (!(httpRequest instanceof HttpContent)) {
                this.parseBody();
                return;
            }
            this.offer((HttpContent)((Object)httpRequest));
        }
        catch (Throwable throwable) {
            this.destroy();
            PlatformDependent.throwException((Throwable)throwable);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostStandardRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return false;
    }

    @Override
    public void setDiscardThreshold(int n) {
        this.discardThreshold = ObjectUtil.checkPositiveOrZero((int)n, (String)"discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String object) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        if ((object = this.bodyMapHttpData.get(object)) != null) {
            return (InterfaceHttpData)object.get(0);
        }
        return null;
    }

    @Override
    public HttpPostStandardRequestDecoder offer(HttpContent httpContent) {
        this.checkDestroyed();
        if (httpContent instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        httpContent = httpContent.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = httpContent.alloc().buffer(httpContent.readableBytes()).writeBytes((ByteBuf)httpContent);
        } else {
            this.undecodedChunk.writeBytes((ByteBuf)httpContent);
        }
        this.parseBody();
        if (this.maxBufferedBytes > 0 && this.undecodedChunk != null && this.undecodedChunk.readableBytes() > this.maxBufferedBytes) {
            throw new HttpPostRequestDecoder.TooLongFormFieldException();
        }
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            if (this.undecodedChunk.refCnt() == 1) {
                this.undecodedChunk.discardReadBytes();
            } else {
                httpContent = this.undecodedChunk.alloc().buffer(this.undecodedChunk.readableBytes());
                httpContent.writeBytes(this.undecodedChunk);
                this.undecodedChunk.release();
                this.undecodedChunk = httpContent;
            }
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder.EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyAttributes();
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData == null) {
            return;
        }
        if (this.maxFields > 0 && this.bodyListHttpData.size() >= this.maxFields) {
            throw new HttpPostRequestDecoder.TooManyFormFieldsException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(interfaceHttpData.getName());
        if (list == null) {
            list = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(interfaceHttpData.getName(), list);
        }
        list.add(interfaceHttpData);
        this.bodyListHttpData.add(interfaceHttpData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyAttributesStandard() {
        int n;
        int n2 = n = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED) {
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.DISPOSITION;
        }
        boolean bl = true;
        try {
            block8: while (this.undecodedChunk.isReadable() && bl) {
                int n3 = this.undecodedChunk.readUnsignedByte();
                ++n2;
                switch (this.currentStatus) {
                    case DISPOSITION: {
                        if (n3 == 61) {
                            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FIELD;
                            n3 = n2 - 1;
                            String string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n, n3 - n, this.charset), this.charset);
                            this.currentAttribute = this.factory.createAttribute(this.request, string);
                            n = n2;
                            continue block8;
                        }
                        if (n3 != 38 && (!this.isLastChunk || this.undecodedChunk.isReadable() || !this.hasFormBody())) continue block8;
                        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.DISPOSITION;
                        String string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n, (n3 = n3 == 38 ? n2 - 1 : n2) - n, this.charset), this.charset);
                        if (!string.isEmpty()) {
                            this.currentAttribute = this.factory.createAttribute(this.request, string);
                            this.currentAttribute.setValue("");
                            HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                            httpPostStandardRequestDecoder.addHttpData(httpPostStandardRequestDecoder.currentAttribute);
                        }
                        this.currentAttribute = null;
                        n = n2;
                        bl = true;
                        continue block8;
                    }
                    case FIELD: {
                        if (n3 == 38) {
                            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.DISPOSITION;
                            n3 = n2 - 1;
                            HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                            httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.retainedSlice(n, n3 - n));
                            n = n2;
                            bl = true;
                            continue block8;
                        }
                        if (n3 == 13) {
                            if (this.undecodedChunk.isReadable()) {
                                n3 = (char)this.undecodedChunk.readUnsignedByte();
                                ++n2;
                                if (n3 != 10) {
                                    throw new HttpPostRequestDecoder.ErrorDataDecoderException("Bad end of line");
                                }
                                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE;
                                n3 = n2 - 2;
                                HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                                httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.retainedSlice(n, n3 - n));
                                n = n2;
                                break;
                            }
                            --n2;
                            continue block8;
                        }
                        if (n3 != 10) continue block8;
                        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE;
                        n3 = n2 - 1;
                        HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                        httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.retainedSlice(n, n3 - n));
                        n = n2;
                        break;
                    }
                }
                bl = false;
            }
            if (this.isLastChunk && this.currentAttribute != null) {
                int n4 = n2;
                if (n4 > n) {
                    HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                    httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.retainedSlice(n, n4 - n));
                } else if (!this.currentAttribute.isCompleted()) {
                    this.setFinalBuffer(Unpooled.EMPTY_BUFFER);
                }
                n = n2;
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            } else if (bl && this.currentAttribute != null && this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.FIELD) {
                this.currentAttribute.addContent(this.undecodedChunk.retainedSlice(n, n2 - n), false);
                n = n2;
            }
            this.undecodedChunk.readerIndex(n);
            return;
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException errorDataDecoderException) {
            this.undecodedChunk.readerIndex(n);
            throw errorDataDecoderException;
        }
        catch (IOException iOException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
        }
    }

    private void parseBodyAttributes() {
        if (this.undecodedChunk == null) {
            return;
        }
        this.parseBodyAttributesStandard();
    }

    private void setFinalBuffer(ByteBuf byteBuf) {
        this.currentAttribute.addContent(byteBuf, true);
        byteBuf = HttpPostStandardRequestDecoder.decodeAttribute(this.currentAttribute.getByteBuf(), this.charset);
        if (byteBuf != null) {
            this.currentAttribute.setContent(byteBuf);
        }
        HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
        httpPostStandardRequestDecoder.addHttpData(httpPostStandardRequestDecoder.currentAttribute);
        this.currentAttribute = null;
    }

    private static String decodeAttribute(String string, Charset charset) {
        try {
            return QueryStringDecoder.decodeComponent(string, charset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HttpPostRequestDecoder.ErrorDataDecoderException("Bad string: '" + string + '\'', illegalArgumentException);
        }
    }

    private static ByteBuf decodeAttribute(ByteBuf byteBuf, Charset charset) {
        int n = byteBuf.forEachByte((ByteProcessor)new UrlEncodedDetector());
        if (n == -1) {
            return null;
        }
        ByteBuf byteBuf2 = byteBuf.alloc().buffer(byteBuf.readableBytes());
        UrlDecoder urlDecoder = new UrlDecoder(byteBuf2);
        int n2 = byteBuf.forEachByte((ByteProcessor)urlDecoder);
        if (urlDecoder.nextEscapedIdx != 0) {
            if (n2 == -1) {
                n2 = byteBuf.readableBytes() - 1;
            }
            byteBuf2.release();
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(String.format("Invalid hex byte at index '%d' in string: '%s'", n2 -= urlDecoder.nextEscapedIdx - 1, byteBuf.toString(charset)));
        }
        return byteBuf2;
    }

    @Override
    public void destroy() {
        this.cleanFiles();
        for (InterfaceHttpData interfaceHttpData : this.bodyListHttpData) {
            if (interfaceHttpData.refCnt() <= 0) continue;
            interfaceHttpData.release();
        }
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, interfaceHttpData);
    }

    private boolean hasFormBody() {
        String string = this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (string == null) {
            return false;
        }
        return HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.contentEquals((CharSequence)string) || HttpHeaderValues.MULTIPART_FORM_DATA.contentEquals((CharSequence)string);
    }

    private static final class UrlDecoder
    implements ByteProcessor {
        private final ByteBuf output;
        private int nextEscapedIdx;
        private byte hiByte;

        UrlDecoder(ByteBuf byteBuf) {
            this.output = byteBuf;
        }

        public final boolean process(byte by) {
            if (this.nextEscapedIdx != 0) {
                if (this.nextEscapedIdx == 1) {
                    this.hiByte = by;
                    ++this.nextEscapedIdx;
                } else {
                    int n = StringUtil.decodeHexNibble((char)((char)this.hiByte));
                    by = (byte)StringUtil.decodeHexNibble((char)((char)by));
                    if (n == -1 || by == -1) {
                        ++this.nextEscapedIdx;
                        return false;
                    }
                    this.output.writeByte((n << 4) + by);
                    this.nextEscapedIdx = 0;
                }
            } else if (by == 37) {
                this.nextEscapedIdx = 1;
            } else if (by == 43) {
                this.output.writeByte(32);
            } else {
                this.output.writeByte((int)by);
            }
            return true;
        }
    }

    private static final class UrlEncodedDetector
    implements ByteProcessor {
        private UrlEncodedDetector() {
        }

        public final boolean process(byte by) {
            return by != 37 && by != 43;
        }
    }
}

