/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.AbstractEpollStreamChannel;
import io.netty.channel.epoll.EpollDomainSocketChannelConfig;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.PeerCredentials;
import java.net.SocketAddress;

public final class EpollDomainSocketChannel
extends AbstractEpollStreamChannel
implements DomainSocketChannel {
    private final EpollDomainSocketChannelConfig config = new EpollDomainSocketChannelConfig(this);
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;

    public EpollDomainSocketChannel() {
        super(LinuxSocket.newSocketDomain(), false);
    }

    EpollDomainSocketChannel(Channel channel, FileDescriptor fileDescriptor) {
        this(channel, new LinuxSocket(fileDescriptor.intValue()));
    }

    public EpollDomainSocketChannel(int n) {
        super(n);
    }

    public EpollDomainSocketChannel(Channel channel, LinuxSocket linuxSocket) {
        super(channel, linuxSocket);
        this.local = linuxSocket.localDomainSocketAddress();
        this.remote = linuxSocket.remoteDomainSocketAddress();
    }

    public EpollDomainSocketChannel(int n, boolean bl) {
        super(new LinuxSocket(n), bl);
    }

    @Override
    protected final AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDomainUnsafe();
    }

    protected final DomainSocketAddress localAddress0() {
        return this.local;
    }

    protected final DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    @Override
    protected final void doBind(SocketAddress socketAddress) {
        this.socket.bind(socketAddress);
        this.local = (DomainSocketAddress)socketAddress;
    }

    @Override
    public final EpollDomainSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected final boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (super.doConnect(socketAddress, socketAddress2)) {
            this.local = socketAddress2 != null ? (DomainSocketAddress)socketAddress2 : this.socket.localDomainSocketAddress();
            this.remote = (DomainSocketAddress)socketAddress;
            return true;
        }
        return false;
    }

    public final DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    public final DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    @Override
    protected final int doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object = channelOutboundBuffer.current();
        if (object instanceof FileDescriptor && this.socket.sendFd(((FileDescriptor)object).intValue()) > 0) {
            channelOutboundBuffer.remove();
            return 1;
        }
        return super.doWriteSingle(channelOutboundBuffer);
    }

    @Override
    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof FileDescriptor) {
            return object;
        }
        return super.filterOutboundMessage(object);
    }

    public final PeerCredentials peerCredentials() {
        return this.socket.getPeerCredentials();
    }

    private final class EpollDomainUnsafe
    extends AbstractEpollStreamChannel.EpollStreamUnsafe {
        private EpollDomainUnsafe() {
        }

        @Override
        final void epollInReady() {
            switch (EpollDomainSocketChannel.this.config().getReadMode()) {
                case BYTES: {
                    super.epollInReady();
                    return;
                }
                case FILE_DESCRIPTORS: {
                    this.epollInReadFd();
                    return;
                }
            }
            throw new Error();
        }

        private void epollInReadFd() {
            if (EpollDomainSocketChannel.this.socket.isInputShutdown()) {
                this.clearEpollIn0();
                return;
            }
            EpollDomainSocketChannelConfig epollDomainSocketChannelConfig = EpollDomainSocketChannel.this.config();
            EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
            epollRecvByteAllocatorHandle.edgeTriggered(EpollDomainSocketChannel.this.isFlagSet(Native.EPOLLET));
            ChannelPipeline channelPipeline = EpollDomainSocketChannel.this.pipeline();
            epollRecvByteAllocatorHandle.reset((ChannelConfig)epollDomainSocketChannelConfig);
            this.epollInBefore();
            try {
                block10: while (true) {
                    epollRecvByteAllocatorHandle.lastBytesRead(EpollDomainSocketChannel.this.socket.recvFd());
                    switch (epollRecvByteAllocatorHandle.lastBytesRead()) {
                        case 0: {
                            break block10;
                        }
                        case -1: {
                            EpollDomainUnsafe epollDomainUnsafe = this;
                            epollDomainUnsafe.close(epollDomainUnsafe.voidPromise());
                            return;
                        }
                        default: {
                            epollRecvByteAllocatorHandle.incMessagesRead(1);
                            this.readPending = false;
                            channelPipeline.fireChannelRead((Object)new FileDescriptor(epollRecvByteAllocatorHandle.lastBytesRead()));
                            if (epollRecvByteAllocatorHandle.continueReading()) continue block10;
                        }
                    }
                    break;
                }
                epollRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                return;
            }
            catch (Throwable throwable) {
                epollRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                channelPipeline.fireExceptionCaught(throwable);
                return;
            }
            finally {
                this.epollInFinally((ChannelConfig)epollDomainSocketChannelConfig);
            }
        }
    }
}

