/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;

final class Bzip2MTFAndRLE2StageEncoder {
    private final int[] bwtBlock;
    private final int bwtLength;
    private final boolean[] bwtValuesPresent;
    private final char[] mtfBlock;
    private int mtfLength;
    private final int[] mtfSymbolFrequencies = new int[258];
    private int alphabetSize;

    Bzip2MTFAndRLE2StageEncoder(int[] nArray, int n, boolean[] blArray) {
        this.bwtBlock = nArray;
        this.bwtLength = n;
        this.bwtValuesPresent = blArray;
        this.mtfBlock = new char[n + 1];
    }

    final void encode() {
        int n;
        int n2 = this.bwtLength;
        boolean[] blArray = this.bwtValuesPresent;
        int[] nArray = this.bwtBlock;
        char[] cArray = this.mtfBlock;
        int[] nArray2 = this.mtfSymbolFrequencies;
        byte[] byArray = new byte[256];
        Bzip2MoveToFrontTable bzip2MoveToFrontTable = new Bzip2MoveToFrontTable();
        int n3 = 0;
        for (n = 0; n < byArray.length; ++n) {
            if (!blArray[n]) continue;
            byArray[n] = (byte)n3++;
        }
        n = n3 + 1;
        int n4 = 0;
        n3 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7 = bzip2MoveToFrontTable.valueToFront(byArray[nArray[i] & 0xFF]);
            if (n7 == 0) {
                ++n3;
                continue;
            }
            if (n3 > 0) {
                --n3;
                while (true) {
                    if ((n3 & 1) == 0) {
                        cArray[n4++] = '\u0000';
                        ++n5;
                    } else {
                        cArray[n4++] = '\u0001';
                        ++n6;
                    }
                    if (n3 <= 1) break;
                    n3 = n3 - 2 >>> 1;
                }
                n3 = 0;
            }
            cArray[n4++] = (char)(n7 + 1);
            int n8 = n7 + 1;
            nArray2[n8] = nArray2[n8] + 1;
        }
        if (n3 > 0) {
            --n3;
            while (true) {
                if ((n3 & 1) == 0) {
                    cArray[n4++] = '\u0000';
                    ++n5;
                } else {
                    cArray[n4++] = '\u0001';
                    ++n6;
                }
                if (n3 <= 1) break;
                n3 = n3 - 2 >>> 1;
            }
        }
        cArray[n4] = (char)n;
        int n9 = n;
        nArray2[n9] = nArray2[n9] + 1;
        nArray2[0] = nArray2[0] + n5;
        nArray2[1] = nArray2[1] + n6;
        this.mtfLength = n4 + 1;
        this.alphabetSize = n + 1;
    }

    final char[] mtfBlock() {
        return this.mtfBlock;
    }

    final int mtfLength() {
        return this.mtfLength;
    }

    final int mtfAlphabetSize() {
        return this.alphabetSize;
    }

    final int[] mtfSymbolFrequencies() {
        return this.mtfSymbolFrequencies;
    }
}

