/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.marshalling.ChannelBufferByteInput;
import io.netty.handler.codec.marshalling.LimitingByteInput;
import io.netty.handler.codec.marshalling.UnmarshallerProvider;
import java.util.List;
import org.jboss.marshalling.ByteInput;

public class CompatibleMarshallingDecoder
extends ReplayingDecoder<Void> {
    protected final UnmarshallerProvider provider;
    protected final int maxObjectSize;
    private boolean discardingTooLongFrame;

    public CompatibleMarshallingDecoder(UnmarshallerProvider unmarshallerProvider, int n) {
        this.provider = unmarshallerProvider;
        this.maxObjectSize = n;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf object, List<Object> list) {
        if (this.discardingTooLongFrame) {
            object.skipBytes(this.actualReadableBytes());
            this.checkpoint();
            return;
        }
        channelHandlerContext = this.provider.getUnmarshaller(channelHandlerContext);
        object = new ChannelBufferByteInput((ByteBuf)object);
        if (this.maxObjectSize != Integer.MAX_VALUE) {
            object = new LimitingByteInput((ByteInput)object, this.maxObjectSize);
        }
        try {
            channelHandlerContext.start((ByteInput)object);
            object = channelHandlerContext.readObject();
            channelHandlerContext.finish();
            list.add(object);
            return;
        }
        catch (LimitingByteInput.TooBigObjectException tooBigObjectException) {
            this.discardingTooLongFrame = true;
            throw new TooLongFrameException();
        }
        finally {
            channelHandlerContext.close();
        }
    }

    @Override
    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        switch (byteBuf.readableBytes()) {
            case 0: {
                return;
            }
            case 1: {
                ByteBuf byteBuf2 = byteBuf;
                if (byteBuf2.getByte(byteBuf2.readerIndex()) != 121) break;
                byteBuf.skipBytes(1);
                return;
            }
        }
        this.decode(channelHandlerContext, byteBuf, list);
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof TooLongFrameException) {
            channelHandlerContext.close();
            return;
        }
        super.exceptionCaught(channelHandlerContext, throwable);
    }
}

