/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerMask;
import io.netty.util.internal.InternalThreadLocalMap;
import java.util.Map;

public abstract class ChannelHandlerAdapter
implements ChannelHandler {
    boolean added;

    protected void ensureNotSharable() {
        if (this.isSharable()) {
            throw new IllegalStateException("ChannelHandler " + this.getClass().getName() + " is not allowed to be shared");
        }
    }

    public boolean isSharable() {
        Class<?> clazz = this.getClass();
        Map map = InternalThreadLocalMap.get().handlerSharableCache();
        Boolean bl = (Boolean)map.get(clazz);
        if (bl == null) {
            bl = clazz.isAnnotationPresent(ChannelHandler.Sharable.class);
            map.put(clazz, bl);
        }
        return bl;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
    }

    @Override
    @ChannelHandlerMask.Skip
    @Deprecated
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        channelHandlerContext.fireExceptionCaught(throwable);
    }
}

