/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.internal.InlineClassHelperKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a1\u0010\u0003\u001a\u00020\u0004*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a\u0012\u0010\r\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a!\u0010\r\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a#\u0010\u0015\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014\u001a#\u0010\u0017\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0014\u001a2\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\b\b\u0002\u0010 \u001a\u00020\u001bH\u0000\u001a(\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0011\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0082\b\u001a\u0014\u0010(\u001a\u00020\u000b*\u00020\u001b2\u0006\u0010)\u001a\u00020\u001bH\u0002\u001a\r\u0010*\u001a\u00020\u000b*\u00020\u001bH\u0082\b\u001a(\u0010+\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`,0\u00052\u0006\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0002\u0010/\u001a,\u00100\u001a\u00020\u000b*\f\u0012\u0004\u0012\u00020\u001b0\u0005j\u0002`12\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0001H\u0082\n\u00a2\u0006\u0002\u00104\u001a4\u0010\u0003\u001a\u00020\u0004*\f\u0012\u0004\u0012\u00020\u001b0\u0005j\u0002`12\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u000bH\u0082\n\u00a2\u0006\u0002\u00106\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"$\u00107\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\"$\u0010>\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b?\u00109\u001a\u0004\b@\u0010;\"\u0004\bA\u0010=*\f\b\u0002\u0010'\"\u00020\u001b2\u00020\u001b*\u0018\b\u0002\u0010+\"\b\u0012\u0004\u0012\u00020\u001b0\u00052\b\u0012\u0004\u0012\u00020\u001b0\u0005\u00a8\u0006B"}, d2={"AssumePointerMoveStoppedMilliseconds", "", "HorizonMilliseconds", "set", "", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "index", "time", "", "dataPoint", "", "([Landroidx/compose/ui/input/pointer/util/DataPointAtTime;IJF)V", "addPointerInputChange", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "offset", "Landroidx/compose/ui/geometry/Offset;", "addPointerInputChange-0AR0LA0", "(Landroidx/compose/ui/input/pointer/util/VelocityTracker;Landroidx/compose/ui/input/pointer/PointerInputChange;J)V", "addPointerInputChangeLegacy", "addPointerInputChangeLegacy-0AR0LA0", "addPointerInputChangeWithFix", "addPointerInputChangeWithFix-0AR0LA0", "DefaultWeight", "polyFitLeastSquares", "", "x", "y", "sampleCount", "degree", "coefficients", "calculateImpulseVelocity", "dataPoints", "isDataDifferential", "", "kineticEnergyToVelocity", "kineticEnergy", "Vector", "dot", "a", "norm", "Matrix", "Landroidx/compose/ui/input/pointer/util/Vector;", "rows", "cols", "(II)[[F", "get", "Landroidx/compose/ui/input/pointer/util/Matrix;", "row", "col", "([[FII)F", "value", "([[FIIF)V", "VelocityTrackerAddPointsFix", "getVelocityTrackerAddPointsFix$annotations", "()V", "getVelocityTrackerAddPointsFix", "()Z", "setVelocityTrackerAddPointsFix", "(Z)V", "VelocityTrackerStrategyUseImpulse", "getVelocityTrackerStrategyUseImpulse$annotations", "getVelocityTrackerStrategyUseImpulse", "setVelocityTrackerStrategyUseImpulse", "ui"})
public final class VelocityTrackerKt {
    private static final int AssumePointerMoveStoppedMilliseconds = 40;
    private static final int HorizonMilliseconds = 100;
    private static final float DefaultWeight = 1.0f;
    private static boolean VelocityTrackerAddPointsFix = true;
    private static boolean VelocityTrackerStrategyUseImpulse;

    private static final void set(DataPointAtTime[] dataPointAtTimeArray, int n, long l2, float f2) {
        DataPointAtTime dataPointAtTime = dataPointAtTimeArray[n];
        if (dataPointAtTime == null) {
            dataPointAtTimeArray[n] = new DataPointAtTime(l2, f2);
            return;
        }
        dataPointAtTime.setTime(l2);
        dataPointAtTime.setDataPoint(f2);
    }

    public static final void addPointerInputChange(VelocityTracker velocityTracker, PointerInputChange pointerInputChange) {
        Intrinsics.checkNotNullParameter((Object)velocityTracker, (String)"");
        Intrinsics.checkNotNullParameter((Object)pointerInputChange, (String)"");
        VelocityTrackerKt.addPointerInputChange-0AR0LA0(velocityTracker, pointerInputChange, Offset.Companion.getZero-F1C5BW0());
    }

    public static final void addPointerInputChange-0AR0LA0(VelocityTracker velocityTracker, PointerInputChange pointerInputChange, long l2) {
        Intrinsics.checkNotNullParameter((Object)velocityTracker, (String)"");
        Intrinsics.checkNotNullParameter((Object)pointerInputChange, (String)"");
        if (VelocityTrackerAddPointsFix) {
            VelocityTrackerKt.addPointerInputChangeWithFix-0AR0LA0(velocityTracker, pointerInputChange, l2);
            return;
        }
        VelocityTrackerKt.addPointerInputChangeLegacy-0AR0LA0(velocityTracker, pointerInputChange, l2);
    }

    private static final void addPointerInputChangeLegacy-0AR0LA0(VelocityTracker velocityTracker, PointerInputChange pointerInputChange, long l2) {
        if (PointerEventKt.changedToDownIgnoreConsumed(pointerInputChange)) {
            velocityTracker.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(pointerInputChange.getPosition-F1C5BW0());
            velocityTracker.resetTracking();
        }
        long l3 = pointerInputChange.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> list = pointerInputChange.getHistorical();
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            HistoricalChange historicalChange = list.get(i);
            HistoricalChange historicalChange2 = historicalChange;
            historicalChange2 = historicalChange;
            long l4 = Offset.minus-MK-Hz9U((long)historicalChange.getPosition-F1C5BW0(), (long)l3);
            l3 = historicalChange2.getPosition-F1C5BW0();
            VelocityTracker velocityTracker2 = velocityTracker;
            velocityTracker2.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U((long)velocityTracker2.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)l4));
            velocityTracker.addPosition-Uv8p0NA(historicalChange2.getUptimeMillis(), Offset.plus-MK-Hz9U((long)velocityTracker.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)l2));
        }
        long l5 = Offset.minus-MK-Hz9U((long)pointerInputChange.getPosition-F1C5BW0(), (long)l3);
        VelocityTracker velocityTracker3 = velocityTracker;
        velocityTracker3.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U((long)velocityTracker3.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)l5));
        velocityTracker.addPosition-Uv8p0NA(pointerInputChange.getUptimeMillis(), Offset.plus-MK-Hz9U((long)velocityTracker.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)l2));
    }

    private static final void addPointerInputChangeWithFix-0AR0LA0(VelocityTracker velocityTracker, PointerInputChange pointerInputChange, long l2) {
        if (PointerEventKt.changedToDownIgnoreConsumed(pointerInputChange)) {
            velocityTracker.resetTracking();
        }
        if (!PointerEventKt.changedToUpIgnoreConsumed(pointerInputChange)) {
            List<HistoricalChange> list = pointerInputChange.getHistorical();
            int n = ((Collection)list).size();
            for (int i = 0; i < n; ++i) {
                HistoricalChange historicalChange = list.get(i);
                velocityTracker.addPosition-Uv8p0NA(historicalChange.getUptimeMillis(), Offset.plus-MK-Hz9U((long)historicalChange.getOriginalEventPosition-F1C5BW0$ui(), (long)l2));
            }
            velocityTracker.addPosition-Uv8p0NA(pointerInputChange.getUptimeMillis(), Offset.plus-MK-Hz9U((long)pointerInputChange.getOriginalEventPosition-F1C5BW0$ui(), (long)l2));
        }
        if (PointerEventKt.changedToUpIgnoreConsumed(pointerInputChange) && pointerInputChange.getUptimeMillis() - velocityTracker.getLastMoveEventTimeStamp$ui() > 40L) {
            velocityTracker.resetTracking();
        }
        velocityTracker.setLastMoveEventTimeStamp$ui(pointerInputChange.getUptimeMillis());
    }

    public static final float[] polyFitLeastSquares(float[] fArray, float[] fArray2, int n, int n2, float[] fArray3) {
        int n3;
        int n4;
        int n5;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray2, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray3, (String)"");
        if (n2 <= 0) {
            InlineClassHelperKt.throwIllegalArgumentException("The degree must be at positive integer");
        }
        if (n == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("At least one point must be provided");
        }
        n2 = n2 >= n ? n - 1 : n2;
        n2 = n2 + 1;
        int n6 = 0;
        float[][] fArrayArray = new float[n2][];
        while (n6 < n2) {
            int n7 = n6++;
            fArrayArray[n7] = new float[n];
        }
        float[][] fArrayArray2 = fArrayArray;
        for (int i = 0; i < n; ++i) {
            float[][] fArrayArray3 = fArrayArray2;
            fArrayArray2[0][i] = 1.0f;
            for (n6 = 1; n6 < n2; ++n6) {
                float f2;
                fArrayArray = fArrayArray2;
                float[][] fArrayArray4 = fArrayArray2;
                n5 = n6 - 1;
                fArrayArray[n6][i] = f2 = fArrayArray4[n5][i] * fArray[i];
            }
        }
        int n8 = 0;
        float[][] fArrayArray5 = new float[n2][];
        while (n8 < n2) {
            n5 = n8++;
            fArrayArray5[n5] = new float[n];
        }
        float[][] fArrayArray6 = fArrayArray5;
        int n9 = 0;
        float[][] fArrayArray7 = new float[n2][];
        while (n9 < n2) {
            int n10 = n9++;
            fArrayArray7[n10] = new float[n2];
        }
        float[][] fArrayArray8 = fArrayArray7;
        for (n8 = 0; n8 < n2; ++n8) {
            float f3;
            float[] fArray4 = fArrayArray6[n8];
            ArraysKt.copyInto((float[])fArrayArray2[n8], (float[])fArray4, (int)0, (int)0, (int)n);
            for (int i = 0; i < n8; ++i) {
                fArray = fArrayArray6[i];
                float f4 = VelocityTrackerKt.dot(fArray4, fArray);
                for (n4 = 0; n4 < n; ++n4) {
                    int n11 = n4;
                    fArray4[n11] = fArray4[n11] - f4 * fArray[n4];
                }
            }
            fArray = fArray4;
            float f5 = (float)Math.sqrt(VelocityTrackerKt.dot(fArray4, fArray));
            float f6 = 1.0f / (f3 < 1.0E-6f ? 1.0E-6f : f5);
            int n12 = 0;
            while (n12 < n) {
                int n13 = n12++;
                fArray4[n13] = fArray4[n13] * f6;
            }
            fArray = fArrayArray8[n8];
            for (n3 = 0; n3 < n2; ++n3) {
                int n14 = n3;
                fArray[n14] = n14 < n8 ? 0.0f : VelocityTrackerKt.dot(fArray4, fArrayArray2[n3]);
            }
        }
        float[] fArray5 = fArray2;
        for (int i = n2 - 1; i >= 0; --i) {
            float f7 = VelocityTrackerKt.dot(fArrayArray6[i], fArray5);
            fArray = fArrayArray8[i];
            n4 = i + 1;
            n3 = n2 - 1;
            if (n4 <= n3) {
                while (true) {
                    f7 -= fArray[n3] * fArray3[n3];
                    if (n3 == n4) break;
                    --n3;
                }
            }
            fArray3[i] = f7 / fArray[i];
        }
        return fArray3;
    }

    public static /* synthetic */ float[] polyFitLeastSquares$default(float[] fArray, float[] fArray2, int n, int n2, float[] fArray3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            fArray3 = new float[RangesKt.coerceAtLeast((int)(n2 + 1), (int)0)];
        }
        return VelocityTrackerKt.polyFitLeastSquares(fArray, fArray2, n, n2, fArray3);
    }

    private static final float calculateImpulseVelocity(float[] fArray, float[] fArray2, int n, boolean bl) {
        float f2 = 0.0f;
        float f3 = fArray2[--n];
        for (int i = n; i > 0; --i) {
            float f4 = f3;
            if (f4 == (f3 = fArray2[i - 1])) continue;
            float f5 = bl ? -fArray[i - 1] : fArray[i] - fArray[i - 1];
            f4 = f5 / (f4 - f3);
            f5 = Math.signum(f2) * (float)Math.sqrt(2.0f * Math.abs(f2));
            f2 += (f4 - f5) * Math.abs(f4);
            if (i != n) continue;
            f2 *= 0.5f;
        }
        return Math.signum(f2) * (float)Math.sqrt(2.0f * Math.abs(f2));
    }

    private static final float kineticEnergyToVelocity(float f2) {
        return Math.signum(f2) * (float)Math.sqrt(2.0f * Math.abs(f2));
    }

    private static final float dot(float[] fArray, float[] fArray2) {
        float f2 = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            f2 += fArray[i] * fArray2[i];
        }
        return f2;
    }

    private static final float norm(float[] fArray) {
        return (float)Math.sqrt(VelocityTrackerKt.dot(fArray, fArray));
    }

    private static final float[][] Matrix(int n, int n2) {
        int n3 = 0;
        float[][] fArrayArray = new float[n][];
        while (n3 < n) {
            int n4 = n3++;
            fArrayArray[n4] = new float[n2];
        }
        return fArrayArray;
    }

    private static final float get(float[][] fArray, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        return fArray[n][n2];
    }

    private static final void set(float[][] fArray, int n, int n2, float f2) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        fArray[n][n2] = f2;
    }

    public static final boolean getVelocityTrackerAddPointsFix() {
        return VelocityTrackerAddPointsFix;
    }

    public static final void setVelocityTrackerAddPointsFix(boolean bl) {
        VelocityTrackerAddPointsFix = bl;
    }

    public static /* synthetic */ void getVelocityTrackerAddPointsFix$annotations() {
    }

    public static final boolean getVelocityTrackerStrategyUseImpulse() {
        return VelocityTrackerStrategyUseImpulse;
    }

    public static final void setVelocityTrackerStrategyUseImpulse(boolean bl) {
        VelocityTrackerStrategyUseImpulse = bl;
    }

    public static /* synthetic */ void getVelocityTrackerStrategyUseImpulse$annotations() {
    }

    public static final /* synthetic */ void access$set(DataPointAtTime[] dataPointAtTimeArray, int n, long l2, float f2) {
        VelocityTrackerKt.set(dataPointAtTimeArray, n, l2, f2);
    }

    public static final /* synthetic */ float access$calculateImpulseVelocity(float[] fArray, float[] fArray2, int n, boolean bl) {
        return VelocityTrackerKt.calculateImpulseVelocity(fArray, fArray2, n, bl);
    }
}

