/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.e.a.h;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqBuilder;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.id.StandardStanzaIdSource;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleReason;

public final class Jingle
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String ACTION_ATTRIBUTE_NAME = "action";
    public static final String INITIATOR_ATTRIBUTE_NAME = "initiator";
    public static final String RESPONDER_ATTRIBUTE_NAME = "responder";
    public static final String SESSION_ID_ATTRIBUTE_NAME = "sid";
    public static final String ELEMENT = "jingle";
    private final String sessionId;
    private final JingleAction action;
    private final h initiator;
    private final h responder;
    private final JingleReason reason;
    private final List<JingleContent> contents;

    private Jingle(Builder builder, String string, JingleAction jingleAction, h h2, h h3, JingleReason jingleReason, List<JingleContent> list) {
        super((AbstractIqBuilder)builder, ELEMENT, NAMESPACE);
        this.sessionId = (String)StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"Jingle session ID must not be null");
        this.action = (JingleAction)((Object)Objects.requireNonNull((Object)((Object)jingleAction), (String)"Jingle action must not be null"));
        this.initiator = h2;
        this.responder = h3;
        this.reason = jingleReason;
        this.contents = list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
        this.setType(IQ.Type.set);
    }

    public final h getInitiator() {
        return this.initiator;
    }

    public final h getResponder() {
        return this.responder;
    }

    public final String getSid() {
        return this.sessionId;
    }

    public final JingleAction getAction() {
        return this.action;
    }

    public final JingleReason getReason() {
        return this.reason;
    }

    public final List<JingleContent> getContents() {
        return this.contents;
    }

    public final JingleContent getSoleContentOrThrow() {
        if (this.contents.isEmpty()) {
            return null;
        }
        if (this.contents.size() > 1) {
            throw new IllegalStateException();
        }
        return this.contents.get(0);
    }

    protected final IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        iQChildElementXmlStringBuilder.optAttribute(INITIATOR_ATTRIBUTE_NAME, (CharSequence)this.getInitiator());
        iQChildElementXmlStringBuilder.optAttribute(RESPONDER_ATTRIBUTE_NAME, (CharSequence)this.getResponder());
        iQChildElementXmlStringBuilder.optAttribute(ACTION_ATTRIBUTE_NAME, (Enum)this.getAction());
        iQChildElementXmlStringBuilder.optAttribute(SESSION_ID_ATTRIBUTE_NAME, this.getSid());
        iQChildElementXmlStringBuilder.rightAngleBracket();
        iQChildElementXmlStringBuilder.optElement((Element)this.reason);
        iQChildElementXmlStringBuilder.append(this.contents);
        return iQChildElementXmlStringBuilder;
    }

    @Deprecated
    public static Builder getBuilder() {
        return Jingle.builder(StandardStanzaIdSource.DEFAULT.getNewStanzaId());
    }

    public static Builder builder(XMPPConnection xMPPConnection) {
        return new Builder(xMPPConnection);
    }

    public static Builder builder(IqData iqData) {
        return new Builder(iqData);
    }

    public static Builder builder(String string) {
        return new Builder(string);
    }

    public static final class Builder
    extends IqBuilder<Builder, Jingle> {
        private String sid;
        private JingleAction action;
        private h initiator;
        private h responder;
        private JingleReason reason;
        private List<JingleContent> contents;

        Builder(IqData iqData) {
            super((AbstractIqBuilder)iqData);
        }

        Builder(XMPPConnection xMPPConnection) {
            super(xMPPConnection);
        }

        Builder(String string) {
            super(string);
        }

        public final Builder setSessionId(String string) {
            StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"Session ID must not be null nor empty");
            this.sid = string;
            return this;
        }

        public final Builder setAction(JingleAction jingleAction) {
            this.action = jingleAction;
            return this;
        }

        public final Builder setInitiator(h h2) {
            this.initiator = h2;
            return this;
        }

        public final Builder setResponder(h h2) {
            this.responder = h2;
            return this;
        }

        public final Builder addJingleContent(JingleContent jingleContent) {
            if (this.contents == null) {
                this.contents = new ArrayList<JingleContent>(1);
            }
            this.contents.add(jingleContent);
            return this;
        }

        public final Builder setReason(JingleReason.Reason reason) {
            this.reason = new JingleReason(reason);
            return this;
        }

        public final Builder setReason(JingleReason jingleReason) {
            this.reason = jingleReason;
            return this;
        }

        public final Jingle build() {
            Builder builder = this;
            return new Jingle(builder, builder.sid, this.action, this.initiator, this.responder, this.reason, this.contents);
        }

        public final Builder getThis() {
            return this;
        }
    }
}

