/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;

public class PrivacyProvider
extends IQProvider<Privacy> {
    public Privacy parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        Privacy privacy = new Privacy();
        boolean bl = false;
        while (!bl) {
            Object object = xmlPullParser.next();
            if (object == XmlPullParser.Event.START_ELEMENT) {
                if (xmlPullParser.getName().equals("active")) {
                    object = xmlPullParser.getAttributeValue("", "name");
                    if (object == null) {
                        privacy.setDeclineActiveList(true);
                        continue;
                    }
                    privacy.setActiveName((String)object);
                    continue;
                }
                if (xmlPullParser.getName().equals("default")) {
                    object = xmlPullParser.getAttributeValue("", "name");
                    if (object == null) {
                        privacy.setDeclineDefaultList(true);
                        continue;
                    }
                    privacy.setDefaultName((String)object);
                    continue;
                }
                if (!xmlPullParser.getName().equals("list")) continue;
                PrivacyProvider.parseList(xmlPullParser, privacy);
                continue;
            }
            if (object != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        return privacy;
    }

    private static void parseList(XmlPullParser xmlPullParser, Privacy privacy) {
        boolean bl = false;
        String string = xmlPullParser.getAttributeValue("", "name");
        ArrayList<PrivacyItem> arrayList = new ArrayList<PrivacyItem>();
        while (!bl) {
            XmlPullParser.Event event = xmlPullParser.next();
            if (event == XmlPullParser.Event.START_ELEMENT) {
                if (!xmlPullParser.getName().equals("item")) continue;
                arrayList.add(PrivacyProvider.parseItem(xmlPullParser));
                continue;
            }
            if (event != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals("list")) continue;
            bl = true;
        }
        privacy.setPrivacyList(string, arrayList);
    }

    private static PrivacyItem parseItem(XmlPullParser xmlPullParser) {
        Object object;
        boolean bl;
        String string = xmlPullParser.getAttributeValue("", "action");
        UInt32 uInt32 = ParserUtils.getUInt32Attribute((XmlPullParser)xmlPullParser, (String)"order");
        String string2 = xmlPullParser.getAttributeValue("", "type");
        switch (string) {
            case "allow": {
                bl = true;
                break;
            }
            case "deny": {
                bl = false;
                break;
            }
            default: {
                throw new IOException("Unknown action value '" + string + "'");
            }
        }
        if (string2 != null) {
            String string3 = xmlPullParser.getAttributeValue("", "value");
            object = new PrivacyItem(PrivacyItem.Type.valueOf(string2), string3, bl, uInt32);
        } else {
            object = new PrivacyItem(bl, uInt32);
        }
        PrivacyProvider.parseItemChildElements(xmlPullParser, (PrivacyItem)object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseItemChildElements(XmlPullParser xmlPullParser, PrivacyItem privacyItem) {
        int n = xmlPullParser.getDepth();
        block16: while (true) {
            Object object = xmlPullParser.next();
            block0 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "iq": {
                            privacyItem.setFilterIQ(true);
                            break block0;
                        }
                        case "message": {
                            privacyItem.setFilterMessage(true);
                            break block0;
                        }
                        case "presence-in": {
                            privacyItem.setFilterPresenceIn(true);
                            break block0;
                        }
                        case "presence-out": {
                            privacyItem.setFilterPresenceOut(true);
                        }
                    }
                    continue block16;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block16;
                }
            }
        }
    }
}

