/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.MaxCapacityQueue;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayDeque;
import java.util.Queue;

@Deprecated
public class Http2MultiplexCodec
extends Http2FrameCodec {
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<AbstractHttp2StreamChannel> readCompletePendingQueue = new MaxCapacityQueue<AbstractHttp2StreamChannel>(new ArrayDeque(8), 100);
    private boolean parentReadInProgress;
    private int idCount;
    volatile ChannelHandlerContext ctx;

    Http2MultiplexCodec(Http2ConnectionEncoder http2ConnectionEncoder, Http2ConnectionDecoder http2ConnectionDecoder, Http2Settings http2Settings, ChannelHandler channelHandler, ChannelHandler channelHandler2, boolean bl, boolean bl2) {
        super(http2ConnectionEncoder, http2ConnectionDecoder, http2Settings, bl, bl2);
        this.inboundStreamHandler = channelHandler;
        this.upgradeStreamHandler = channelHandler2;
    }

    @Override
    public void onHttpClientUpgrade() {
        if (this.upgradeStreamHandler == null) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
        }
        super.onHttpClientUpgrade();
    }

    @Override
    public final void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.executor() != channelHandlerContext.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = channelHandlerContext;
    }

    @Override
    public final void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved0(channelHandlerContext);
        this.readCompletePendingQueue.clear();
    }

    @Override
    final void onHttp2Frame(ChannelHandlerContext object, Http2Frame object2) {
        if (object2 instanceof Http2StreamFrame) {
            object = (Http2StreamFrame)object2;
            object2 = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object.stream()).attachment;
            ((AbstractHttp2StreamChannel)object2).fireChildRead((Http2Frame)object);
            return;
        }
        if (object2 instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame((ChannelHandlerContext)object, (Http2GoAwayFrame)object2);
        }
        object.fireChannelRead(object2);
    }

    @Override
    final void onHttp2StreamStateChanged(ChannelHandlerContext object, Http2FrameCodec.DefaultHttp2FrameStream object2) {
        switch (((Http2FrameCodec.DefaultHttp2FrameStream)object2).state()) {
            case HALF_CLOSED_LOCAL: {
                if (((Http2FrameCodec.DefaultHttp2FrameStream)object2).id() != 1) break;
            }
            case HALF_CLOSED_REMOTE: 
            case OPEN: {
                if (((Http2FrameCodec.DefaultHttp2FrameStream)object2).attachment != null) break;
                if (((Http2FrameCodec.DefaultHttp2FrameStream)object2).id() == 1 && !this.connection().isServer()) {
                    assert (this.upgradeStreamHandler != null);
                    object2 = new Http2MultiplexCodecStreamChannel((Http2FrameCodec.DefaultHttp2FrameStream)object2, this.upgradeStreamHandler);
                    ((AbstractHttp2StreamChannel)object2).closeOutbound();
                } else {
                    object2 = new Http2MultiplexCodecStreamChannel((Http2FrameCodec.DefaultHttp2FrameStream)object2, this.inboundStreamHandler);
                }
                object = object.channel().eventLoop().register((Channel)object2);
                if (object.isDone()) {
                    Http2MultiplexHandler.registerDone((ChannelFuture)object);
                    return;
                }
                object.addListener((GenericFutureListener)Http2MultiplexHandler.CHILD_CHANNEL_REGISTRATION_LISTENER);
                return;
            }
            case CLOSED: {
                object = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object2).attachment;
                if (object == null) break;
                ((AbstractHttp2StreamChannel)object).streamClosed();
            }
        }
    }

    final Http2StreamChannel newOutboundStream() {
        Http2MultiplexCodec http2MultiplexCodec = this;
        return http2MultiplexCodec.new Http2MultiplexCodecStreamChannel(http2MultiplexCodec.newStream(), null);
    }

    @Override
    final void onHttp2FrameStreamException(ChannelHandlerContext object, Http2FrameStreamException http2FrameStreamException) {
        object = http2FrameStreamException.stream();
        object = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object).attachment;
        try {
            ((AbstractHttp2StreamChannel)object).pipeline().fireExceptionCaught(http2FrameStreamException.getCause());
            return;
        }
        finally {
            ((AbstractHttp2StreamChannel)object).closeWithError(http2FrameStreamException.error());
        }
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext channelHandlerContext, final Http2GoAwayFrame http2GoAwayFrame) {
        if (http2GoAwayFrame.lastStreamId() == Integer.MAX_VALUE) {
            return;
        }
        try {
            this.forEachActiveStream(new Http2FrameStreamVisitor(){

                @Override
                public boolean visit(Http2FrameStream object) {
                    int n = object.id();
                    object = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object).attachment;
                    if (n > http2GoAwayFrame.lastStreamId() && Http2MultiplexCodec.this.connection().local().isValidStreamId(n)) {
                        ((AbstractHttp2StreamChannel)object).pipeline().fireUserEventTriggered((Object)http2GoAwayFrame.retainedDuplicate());
                    }
                    return true;
                }
            });
            return;
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught((Throwable)http2Exception);
            channelHandlerContext.close();
            return;
        }
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.processPendingReadCompleteQueue();
        this.channelReadComplete0(channelHandlerContext);
    }

    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        try {
            AbstractHttp2StreamChannel abstractHttp2StreamChannel;
            while ((abstractHttp2StreamChannel = this.readCompletePendingQueue.poll()) != null) {
                abstractHttp2StreamChannel.fireChildReadComplete();
            }
            this.parentReadInProgress = false;
        }
        catch (Throwable throwable) {
            this.parentReadInProgress = false;
            this.readCompletePendingQueue.clear();
            Http2MultiplexCodec http2MultiplexCodec = this;
            http2MultiplexCodec.flush0(http2MultiplexCodec.ctx);
            throw throwable;
        }
        this.readCompletePendingQueue.clear();
        Http2MultiplexCodec http2MultiplexCodec = this;
        http2MultiplexCodec.flush0(http2MultiplexCodec.ctx);
    }

    public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.parentReadInProgress = true;
        super.channelRead(channelHandlerContext, object);
    }

    @Override
    public final void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.WRITABLE_VISITOR);
        }
        super.channelWritabilityChanged(channelHandlerContext);
    }

    @Override
    final void onUserEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object == ChannelInputShutdownReadComplete.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_INPUT_SHUTDOWN_READ_COMPLETE_VISITOR);
        } else if (object == ChannelOutputShutdownEvent.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_OUTPUT_SHUTDOWN_EVENT_VISITOR);
        } else if (object == SslCloseCompletionEvent.SUCCESS) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.SSL_CLOSE_COMPLETION_EVENT_VISITOR);
        }
        super.onUserEventTriggered(channelHandlerContext, object);
    }

    final void flush0(ChannelHandlerContext channelHandlerContext) {
        this.flush(channelHandlerContext);
    }

    private final class Http2MultiplexCodecStreamChannel
    extends AbstractHttp2StreamChannel {
        Http2MultiplexCodecStreamChannel(Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream, ChannelHandler channelHandler) {
            super(defaultHttp2FrameStream, ++Http2MultiplexCodec.this.idCount, channelHandler);
        }

        @Override
        protected final boolean isParentReadInProgress() {
            return Http2MultiplexCodec.this.parentReadInProgress;
        }

        @Override
        protected final void addChannelToReadCompletePendingQueue() {
            while (!Http2MultiplexCodec.this.readCompletePendingQueue.offer(this)) {
                Http2MultiplexCodec.this.processPendingReadCompleteQueue();
            }
        }

        @Override
        protected final ChannelHandlerContext parentContext() {
            return Http2MultiplexCodec.this.ctx;
        }

        @Override
        protected final ChannelFuture write0(ChannelHandlerContext channelHandlerContext, Object object) {
            ChannelPromise channelPromise = channelHandlerContext.newPromise();
            ((Http2ConnectionHandler)Http2MultiplexCodec.this).write(channelHandlerContext, object, channelPromise);
            return channelPromise;
        }

        @Override
        protected final void flush0(ChannelHandlerContext channelHandlerContext) {
            Http2MultiplexCodec.this.flush0(channelHandlerContext);
        }
    }
}

