/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.datatypes;

import org.jivesoftware.smack.datatypes.Scalar;
import org.jivesoftware.smack.util.NumberUtil;

public final class UInt16
extends Scalar
implements Comparable<UInt16> {
    private static final long serialVersionUID = 1L;
    private final int number;
    public static final int MIN_VALUE_INT = 0;
    public static final int MAX_VALUE_INT = 65535;
    public static final UInt16 MIN_VALUE = UInt16.from(0);
    public static final UInt16 MAX_VALUE = UInt16.from(65535);

    private UInt16(int n) {
        super(NumberUtil.requireUShort16(n));
        this.number = n;
    }

    public final int nativeRepresentation() {
        return this.number;
    }

    public static UInt16 from(int n) {
        return new UInt16(n);
    }

    @Override
    public final int hashCode() {
        return this.number;
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof UInt16) {
            object = (UInt16)object;
            return this.number == ((UInt16)object).number;
        }
        return super.equals(object);
    }

    @Override
    public final int compareTo(UInt16 uInt16) {
        return Integer.compare(this.number, uInt16.number);
    }

    @Override
    public final UInt16 getMinValue() {
        return MIN_VALUE;
    }

    @Override
    public final UInt16 getMaxValue() {
        return MAX_VALUE;
    }

    @Override
    public final UInt16 incrementedByOne() {
        int n = this.number < 65535 ? this.number + 1 : 0;
        return UInt16.from(n);
    }
}

