/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;

public final class ReflectionDebuggerFactory
implements SmackDebuggerFactory {
    private static final Logger LOGGER = Logger.getLogger(ReflectionDebuggerFactory.class.getName());
    private static final String DEBUGGER_CLASS_PROPERTY_NAME = "smack.debuggerClass";
    public static final ReflectionDebuggerFactory INSTANCE = new ReflectionDebuggerFactory();
    private static final String[] DEFAULT_DEBUGGERS = new String[]{"org.jivesoftware.smackx.debugger.EnhancedDebugger", "org.jivesoftware.smackx.debugger.android.AndroidDebugger", "org.jivesoftware.smack.debugger.ConsoleDebugger", "org.jivesoftware.smack.debugger.LiteDebugger", "org.jivesoftware.smack.debugger.JulDebugger"};

    private ReflectionDebuggerFactory() {
    }

    public static void setDebuggerClass(Class<? extends SmackDebugger> clazz) {
        if (clazz == null) {
            System.clearProperty(DEBUGGER_CLASS_PROPERTY_NAME);
            return;
        }
        System.setProperty(DEBUGGER_CLASS_PROPERTY_NAME, clazz.getCanonicalName());
    }

    public static Class<SmackDebugger> getDebuggerClass() {
        String string = ReflectionDebuggerFactory.getCustomDebuggerClassName();
        if (string == null) {
            return ReflectionDebuggerFactory.getOneOfDefaultDebuggerClasses();
        }
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Unable to instantiate debugger class " + string, exception);
            return null;
        }
    }

    @Override
    public final SmackDebugger create(XMPPConnection xMPPConnection) {
        GenericDeclaration genericDeclaration = ReflectionDebuggerFactory.getDebuggerClass();
        if (genericDeclaration != null) {
            try {
                genericDeclaration = genericDeclaration.getConstructor(XMPPConnection.class);
                return ((Constructor)genericDeclaration).newInstance(xMPPConnection);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Can't initialize the configured debugger!", exception);
            }
        }
        return null;
    }

    private static String getCustomDebuggerClassName() {
        try {
            return System.getProperty(DEBUGGER_CLASS_PROPERTY_NAME);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<SmackDebugger> getOneOfDefaultDebuggerClasses() {
        String[] stringArray = DEFAULT_DEBUGGERS;
        int n = DEFAULT_DEBUGGERS.length;
        for (int k = 0; k < n; ++k) {
            String string = stringArray[k];
            if (SmackConfiguration.isDisabledSmackClass(string)) continue;
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.fine("Did not find debugger class '" + string + "'");
                continue;
            }
            catch (ClassCastException classCastException) {
                LOGGER.warning("Found debugger class that does not appears to implement SmackDebugger interface");
                continue;
            }
            catch (Exception exception) {
                LOGGER.warning("Unable to instantiate either Smack debugger class");
            }
        }
        return null;
    }
}

