/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.text.Normalizer;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import org.e.a.b;
import org.e.a.e;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;

public abstract class SASLMechanism
implements Comparable<SASLMechanism> {
    public static final String CRAMMD5 = "CRAM-MD5";
    public static final String DIGESTMD5 = "DIGEST-MD5";
    public static final String EXTERNAL = "EXTERNAL";
    public static final String GSSAPI = "GSSAPI";
    public static final String PLAIN = "PLAIN";
    private boolean authenticationSuccessful;
    private Exception exception;
    protected XMPPConnection connection;
    protected ConnectionConfiguration connectionConfiguration;
    protected String authenticationId;
    protected e authorizationId;
    protected b serviceName;
    protected String password;
    protected String host;
    protected SSLSession sslSession;

    public final void authenticate(String string, String string2, b b2, String string3, e e2, SSLSession sSLSession) {
        this.authenticationId = string;
        this.host = string2;
        this.serviceName = b2;
        this.password = string3;
        this.authorizationId = e2;
        this.sslSession = sSLSession;
        assert (this.authorizationId == null || this.authzidSupported());
        this.authenticateInternal();
        this.authenticate();
    }

    protected void authenticateInternal() {
    }

    public void authenticate(String string, b b2, CallbackHandler callbackHandler, e e2, SSLSession sSLSession) {
        this.host = string;
        this.serviceName = b2;
        this.authorizationId = e2;
        this.sslSession = sSLSession;
        assert (this.authorizationId == null || this.authzidSupported());
        this.authenticateInternal(callbackHandler);
        this.authenticate();
    }

    protected abstract void authenticateInternal(CallbackHandler var1);

    private void authenticate() {
        Object object = this.getAuthenticationText();
        object = object != null && ((byte[])object).length > 0 ? (Object)Base64.encodeToString(object) : (Object)"=";
        this.connection.sendNonza(new SaslNonza.AuthMechanism(this.getName(), (String)object));
    }

    protected abstract byte[] getAuthenticationText();

    public final void challengeReceived(String object, boolean bl) {
        object = Base64.decode((String)(object != null && ((String)object).equals("=") ? "" : object));
        object = this.evaluateChallenge((byte[])object);
        if (bl) {
            return;
        }
        object = object == null ? new SaslNonza.Response() : new SaslNonza.Response(Base64.encodeToString((byte[])object));
        this.connection.sendNonza((Nonza)object);
    }

    protected byte[] evaluateChallenge(byte[] byArray) {
        return null;
    }

    @Override
    public final int compareTo(SASLMechanism sASLMechanism) {
        Integer n = this.getPriority();
        return Integer.compare(n, sASLMechanism.getPriority());
    }

    public abstract String getName();

    public abstract int getPriority();

    public final void afterFinalSaslChallenge() {
        this.checkIfSuccessfulOrThrow();
        this.authenticationSuccessful = true;
    }

    protected abstract void checkIfSuccessfulOrThrow();

    public SASLMechanism instanceForAuthentication(XMPPConnection xMPPConnection, ConnectionConfiguration connectionConfiguration) {
        SASLMechanism sASLMechanism = this.newInstance();
        this.newInstance().connection = xMPPConnection;
        sASLMechanism.connectionConfiguration = connectionConfiguration;
        return sASLMechanism;
    }

    public boolean authzidSupported() {
        return false;
    }

    public boolean requiresPassword() {
        return true;
    }

    public boolean isAuthenticationSuccessful() {
        return this.authenticationSuccessful;
    }

    public boolean isFinished() {
        return this.isAuthenticationSuccessful() || this.exception != null;
    }

    public void throwExceptionIfRequired() {
        if (this.exception != null) {
            if (this.exception instanceof SmackException.SmackSaslException) {
                throw (SmackException.SmackSaslException)this.exception;
            }
            if (this.exception instanceof SASLErrorException) {
                throw (SASLErrorException)this.exception;
            }
            if (this.exception instanceof SmackException.NotConnectedException) {
                throw (SmackException.NotConnectedException)this.exception;
            }
            if (this.exception instanceof InterruptedException) {
                throw (InterruptedException)this.exception;
            }
            throw new IllegalStateException("Unexpected exception type", this.exception);
        }
        if (!this.authenticationSuccessful) {
            throw SmackException.NoResponseException.newWith(this.connection, "successful SASL authentication");
        }
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    protected abstract SASLMechanism newInstance();

    protected static byte[] toBytes(String string) {
        return StringUtils.toUtf8Bytes(string);
    }

    protected static String saslPrep(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFKC);
    }

    public final String toString() {
        return "SASL Mech: " + this.getName() + ", Prio: " + this.getPriority();
    }
}

