/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.e.c.a.c;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.MultiMap;

public class XmppElementUtil {
    private static final c<Class<? extends FullyQualifiedElement>, QName> CLASS_TO_QNAME_CACHE = new c(512);
    public static final Logger LOGGER = Logger.getLogger(XmppElementUtil.class.getName());

    public static QName getQNameFor(Class<? extends FullyQualifiedElement> clazz) {
        String string;
        Object object = (QName)CLASS_TO_QNAME_CACHE.get(clazz);
        if (object != null) {
            return object;
        }
        try {
            object = clazz.getField("QNAME").get(null);
            if (QName.class.isAssignableFrom(object.getClass())) {
                object = (QName)object;
                CLASS_TO_QNAME_CACHE.put(clazz, object);
                return object;
            }
            LOGGER.warning("The QNAME field of " + clazz + " is not of type QNAME.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOGGER.finer("The " + clazz + " has no static QNAME field. Consider adding one.");
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
            throw new IllegalArgumentException(exception);
        }
        try {
            object = (String)clazz.getField("ELEMENT").get(null);
            string = (String)clazz.getField("NAMESPACE").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            throw new IllegalArgumentException("The " + clazz + " has no ELEMENT, NAMESPACE or QNAME member. Consider adding QNAME", exception);
        }
        object = new QName(string, (String)object);
        CLASS_TO_QNAME_CACHE.put(clazz, object);
        return object;
    }

    public static <E extends ExtensionElement> List<E> getElementsFrom(MultiMap<QName, ExtensionElement> iterator, Class<E> clazz) {
        Serializable serializable = XmppElementUtil.getQNameFor(clazz);
        if ((iterator = ((MultiMap)((Object)iterator)).getAll((QName)serializable)).isEmpty()) {
            return Collections.emptyList();
        }
        serializable = new ArrayList(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ExtensionElement extensionElement = (ExtensionElement)iterator.next();
            extensionElement = XmppElementUtil.castOrThrow(extensionElement, clazz);
            serializable.add(extensionElement);
        }
        return serializable;
    }

    public static <E extends ExtensionElement> E castOrThrow(ExtensionElement object, Class<E> clazz) {
        if (!clazz.isInstance(object)) {
            Object object2;
            QName qName = XmppElementUtil.getQNameFor(clazz);
            if (object instanceof StandardExtensionElement) {
                object = "because there is no according extension element provider registered with ProviderManager for " + qName + ". WARNING: This indicates a serious problem with your Smack setup, probably causing Smack not being able to properly initialize itself.";
            } else {
                object2 = ProviderManager.getExtensionProvider(qName);
                object = "because there is an inconsistency with the provider registered with ProviderManager: the active provider for " + qName + " '" + object2.getClass() + "' does not return instances of type " + clazz + ", but instead returns instances of type " + object.getClass() + ".";
            }
            object2 = "Extension element is not of expected class '" + clazz.getName() + "', " + (String)object;
            throw new IllegalStateException((String)object2);
        }
        return (E)((ExtensionElement)clazz.cast(object));
    }
}

