/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import kotlinx.serialization.json.internal.CharArrayPoolBatchSize;
import kotlinx.serialization.json.internal.InternalJsonReader;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\rH\u0016J\u0018\u0010$\u001a\u00020 2\u0006\u0010#\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0014J\u001a\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0013H\u0016J\u0006\u0010,\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\r8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006-"}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "reader", "Lkotlinx/serialization/json/internal/InternalJsonReader;", "buffer", "", "<init>", "(Lkotlinx/serialization/json/internal/InternalJsonReader;[C)V", "getReader", "()Lkotlinx/serialization/json/internal/InternalJsonReader;", "getBuffer", "()[C", "threshold", "", "source", "Lkotlinx/serialization/json/internal/ArrayAsSequence;", "getSource", "()Lkotlinx/serialization/json/internal/ArrayAsSequence;", "canConsumeValue", "", "preload", "", "unprocessedCount", "prefetchOrEof", "position", "consumeNextToken", "", "expected", "", "skipWhitespaces", "ensureHaveChars", "consumeKeyString", "", "indexOf", "char", "startPos", "substring", "endPos", "appendRange", "fromIndex", "toIndex", "peekLeadingMatchingValue", "keyToMatch", "isLenient", "release", "kotlinx-serialization-json"})
public class ReaderJsonLexer
extends AbstractJsonLexer {
    private final InternalJsonReader reader;
    private final char[] buffer;
    protected int threshold;
    private final ArrayAsSequence source;

    public ReaderJsonLexer(InternalJsonReader internalJsonReader, char[] cArray) {
        Intrinsics.checkNotNullParameter((Object)internalJsonReader, (String)"");
        Intrinsics.checkNotNullParameter((Object)cArray, (String)"");
        this.reader = internalJsonReader;
        this.buffer = cArray;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this.buffer);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(InternalJsonReader internalJsonReader, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cArray = CharArrayPoolBatchSize.INSTANCE.take();
        }
        this(internalJsonReader, cArray);
    }

    public final InternalJsonReader getReader() {
        return this.reader;
    }

    public final char[] getBuffer() {
        return this.buffer;
    }

    @Override
    protected ArrayAsSequence getSource() {
        return this.source;
    }

    @Override
    public boolean canConsumeValue() {
        ((AbstractJsonLexer)this).ensureHaveChars();
        int n = this.currentPosition;
        while ((n = ((AbstractJsonLexer)this).prefetchOrEof(n)) != -1) {
            char c = this.getSource().charAt(n);
            char c2 = c;
            if (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t') {
                ++n;
                continue;
            }
            this.currentPosition = n;
            return this.isValidValueStart(c);
        }
        this.currentPosition = n;
        return false;
    }

    private final void preload(int n) {
        char[] cArray = this.getSource().getBuffer$kotlinx_serialization_json();
        if (n != 0) {
            ArraysKt.copyInto((char[])cArray, (char[])cArray, (int)0, (int)this.currentPosition, (int)(this.currentPosition + n));
        }
        int n2 = this.getSource().length();
        while (n != n2) {
            int n3 = this.reader.read(cArray, n, n2 - n);
            if (n3 == -1) {
                this.getSource().trim(n);
                this.threshold = -1;
                break;
            }
            n += n3;
        }
        this.currentPosition = 0;
    }

    @Override
    public int prefetchOrEof(int n) {
        if (n < this.getSource().length()) {
            return n;
        }
        this.currentPosition = n;
        ((AbstractJsonLexer)this).ensureHaveChars();
        if (this.currentPosition != 0 || ((CharSequence)this.getSource()).length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte consumeNextToken() {
        ((AbstractJsonLexer)this).ensureHaveChars();
        ArrayAsSequence arrayAsSequence = this.getSource();
        int n = this.currentPosition;
        while ((n = ((AbstractJsonLexer)this).prefetchOrEof(n)) != -1) {
            byte by = arrayAsSequence.charAt(n++);
            byte by2 = AbstractJsonLexerKt.charToTokenClass((char)by);
            by = by2;
            if (by2 == 3) continue;
            this.currentPosition = n;
            return by;
        }
        this.currentPosition = n;
        return 10;
    }

    @Override
    public void consumeNextToken(char c) {
        ((AbstractJsonLexer)this).ensureHaveChars();
        ArrayAsSequence arrayAsSequence = this.getSource();
        int n = this.currentPosition;
        while ((n = ((AbstractJsonLexer)this).prefetchOrEof(n)) != -1) {
            char c2 = arrayAsSequence.charAt(n++);
            char c3 = c2;
            if (c3 == ' ' || c3 == '\n' || c3 == '\r' || c3 == '\t') continue;
            this.currentPosition = n;
            if (c2 == c) {
                return;
            }
            this.unexpectedToken(c);
        }
        this.currentPosition = n;
        this.unexpectedToken(c);
    }

    @Override
    public int skipWhitespaces() {
        int n = this.currentPosition;
        while ((n = ((AbstractJsonLexer)this).prefetchOrEof(n)) != -1) {
            char c = this.getSource().charAt(n);
            if (!(c == ' ' || c == '\n' || c == '\r' || c == '\t')) break;
            ++n;
        }
        this.currentPosition = n;
        return n;
    }

    @Override
    public void ensureHaveChars() {
        int n = this.currentPosition;
        int n2 = this.getSource().length();
        n = n2 - n;
        if (n > this.threshold) {
            return;
        }
        this.preload(n);
    }

    @Override
    public String consumeKeyString() {
        ((AbstractJsonLexer)this).consumeNextToken('\"');
        int n = this.currentPosition;
        int n2 = ((AbstractJsonLexer)this).indexOf('\"', n);
        if (n2 == -1) {
            if ((n = ((AbstractJsonLexer)this).prefetchOrEof(n)) == -1) {
                String string = AbstractJsonLexerKt.tokenDescription((byte)1);
                n2 = ((AbstractJsonLexer)this).currentPosition - 1;
                String string2 = ((AbstractJsonLexer)this).currentPosition == AbstractJsonLexer.access$getSource(this).length() || n2 < 0 ? "EOF" : String.valueOf(AbstractJsonLexer.access$getSource(this).charAt(n2));
                String string3 = string;
                string = string2;
                string2 = string3;
                AbstractJsonLexer abstractJsonLexer = this;
                AbstractJsonLexer.fail$default(abstractJsonLexer, "Expected " + string2 + ", but had '" + string + "' instead", n2, null, 4, null);
                throw new KotlinNothingValueException();
            }
            ReaderJsonLexer readerJsonLexer = this;
            return readerJsonLexer.consumeString(readerJsonLexer.getSource(), this.currentPosition, n);
        }
        for (int i = n; i < n2; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            ReaderJsonLexer readerJsonLexer = this;
            return readerJsonLexer.consumeString(readerJsonLexer.getSource(), this.currentPosition, i);
        }
        this.currentPosition = n2 + 1;
        return ((AbstractJsonLexer)this).substring(n, n2);
    }

    @Override
    public int indexOf(char c, int n) {
        ArrayAsSequence arrayAsSequence = this.getSource();
        int n2 = arrayAsSequence.length();
        while (n < n2) {
            if (arrayAsSequence.charAt(n) == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public String substring(int n, int n2) {
        return this.getSource().substring(n, n2);
    }

    @Override
    protected void appendRange(int n, int n2) {
        StringBuilder stringBuilder = this.getEscapedString();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(this.getSource().getBuffer$kotlinx_serialization_json(), n, n2 - n), (String)"");
    }

    @Override
    public String peekLeadingMatchingValue(String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return null;
    }

    public final void release() {
        CharArrayPoolBatchSize.INSTANCE.release(this.buffer);
    }
}

