/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.RecyclableArrayList;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Collections;

final class FixedCompositeByteBuf
extends AbstractReferenceCountedByteBuf {
    private static final ByteBuf[] EMPTY = new ByteBuf[]{Unpooled.EMPTY_BUFFER};
    private final int nioBufferCount;
    private final int capacity;
    private final ByteBufAllocator allocator;
    private final ByteOrder order;
    private final ByteBuf[] buffers;
    private final boolean direct;

    FixedCompositeByteBuf(ByteBufAllocator byteBufAllocator, ByteBuf ... byteBufArray) {
        super(Integer.MAX_VALUE);
        if (byteBufArray.length == 0) {
            this.buffers = EMPTY;
            this.order = ByteOrder.BIG_ENDIAN;
            this.nioBufferCount = 1;
            this.capacity = 0;
            this.direct = Unpooled.EMPTY_BUFFER.isDirect();
        } else {
            ByteBuf byteBuf = byteBufArray[0];
            this.buffers = byteBufArray;
            boolean bl = true;
            int n = byteBuf.nioBufferCount();
            int n2 = byteBuf.readableBytes();
            this.order = byteBuf.order();
            for (int i = 1; i < byteBufArray.length; ++i) {
                byteBuf = byteBufArray[i];
                if (byteBufArray[i].order() != this.order) {
                    throw new IllegalArgumentException("All ByteBufs need to have same ByteOrder");
                }
                n += byteBuf.nioBufferCount();
                n2 += byteBuf.readableBytes();
                if (byteBuf.isDirect()) continue;
                bl = false;
            }
            this.nioBufferCount = n;
            this.capacity = n2;
            this.direct = bl;
        }
        ((ByteBuf)this).setIndex(0, ((ByteBuf)this).capacity());
        this.allocator = byteBufAllocator;
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public final boolean isWritable(int n) {
        return false;
    }

    @Override
    public final ByteBuf discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setByte(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setByte(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setShort(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setShort(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setShortLE(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setMedium(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setMedium(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setMediumLE(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setInt(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setInt(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setIntLE(int n, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBuf setLong(int n, long l) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setLong(int n, long l) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected final void _setLongLE(int n, long l) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int setBytes(int n, InputStream inputStream, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int maxCapacity() {
        return this.capacity;
    }

    @Override
    public final ByteBuf capacity(int n) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return this.order;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final boolean isDirect() {
        return this.direct;
    }

    private Component findComponent(int n) {
        int n2 = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            Component component = null;
            ByteBuf byteBuf = this.buffers[i];
            if (byteBuf instanceof Component) {
                component = (Component)byteBuf;
                byteBuf = component.buf;
            }
            if (n >= (n2 += byteBuf.readableBytes())) continue;
            if (component == null) {
                component = new Component(i, n2 - byteBuf.readableBytes(), byteBuf);
                this.buffers[i] = component;
            }
            return component;
        }
        throw new IllegalStateException();
    }

    private ByteBuf buffer(int n) {
        ByteBuf byteBuf = this.buffers[n];
        if (byteBuf instanceof Component) {
            return ((Component)byteBuf).buf;
        }
        return byteBuf;
    }

    @Override
    public final byte getByte(int n) {
        return this._getByte(n);
    }

    @Override
    protected final byte _getByte(int n) {
        Component component = this.findComponent(n);
        return component.buf.getByte(n - component.offset);
    }

    @Override
    protected final short _getShort(int n) {
        Component component = this.findComponent(n);
        if (n + 2 <= component.endOffset) {
            return component.buf.getShort(n - component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(n) & 0xFF) << 8 | this._getByte(n + 1) & 0xFF);
        }
        return (short)(this._getByte(n) & 0xFF | (this._getByte(n + 1) & 0xFF) << 8);
    }

    @Override
    protected final short _getShortLE(int n) {
        Component component = this.findComponent(n);
        if (n + 2 <= component.endOffset) {
            return component.buf.getShortLE(n - component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(n) & 0xFF | (this._getByte(n + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(n) & 0xFF) << 8 | this._getByte(n + 1) & 0xFF);
    }

    @Override
    protected final int _getUnsignedMedium(int n) {
        Component component = this.findComponent(n);
        if (n + 3 <= component.endOffset) {
            return component.buf.getUnsignedMedium(n - component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n) & 0xFFFF) << 8 | this._getByte(n + 2) & 0xFF;
        }
        return this._getShort(n) & 0xFFFF | (this._getByte(n + 2) & 0xFF) << 16;
    }

    @Override
    protected final int _getUnsignedMediumLE(int n) {
        Component component = this.findComponent(n);
        if (n + 3 <= component.endOffset) {
            return component.buf.getUnsignedMediumLE(n - component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n) & 0xFFFF | (this._getByte(n + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(n) & 0xFFFF) << 8 | this._getByte(n + 2) & 0xFF;
    }

    @Override
    protected final int _getInt(int n) {
        Component component = this.findComponent(n);
        if (n + 4 <= component.endOffset) {
            return component.buf.getInt(n - component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n) & 0xFFFF) << 16 | this._getShort(n + 2) & 0xFFFF;
        }
        return this._getShort(n) & 0xFFFF | (this._getShort(n + 2) & 0xFFFF) << 16;
    }

    @Override
    protected final int _getIntLE(int n) {
        Component component = this.findComponent(n);
        if (n + 4 <= component.endOffset) {
            return component.buf.getIntLE(n - component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n) & 0xFFFF | (this._getShortLE(n + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(n) & 0xFFFF) << 16 | this._getShortLE(n + 2) & 0xFFFF;
    }

    @Override
    protected final long _getLong(int n) {
        Component component = this.findComponent(n);
        if (n + 8 <= component.endOffset) {
            return component.buf.getLong(n - component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(n) & 0xFFFFFFFFL) << 32 | (long)this._getInt(n + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(n) & 0xFFFFFFFFL | ((long)this._getInt(n + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    protected final long _getLongLE(int n) {
        Component component = this.findComponent(n);
        if (n + 8 <= component.endOffset) {
            return component.buf.getLongLE(n - component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(n) & 0xFFFFFFFFL | ((long)this._getIntLE(n + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(n) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE(n + 4) & 0xFFFFFFFFL;
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byArray.length);
        if (n3 == 0) {
            return this;
        }
        ByteBuf byteBuf = this.findComponent(n);
        int n4 = ((Component)byteBuf).index;
        int n5 = ((Component)byteBuf).offset;
        byteBuf = ((WrappedByteBuf)byteBuf).buf;
        while (true) {
            int n6 = Math.min(n3, byteBuf.readableBytes() - (n - n5));
            byteBuf.getBytes(n - n5, byArray, n2, n6);
            n += n6;
            n2 += n6;
            n5 += byteBuf.readableBytes();
            if ((n3 -= n6) <= 0) break;
            byteBuf = this.buffer(++n4);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.remaining();
        this.checkIndex(n, n3);
        if (n3 == 0) {
            return this;
        }
        try {
            ByteBuf byteBuf = this.findComponent(n);
            int n4 = ((Component)byteBuf).index;
            int n5 = ((Component)byteBuf).offset;
            byteBuf = ((WrappedByteBuf)byteBuf).buf;
            while (true) {
                int n6 = Math.min(n3, byteBuf.readableBytes() - (n - n5));
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.limit(byteBuffer2.position() + n6);
                byteBuf.getBytes(n - n5, byteBuffer);
                n += n6;
                n5 += byteBuf.readableBytes();
                if ((n3 -= n6) > 0) {
                    byteBuf = this.buffer(++n4);
                    continue;
                }
                break;
            }
        }
        finally {
            byteBuffer.limit(n2);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byteBuf.capacity());
        if (n3 == 0) {
            return this;
        }
        ByteBuf byteBuf2 = this.findComponent(n);
        int n4 = ((Component)byteBuf2).index;
        int n5 = ((Component)byteBuf2).offset;
        byteBuf2 = ((WrappedByteBuf)byteBuf2).buf;
        while (true) {
            int n6 = Math.min(n3, byteBuf2.readableBytes() - (n - n5));
            byteBuf2.getBytes(n - n5, byteBuf, n2, n6);
            n += n6;
            n2 += n6;
            n5 += byteBuf2.readableBytes();
            if ((n3 -= n6) <= 0) break;
            byteBuf2 = this.buffer(++n4);
        }
        return this;
    }

    @Override
    public final int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        int n3 = ((ByteBuf)this).nioBufferCount();
        if (n3 == 1) {
            return gatheringByteChannel.write(((ByteBuf)this).internalNioBuffer(n, n2));
        }
        long l = gatheringByteChannel.write(((ByteBuf)this).nioBuffers(n, n2));
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public final int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        int n3 = ((ByteBuf)this).nioBufferCount();
        if (n3 == 1) {
            return fileChannel.write(((ByteBuf)this).internalNioBuffer(n, n2), l);
        }
        long l2 = 0L;
        for (ByteBuffer byteBuffer : ((ByteBuf)this).nioBuffers(n, n2)) {
            l2 += (long)fileChannel.write(byteBuffer, l + l2);
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public final ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return this;
        }
        ByteBuf byteBuf = this.findComponent(n);
        int n3 = ((Component)byteBuf).index;
        int n4 = ((Component)byteBuf).offset;
        byteBuf = ((WrappedByteBuf)byteBuf).buf;
        while (true) {
            int n5 = Math.min(n2, byteBuf.readableBytes() - (n - n4));
            byteBuf.getBytes(n - n4, outputStream, n5);
            n += n5;
            n4 += byteBuf.readableBytes();
            if ((n2 -= n5) <= 0) break;
            byteBuf = this.buffer(++n3);
        }
        return this;
    }

    @Override
    public final ByteBuf copy(int n, int n2) {
        this.checkIndex(n, n2);
        boolean bl = true;
        ByteBuf byteBuf = ((ByteBuf)this).alloc().buffer(n2);
        try {
            byteBuf.writeBytes(this, n, n2);
            bl = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        catch (Throwable throwable) {
            if (bl) {
                byteBuf.release();
            }
            throw throwable;
        }
    }

    @Override
    public final int nioBufferCount() {
        return this.nioBufferCount;
    }

    @Override
    public final ByteBuffer nioBuffer(int n, int n2) {
        Comparable<ByteBuf> comparable;
        this.checkIndex(n, n2);
        if (this.buffers.length == 1 && ((ByteBuf)(comparable = this.buffer(0))).nioBufferCount() == 1) {
            return ((ByteBuf)comparable).nioBuffer(n, n2);
        }
        comparable = ByteBuffer.allocate(n2).order(((ByteBuf)this).order());
        ByteBuffer[] byteBufferArray = ((ByteBuf)this).nioBuffers(n, n2);
        for (n2 = 0; n2 < byteBufferArray.length; ++n2) {
            ((ByteBuffer)comparable).put(byteBufferArray[n2]);
        }
        ((ByteBuffer)comparable).flip();
        return comparable;
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n, int n2) {
        if (this.buffers.length == 1) {
            return this.buffer(0).internalNioBuffer(n, n2);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return EmptyArrays.EMPTY_BYTE_BUFFERS;
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance((int)this.buffers.length);
        try {
            ByteBuf byteBuf = this.findComponent(n);
            int n3 = ((Component)byteBuf).index;
            int n4 = ((Component)byteBuf).offset;
            byteBuf = ((WrappedByteBuf)byteBuf).buf;
            while (true) {
                int n5 = Math.min(n2, byteBuf.readableBytes() - (n - n4));
                switch (byteBuf.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        recyclableArrayList.add((Object)byteBuf.nioBuffer(n - n4, n5));
                        break;
                    }
                    default: {
                        Collections.addAll(recyclableArrayList, byteBuf.nioBuffers(n - n4, n5));
                    }
                }
                n += n5;
                n4 += byteBuf.readableBytes();
                if ((n2 -= n5) <= 0) break;
                byteBuf = this.buffer(++n3);
            }
            ByteBuffer[] byteBufferArray = (ByteBuffer[])recyclableArrayList.toArray((Object[])EmptyArrays.EMPTY_BYTE_BUFFERS);
            return byteBufferArray;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    @Override
    public final boolean hasArray() {
        switch (this.buffers.length) {
            case 0: {
                return true;
            }
            case 1: {
                return this.buffer(0).hasArray();
            }
        }
        return false;
    }

    @Override
    public final byte[] array() {
        switch (this.buffers.length) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.buffer(0).array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final int arrayOffset() {
        switch (this.buffers.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.buffer(0).arrayOffset();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasMemoryAddress() {
        switch (this.buffers.length) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.buffer(0).hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public final long memoryAddress() {
        switch (this.buffers.length) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                return this.buffer(0).memoryAddress();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void deallocate() {
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffer(i).release();
        }
    }

    @Override
    public final String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        return string + ", components=" + this.buffers.length + ')';
    }

    private static final class Component
    extends WrappedByteBuf {
        private final int index;
        private final int offset;
        private final int endOffset;

        Component(int n, int n2, ByteBuf byteBuf) {
            super(byteBuf);
            this.index = n;
            this.offset = n2;
            this.endOffset = n2 + byteBuf.readableBytes();
        }
    }
}

