/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.classic.util.ClassicEnvUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareImpl;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.util.Comparator;
import java.util.List;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    String[] INTERNAL_CONFIGURATOR_CLASSNAME_LIST = new String[]{"ch.qos.logback.classic.joran.SerializedModelConfigurator", "ch.qos.logback.classic.util.DefaultJoranConfigurator", "ch.qos.logback.classic.BasicConfigurator"};
    final LoggerContext loggerContext;
    final ContextAware contextAware;
    Comparator<Configurator> rankComparator = new Comparator<Configurator>(){

        @Override
        public int compare(Configurator object, Configurator object2) {
            object = object.getClass().getAnnotation(ConfiguratorRank.class);
            object2 = object2.getClass().getAnnotation(ConfiguratorRank.class);
            int n = object == null ? 20 : object.value();
            int n2 = object2 == null ? 20 : object2.value();
            n = ContextInitializer.this.compareRankValue(n, n2);
            return -n;
        }
    };

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
        this.contextAware = new ContextAwareImpl((Context)loggerContext, (Object)this);
    }

    public void autoConfig() {
        this.autoConfig(Configurator.class.getClassLoader());
    }

    public void autoConfig(ClassLoader classLoader) {
        classLoader = Loader.systemClassloaderIfNull((ClassLoader)classLoader);
        Object object = EnvUtil.logbackVersion();
        if (object == null) {
            object = "?";
        }
        this.loggerContext.getStatusManager().add((Status)new InfoStatus("This is logback-classic version " + (String)object, (Object)this.loggerContext));
        StatusListenerConfigHelper.installIfAsked((Context)this.loggerContext);
        object = ClassicEnvUtil.loadFromServiceLoader(Configurator.class, classLoader);
        object.sort(this.rankComparator);
        if (object.isEmpty()) {
            this.contextAware.addInfo("No custom configurators were discovered as a service.");
        } else {
            this.printConfiguratorOrder((List<Configurator>)object);
        }
        for (Configurator configurator : object) {
            if (this.invokeConfigure(configurator) != Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
        object = this.INTERNAL_CONFIGURATOR_CLASSNAME_LIST;
        int n = this.INTERNAL_CONFIGURATOR_CLASSNAME_LIST.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = object[i];
            this.contextAware.addInfo("Trying to configure with " + (String)object2);
            object2 = this.instantiateConfiguratorByClassName((String)object2, classLoader);
            if (object2 == null || this.invokeConfigure((Configurator)object2) != Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
    }

    private Configurator instantiateConfiguratorByClassName(String object, ClassLoader classLoader) {
        try {
            object = classLoader.loadClass((String)object);
            return (Configurator)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            this.contextAware.addInfo("Instantiation failure: " + reflectiveOperationException.toString());
            return null;
        }
    }

    private Configurator.ExecutionStatus invokeConfigure(Configurator configurator) {
        try {
            long l = System.currentTimeMillis();
            this.contextAware.addInfo("Constructed configurator of type " + String.valueOf(configurator.getClass()));
            configurator.setContext((Context)this.loggerContext);
            Configurator.ExecutionStatus executionStatus = configurator.configure(this.loggerContext);
            this.printDuration(l, configurator, executionStatus);
            return executionStatus;
        }
        catch (Exception exception) {
            throw new LogbackException(String.format("Failed to initialize or to run Configurator: %s", configurator != null ? configurator.getClass().getCanonicalName() : "null"), (Throwable)exception);
        }
    }

    private void printConfiguratorOrder(List<Configurator> object) {
        this.contextAware.addInfo("Here is a list of configurators discovered as a service, by rank: ");
        object = object.iterator();
        while (object.hasNext()) {
            Configurator configurator = (Configurator)object.next();
            this.contextAware.addInfo("  " + configurator.getClass().getName());
        }
        this.contextAware.addInfo("They will be invoked in order until ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY is returned.");
    }

    private void printDuration(long l, Configurator configurator, Configurator.ExecutionStatus executionStatus) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.contextAware.addInfo(configurator.getClass().getName() + ".configure() call lasted " + l3 + " milliseconds. ExecutionStatus=" + String.valueOf((Object)executionStatus));
    }

    private Configurator.ExecutionStatus attemptConfigurationUsingJoranUsingReflexion(ClassLoader object) {
        try {
            object = ((ClassLoader)object).loadClass("ch.qos.logback.classic.util.DefaultJoranConfigurator");
            object = (Configurator)((Class)object).newInstance();
            object.setContext((Context)this.loggerContext);
            return object.configure(this.loggerContext);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            this.contextAware.addError("unexpected exception while instantiating DefaultJoranConfigurator", (Throwable)reflectiveOperationException);
            return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
        }
    }

    private int compareRankValue(int n, int n2) {
        if (n > n2) {
            return 1;
        }
        if (n == n2) {
            return 0;
        }
        return -1;
    }
}

